/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.util.codec.ReduxCodecs;
import net.zepalesque.redux.util.holder.RegistryMap;

public record WaterModifier(Optional<DefaultWaterSettings> settings, RegistryMap<Biome, Integer> waterMap, RegistryMap<Biome, Integer> fogMap) implements BiomeModifier
{
    public static final Codec<WaterModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DefaultWaterSettings.CODEC.optionalFieldOf("default_colors").forGetter(WaterModifier::settings), (App)ReduxCodecs.MAP_CODEC.fieldOf("water_map").forGetter(WaterModifier::waterMap), (App)ReduxCodecs.MAP_CODEC.fieldOf("fog_map").forGetter(WaterModifier::fogMap)).apply((Applicative)builder, WaterModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && (this.settings.isEmpty() || this.settings.get().biomes.m_203333_(biome))) {
            if (this.settings.isPresent()) {
                this.settings.get().water.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48034_(arg_0));
                this.settings.get().fog.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48037_(arg_0));
            }
            this.waterMap.get(biome).ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48034_(arg_0));
            this.fogMap.get(biome).ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48037_(arg_0));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    public record DefaultWaterSettings(HolderSet<Biome> biomes, Optional<Integer> water, Optional<Integer> fog) {
        public static final Codec<DefaultWaterSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(DefaultWaterSettings::biomes), (App)Codec.INT.optionalFieldOf("water").forGetter(DefaultWaterSettings::water), (App)Codec.INT.optionalFieldOf("fog").forGetter(DefaultWaterSettings::fog)).apply((Applicative)builder, DefaultWaterSettings::new));
    }
}

