/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.util.codec.ReduxCodecs;
import net.zepalesque.redux.util.holder.RegistryMap;

public record SkiesModifier(Optional<DefaultSkySettings> settings, RegistryMap<Biome, Integer> skyMap, RegistryMap<Biome, Integer> fogMap) implements BiomeModifier
{
    public static final Codec<SkiesModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DefaultSkySettings.CODEC.optionalFieldOf("default_colors").forGetter(SkiesModifier::settings), (App)ReduxCodecs.MAP_CODEC.fieldOf("sky_map").forGetter(SkiesModifier::skyMap), (App)ReduxCodecs.MAP_CODEC.fieldOf("fog_map").forGetter(SkiesModifier::fogMap)).apply((Applicative)builder, SkiesModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && (this.settings.isEmpty() || this.settings.get().biomes.m_203333_(biome))) {
            if (this.settings.isPresent()) {
                this.settings.get().sky.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48040_(arg_0));
                this.settings.get().fog.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48019_(arg_0));
            }
            this.skyMap.get(biome).ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48040_(arg_0));
            this.fogMap.get(biome).ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48019_(arg_0));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    public record DefaultSkySettings(HolderSet<Biome> biomes, Optional<Integer> sky, Optional<Integer> fog) {
        public static final Codec<DefaultSkySettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(DefaultSkySettings::biomes), (App)Codec.INT.optionalFieldOf("sky").forGetter(DefaultSkySettings::sky), (App)Codec.INT.optionalFieldOf("fog").forGetter(DefaultSkySettings::fog)).apply((Applicative)builder, DefaultSkySettings::new));
    }
}

