/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.SyncAetherGrassesPacket;
import net.zepalesque.redux.util.codec.ReduxCodecs;
import net.zepalesque.redux.util.holder.RegistryMap;

public record AetherGrassColors(RegistryMap<Biome, Integer> colorMap) implements BiomeModifier
{
    public static Map<ResourceLocation, Integer> SERVER_MAP = new HashMap<ResourceLocation, Integer>();
    public static final Codec<AetherGrassColors> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ReduxCodecs.MAP_CODEC.fieldOf("colormap").forGetter(AetherGrassColors::colorMap)).apply((Applicative)builder, AetherGrassColors::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING) {
            Optional key = biome.m_203543_();
            key.ifPresent(biomeResourceKey -> this.colorMap.get(biome).ifPresent(color -> SERVER_MAP.put(biomeResourceKey.m_135782_(), (Integer)color)));
        }
    }

    public static void sendToClient(ServerPlayer player) {
        ReduxPacketHandler.sendToPlayer(new SyncAetherGrassesPacket(SERVER_MAP), player);
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

