/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class WorldgenUtil {
    public static BlockPos.MutableBlockPos setWithOffset(BlockPos.MutableBlockPos mutable, Vec3i origin, Direction direction, int amount) {
        return mutable.m_122178_(origin.m_123341_() + direction.m_122429_() * amount, origin.m_123342_() + direction.m_122430_() * amount, origin.m_123343_() + direction.m_122431_() * amount);
    }

    public static Property<WallSide> getWallSide(Direction d) {
        if (d.m_122434_() == Direction.Axis.Y) {
            throw new IllegalArgumentException("Cannot use non-y-axis direction!");
        }
        return d == Direction.NORTH ? BlockStateProperties.f_61379_ : (d == Direction.EAST ? BlockStateProperties.f_61378_ : (d == Direction.WEST ? BlockStateProperties.f_61381_ : BlockStateProperties.f_61380_));
    }

    public static void placeRootsDisk(WorldGenLevel level, BlockStateProvider blockProvider, BlockPos center, float radius, RandomSource random, float chance, BlockStateProvider blockAbove) {
        float radiusSq = radius * radius;
        if (random.m_188501_() <= chance) {
            WorldgenUtil.placeProvidedBlock(level, blockProvider, center, random);
        }
        int z = 0;
        while ((float)z < radius) {
            int x = 0;
            while ((float)x < radius) {
                if (!((float)(x * x + z * z) > radiusSq)) {
                    if (random.m_188501_() <= chance) {
                        WorldgenUtil.placeProvidedBlockUnderBlock(level, blockProvider, center.m_7918_(x, 0, z), random, blockAbove);
                    }
                    if (random.m_188501_() <= chance) {
                        WorldgenUtil.placeProvidedBlockUnderBlock(level, blockProvider, center.m_7918_(-x, 0, -z), random, blockAbove);
                    }
                    if (random.m_188501_() <= chance) {
                        WorldgenUtil.placeProvidedBlockUnderBlock(level, blockProvider, center.m_7918_(-z, 0, x), random, blockAbove);
                    }
                    if (random.m_188501_() <= chance) {
                        WorldgenUtil.placeProvidedBlockUnderBlock(level, blockProvider, center.m_7918_(z, 0, -x), random, blockAbove);
                    }
                }
                ++x;
            }
            ++z;
        }
    }

    public static void placeProvidedBlock(WorldGenLevel level, BlockStateProvider provider, BlockPos pos, RandomSource random) {
        if (level.m_8055_(pos).m_60795_()) {
            level.m_7731_(pos, provider.m_213972_(random, pos), 2);
        }
    }

    public static void placeProvidedBlockUnderBlock(WorldGenLevel level, BlockStateProvider provider, BlockPos pos, RandomSource random, BlockStateProvider requiredBlock) {
        if (level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60713_(requiredBlock.m_213972_(random, pos.m_7494_()).m_60734_())) {
            level.m_7731_(pos, provider.m_213972_(random, pos), 2);
        }
    }

    public static <V extends Comparable<V>> BlockState trySetValue(BlockState state, Property<V> prop, V val) {
        if (state.m_61138_(prop)) {
            return (BlockState)state.m_61124_(prop, val);
        }
        return state;
    }
}

