/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.compat;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.natural.AercloudBlock;
import com.aetherteam.aether_genesis.GenesisConfig;
import com.aetherteam.aether_genesis.block.GenesisBlocks;
import com.aetherteam.aether_genesis.client.particle.GenesisParticleTypes;
import com.aetherteam.aether_genesis.entity.GenesisEntityTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.MimicModelType;
import org.jetbrains.annotations.Nullable;

public class GenesisCompatUtil {
    private static final Lazy<Map<Block, Supplier<? extends ParticleOptions>>> PARTICLE_MAP = Lazy.of(() -> new ImmutableMap.Builder().put((Object)((Block)GenesisBlocks.BLUE_SKYROOT_LEAVES.get()), ReduxParticleTypes.FALLING_BLUE_SKYROOT_LEAVES).put((Object)((Block)GenesisBlocks.DARK_BLUE_SKYROOT_LEAVES.get()), ReduxParticleTypes.FALLING_DARK_BLUE_SKYROOT_LEAVES).build());

    @Nullable
    public static Supplier<? extends ParticleOptions> getParticle(Block self) {
        return (Supplier)((Map)PARTICLE_MAP.get()).get(self);
    }

    public static boolean isPurpleCrystal(Supplier<? extends ParticleOptions> particle) {
        return particle == GenesisParticleTypes.PURPLE_CRYSTAL_LEAVES;
    }

    public static boolean isPurpleCrystal(ParticleOptions particle) {
        return particle == GenesisParticleTypes.PURPLE_CRYSTAL_LEAVES.get();
    }

    public static void addGenesisNames(ImmutableMap.Builder<EntityType<?>, Supplier<Boolean>> builder) {
        if (Redux.aetherGenesisCompat()) {
            builder.put((Object)((EntityType)GenesisEntityTypes.BATTLE_SENTRY.get()), (Object)ReduxConfig.CLIENT.sentry_model_upgrade).put((Object)((EntityType)GenesisEntityTypes.SKYROOT_MIMIC.get()), () -> ((MimicModelType)((Object)((Object)ReduxConfig.CLIENT.mimic_model_upgrade.get()))).shouldUseModern());
        }
    }

    public static boolean goldCloudSFX(AercloudBlock block) {
        if (!Redux.aetherGenesisCompat()) {
            return false;
        }
        return block == AetherBlocks.GOLDEN_AERCLOUD.get() && (Boolean)GenesisConfig.COMMON.gold_aercloud_ability.get() != false;
    }
}

