/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.common.block;

import com.aetherteam.aether.block.natural.LeavesWithParticlesBlock;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.block.natural.ExtendedDistanceLeavesBlock;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.util.compat.GenesisCompatUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeavesWithParticlesBlock.class})
public class ParticleLeavesMixin {
    @Shadow
    @Final
    private Supplier<? extends ParticleOptions> particle;

    @Inject(method={"animateTick"}, at={@At(value="RETURN")})
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random, CallbackInfo ci, @Share(value="replace") LocalBooleanRef shouldReplaceParticle) {
        if (level.m_5776_() && shouldReplaceParticle.get()) {
            BlockPos blockpos;
            BlockState blockstate;
            ParticleOptions newParticle = ParticleLeavesMixin.getReplacementParticle(this.particle.get());
            if (newParticle == null) {
                throw new NullPointerException("ParticleOptions cannot be null!");
            }
            if (!(random.m_188503_(15) != 0 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP) || blockstate.m_60734_() instanceof LeavesBlock || blockstate.m_60734_() instanceof ExtendedDistanceLeavesBlock)) {
                ParticleUtils.m_272037_((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)newParticle);
            }
        }
    }

    @WrapWithCondition(method={"animateTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    public boolean redirectParticleOverride(Level instance, ParticleOptions pParticleData, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, @Share(value="replace") LocalBooleanRef shouldReplaceParticle) {
        return !shouldReplaceParticle.get();
    }

    @ModifyExpressionValue(method={"animateTick"}, at={@At(value="INVOKE", target="net/minecraft/world/level/Level.isClientSide()Z")})
    public boolean onAnimateTick(boolean isClientSide, BlockState state, Level level, BlockPos pos, RandomSource random, @Share(value="replace") LocalBooleanRef shouldReplaceParticle) {
        if (isClientSide) {
            shouldReplaceParticle.set((Boolean)ReduxConfig.CLIENT.better_leaf_particles.get() != false && (this.particle == AetherParticleTypes.GOLDEN_OAK_LEAVES || this.particle == AetherParticleTypes.CRYSTAL_LEAVES || this.particle == ReduxParticleTypes.GILDED_SKYROOT_LEAVES || Redux.aetherGenesisCompat() && GenesisCompatUtil.isPurpleCrystal(this.particle)));
        }
        return isClientSide;
    }

    @Unique
    private static <T extends ParticleOptions> ParticleOptions getReplacementParticle(T particle) {
        return (Boolean)ReduxConfig.CLIENT.better_leaf_particles.get() == false ? null : (particle == AetherParticleTypes.GOLDEN_OAK_LEAVES.get() ? (ParticleOptions)ReduxParticleTypes.FALLING_GOLDEN_LEAVES.get() : (particle == AetherParticleTypes.CRYSTAL_LEAVES.get() ? (ParticleOptions)ReduxParticleTypes.FALLING_CRYSTAL_LEAVES.get() : (particle == ReduxParticleTypes.GILDED_SKYROOT_LEAVES.get() ? (ParticleOptions)ReduxParticleTypes.FALLING_GILDED_LEAVES.get() : (Redux.aetherGenesisCompat() && GenesisCompatUtil.isPurpleCrystal(particle) ? (ParticleOptions)ReduxParticleTypes.FALLING_PURPLE_CRYSTAL_LEAVES.get() : null))));
    }
}

