/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.client.render.model;

import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.zepalesque.redux.capability.animation.moa.MoaAnimation;
import net.zepalesque.redux.client.render.util.MoaUtils;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.MoaModelType;
import net.zepalesque.redux.mixin.client.render.model.BipedBirdModelMixin;
import net.zepalesque.redux.util.math.MathUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MoaModel.class})
public class MoaModelMixin
extends BipedBirdModelMixin<Moa> {
    @Shadow(remap=false)
    public boolean renderLegs;
    @Unique
    public boolean useNewModel;

    @Inject(method={"setupAnim(Lcom/aetherteam/aether/entity/passive/Moa;FFFFF)V"}, at={@At(value="TAIL")}, remap=false)
    public void setupAnim(Moa moa, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (this.useNewModel && !moa.isSitting()) {
            this.jaw.f_104203_ = 0.15f;
        }
        float partial = Minecraft.m_91087_().getPartialTick();
        if (ReduxConfig.CLIENT.moa_model_type.get() == MoaModelType.refreshed) {
            float progress = moa.isEntityOnGround() ? 0.0f : 1.0f;
            float swingCalc = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (MoaAnimation.get(moa).isPresent()) {
                MoaAnimation moaAnimation = (MoaAnimation)MoaAnimation.get(moa).orElseThrow(() -> new IllegalStateException("Could not find MoaAnimation capability!"));
                progress = Mth.m_14179_((float)partial, (float)moaAnimation.getPrevLegAnim(), (float)moaAnimation.getLegAnim()) * 0.2f;
            }
            this.rightLeg.f_104203_ = MathUtil.costrp(progress, swingCalc, 0.6f);
            this.leftLeg.f_104203_ = MathUtil.costrp(progress, -swingCalc, 0.6f);
        }
    }

    @Inject(method={"prepareMobModel(Lcom/aetherteam/aether/entity/passive/Moa;FFF)V"}, at={@At(value="TAIL")}, remap=false)
    public void redux$moaPrepare(Moa moa, float limbSwing, float limbSwingAmount, float partialTicks, CallbackInfo ci) {
        this.useNewModel = MoaUtils.useNewModel(moa);
        this.renderLegs = (!moa.isSitting() || !moa.isEntityOnGround() && moa.isSitting()) && (!this.useNewModel || ReduxConfig.CLIENT.moa_model_type.get() == MoaModelType.refreshed);
    }

    @Inject(method={"renderToBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        this.leftWing.f_233556_ = this.useNewModel;
        this.rightWing.f_233556_ = this.useNewModel;
        this.body.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        if (!this.useNewModel) {
            this.head.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.rightTailFeather.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.middleTailFeather.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.leftTailFeather.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        }
        if (this.renderLegs) {
            this.rightLeg.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.leftLeg.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        }
        ci.cancel();
    }
}

