/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DungeonLootModifier
extends LootModifier {
    public static final Codec<DungeonLootModifier> CODEC = RecordCodecBuilder.create(instance -> DungeonLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)WeightedEntry.Wrapper.m_146305_((Codec)ItemStack.f_41582_).listOf().fieldOf("entries").forGetter(modifier -> modifier.entries)).and((App)IntProvider.f_146531_.fieldOf("rolls").forGetter(modifier -> modifier.rolls)).apply((Applicative)instance, DungeonLootModifier::new));
    public final List<WeightedEntry.Wrapper<ItemStack>> entries;
    public final IntProvider rolls;

    public DungeonLootModifier(LootItemCondition[] conditionsIn, List<WeightedEntry.Wrapper<ItemStack>> entries, IntProvider rolls) {
        super(conditionsIn);
        this.entries = entries.stream().map(wrapper -> WeightedEntry.m_146290_((Object)((ItemStack)wrapper.m_146310_()).m_41777_(), (int)wrapper.m_142631_().m_146281_())).toList();
        this.rolls = rolls;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource randomSource = context.m_230907_();
        Vec3 vec3 = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (vec3 != null) {
            BlockPos pos = BlockPos.m_274446_((Position)vec3);
            BlockEntity blockEntity = context.m_78952_().m_7702_(pos);
            if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity containerBlockEntity = (BaseContainerBlockEntity)blockEntity;
                int rollCount = this.rolls.m_214085_(randomSource);
                for (int i = 0; i < rollCount; ++i) {
                    boolean isFull;
                    boolean bl = isFull = generatedLoot.size() == containerBlockEntity.m_6643_();
                    if (isFull) continue;
                    int weight = this.entries.stream().map(entry -> entry.m_142631_().m_146281_()).reduce(0, Integer::sum);
                    WeightedRandom.m_216825_((RandomSource)randomSource, this.entries, (int)weight).ifPresent(e -> generatedLoot.add((Object)((ItemStack)e.m_146310_()).m_41777_()));
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

