/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.tools;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.zepalesque.redux.item.tools.VeridiumItem;
import net.zepalesque.redux.item.util.TooltipUtils;
import org.jetbrains.annotations.Nullable;

public class VeridiumHoeItem
extends HoeItem
implements VeridiumItem {
    private final Supplier<? extends Item> uninfused;

    public VeridiumHoeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties, Supplier<? extends Item> uninfused) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        this.uninfused = uninfused;
    }

    @Override
    public Item getUninfusedItem(ItemStack stack) {
        return this.uninfused.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag advanced) {
        MutableComponent infusion = Component.m_237110_((String)"tooltip.aether_redux.infusion_charge", (Object[])new Object[]{stack.m_41783_() == null ? (byte)0 : stack.m_41783_().m_128445_("infusion_level")}).m_130940_(ChatFormatting.GRAY);
        tooltips.add((Component)infusion);
        Component info = TooltipUtils.shiftForInfo(HOVER_TOOLTIP);
        tooltips.add(info);
        super.m_7373_(stack, level, tooltips, advanced);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean bool = super.m_7579_(stack, target, attacker);
        ItemStack transform = this.deplete(stack, attacker, 2);
        if (!attacker.m_9236_().m_5776_() && transform != null && transform != stack) {
            attacker.m_8061_(EquipmentSlot.MAINHAND, transform);
            if (attacker instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)attacker;
                this.sendSound(sp);
            }
        }
        return bool;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity user) {
        boolean bool = super.m_6813_(stack, level, state, pos, user);
        if (!user.m_9236_().m_5776_()) {
            boolean instaBreak;
            boolean bl = instaBreak = state.m_60800_((BlockGetter)level, pos) <= 0.0f;
            if (!instaBreak) {
                int amount = stack.m_41735_(state) ? 1 : 2;
                ItemStack transform = this.deplete(stack, user, amount);
                if (!user.m_9236_().m_5776_() && transform != null && transform != stack) {
                    user.m_8061_(EquipmentSlot.MAINHAND, transform);
                    if (user instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)user;
                        this.sendSound(sp);
                    }
                }
            }
        }
        return bool;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = super.m_6225_(context);
        if (result == InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) && !context.m_43723_().m_9236_().m_5776_() && !context.m_43723_().m_7500_()) {
            ItemStack stack = context.m_43722_();
            Player player = context.m_43723_();
            ItemStack transform = this.deplete(stack, (LivingEntity)player, 1);
            if (!player.m_9236_().m_5776_() && transform != null && transform != stack) {
                player.m_8061_(EquipmentSlot.MAINHAND, transform);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    this.sendSound(sp);
                }
            }
        }
        return result;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, amount, entity, onBroken) * 4;
    }

    public static class Uninfused
    extends HoeItem {
        public Uninfused(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
            super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag advanced) {
            Component info = TooltipUtils.shiftForInfo(VeridiumItem.HOVER_TOOLTIP);
            tooltips.add(info);
            super.m_7373_(stack, level, tooltips, advanced);
        }
    }
}

