/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.hook;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.loot.AetherLootContexts;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.blockhandlers.WoodHandlers;
import net.zepalesque.redux.loot.ReduxLoot;

public class ToolModifHooks {
    public static final Map<Block, Block> STRIPPABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().build());
    public static final Map<Block, Block> FLATTENABLES;
    public static final Map<Block, Block> TILLABLES;

    public static BlockState setupToolActions(LevelAccessor accessor, BlockPos pos, BlockState old, ToolAction action) {
        Block oldBlock = old.m_60734_();
        if (action == ToolActions.AXE_STRIP) {
            if (STRIPPABLES.containsKey(oldBlock)) {
                return STRIPPABLES.get(oldBlock).m_152465_(old);
            }
        } else if (action == ToolActions.SHOVEL_FLATTEN) {
            if (FLATTENABLES.containsKey(oldBlock)) {
                return FLATTENABLES.get(oldBlock).m_152465_(old);
            }
        } else if (action == ToolActions.HOE_TILL && accessor.m_8055_(pos.m_7494_()).m_60795_() && TILLABLES.containsKey(oldBlock)) {
            return TILLABLES.get(oldBlock).m_152465_(old);
        }
        return old;
    }

    public static void stripBlightwillow(LevelAccessor accessor, BlockState state, ItemStack stack, ToolAction action, UseOnContext context) {
        if (action == ToolActions.AXE_STRIP && accessor instanceof Level) {
            Level level = (Level)accessor;
            if (WoodHandlers.BLIGHTWILLOW.sporingBlocksBlockTag.isPresent() && state.m_204336_(WoodHandlers.BLIGHTWILLOW.sporingBlocksBlockTag.get()) && stack.m_204117_(AetherTags.Items.GOLDEN_AMBER_HARVESTERS) && level.m_7654_() != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 vector = context.m_43720_();
                LootParams parameters = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287235_(AetherLootContexts.STRIPPING);
                LootTable lootTable = level.m_7654_().m_278653_().m_278676_(ReduxLoot.STRIP_BLIGHTWILLOW);
                ObjectArrayList list = lootTable.m_287195_(parameters);
                for (ItemStack itemStack : list) {
                    ItemEntity itemEntity = new ItemEntity(level, vector.m_7096_(), vector.m_7098_(), vector.m_7094_(), itemStack);
                    itemEntity.m_32060_();
                    level.m_7967_((Entity)itemEntity);
                }
            }
        }
    }

    static {
        for (WoodHandler woodHandler : Redux.WOOD_HANDLERS) {
            if (!woodHandler.hasStrippedLogs) continue;
            woodHandler.strippedLog.ifPresent(block -> {
                STRIPPABLES.put((Block)woodHandler.log.get(), (Block)block.get());
                woodHandler.sporingLog.ifPresent(block1 -> STRIPPABLES.put((Block)block1.get(), (Block)block.get()));
            });
            woodHandler.strippedWood.ifPresent(block -> {
                STRIPPABLES.put((Block)woodHandler.wood.get(), (Block)block.get());
                woodHandler.sporingWood.ifPresent(block1 -> STRIPPABLES.put((Block)block1.get(), (Block)block.get()));
            });
            woodHandler.strippedLogWall.ifPresent(block -> STRIPPABLES.put((Block)woodHandler.logWall.get(), (Block)block.get()));
            woodHandler.strippedWoodWall.ifPresent(block -> STRIPPABLES.put((Block)woodHandler.woodWall.get(), (Block)block.get()));
        }
        FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)((Block)ReduxBlocks.AVELIUM.get()), (Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get())).put((Object)((Block)ReduxBlocks.BLIGHTED_AETHER_GRASS_BLOCK.get()), (Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get())).build());
        TILLABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)((Block)ReduxBlocks.AVELIUM.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((Block)ReduxBlocks.BLIGHTED_AETHER_GRASS_BLOCK.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((Block)ReduxBlocks.COARSE_AETHER_DIRT.get()), (Object)((Block)AetherBlocks.AETHER_DIRT.get())).build());
    }
}

