/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.entity.projectile;

import com.aetherteam.nitrogen.entity.BossMob;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.data.resource.ReduxDamageTypes;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import org.jetbrains.annotations.Nullable;

public class Ember
extends Projectile {
    @Nullable
    private Entity cachedSource;
    @Nullable
    private UUID sourceUUID;
    @Nullable
    private ArrayList<Entity> cachedHits = new ArrayList();
    @Nullable
    private ArrayList<UUID> hitUUIDs = new ArrayList();
    public final int lifetime = 80;

    public Ember(EntityType<? extends Ember> entityType, Level level) {
        super(entityType, level);
    }

    public Ember(Level level, Player owner) {
        this((EntityType<? extends Ember>)((EntityType)ReduxEntityTypes.EMBER.get()), level);
        this.m_5602_((Entity)owner);
    }

    public Ember(Level level, Player owner, Entity source) {
        this(level, owner);
        this.setEmberSource(source);
    }

    protected void hit(Entity entity) {
        this.cachedHits.add(entity);
        this.hitUUIDs.add(entity.m_20148_());
    }

    protected void setEmberSource(Entity entity) {
        this.cachedSource = entity;
        this.sourceUUID = entity.m_20148_();
    }

    public Entity getEmberSource() {
        if (this.cachedSource != null && !this.cachedSource.m_213877_()) {
            return this.cachedSource;
        }
        if (this.sourceUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedSource = ((ServerLevel)this.m_9236_()).m_8791_(this.sourceUUID);
            return this.cachedSource;
        }
        return null;
    }

    public ArrayList<Entity> getHits() {
        Level level;
        if (this.cachedHits != null && !this.cachedHits.isEmpty()) {
            return this.cachedHits;
        }
        if (this.hitUUIDs != null && !this.hitUUIDs.isEmpty() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ArrayList<Entity> collection = new ArrayList<Entity>();
            for (UUID id : this.hitUUIDs) {
                Entity e = serverLevel.m_8791_(id);
                if (e != null && !e.m_213877_()) {
                    collection.add(e);
                    continue;
                }
                this.hitUUIDs.remove(id);
            }
            this.cachedHits = collection;
            return this.cachedHits;
        }
        return new ArrayList<Entity>();
    }

    protected boolean originatedFrom(Entity entity) {
        return entity.m_20148_().equals(this.sourceUUID);
    }

    protected boolean hasHit(Entity entity) {
        return this.hitUUIDs.contains(entity.m_20148_());
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        float f = 0.99f;
        float f1 = 0.06f;
        this.m_20256_(vec3.m_82542_(0.995, 0.99, 0.995));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        if (!this.m_20068_() && hitresult.m_6662_() != HitResult.Type.BLOCK) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            this.m_6034_(d0, d1, d2);
        }
        if (this.f_19797_ >= this.lifetime && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.sourceUUID != null) {
            compound.m_128362_("Source", this.sourceUUID);
        }
        if (this.hitUUIDs != null && !this.hitUUIDs.isEmpty()) {
            CompoundTag hits = new CompoundTag();
            for (int i = 0; i < this.hitUUIDs.size(); ++i) {
                UUID id = this.hitUUIDs.get(i);
                hits.m_128362_(String.valueOf(i), id);
            }
            compound.m_128365_("Hits", (Tag)hits);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        Object object;
        super.m_7378_(compound);
        if (compound.m_128403_("Source")) {
            this.sourceUUID = compound.m_128342_("Source");
            this.cachedSource = null;
        }
        if (compound.m_128441_("Hits") && (object = compound.m_128423_("Hits")) instanceof CompoundTag) {
            CompoundTag hits = (CompoundTag)object;
            this.hitUUIDs = new ArrayList();
            for (String s : hits.m_128431_()) {
                this.hitUUIDs.add(hits.m_128342_(s));
            }
            this.cachedHits = new ArrayList();
        }
    }

    public Vec3 bounceVector(Vec3 velocity, Direction face) {
        Vec3 normal = new Vec3((double)face.m_122429_(), (double)face.m_122430_(), (double)face.m_122431_());
        double mult = velocity.f_82479_ * normal.f_82479_ + velocity.f_82480_ * normal.f_82480_ + velocity.f_82481_ * normal.f_82481_;
        return new Vec3(velocity.f_82479_ - 2.0 * mult * normal.f_82479_, velocity.f_82480_ - 2.0 * mult * normal.f_82480_, velocity.f_82481_ - 2.0 * mult * normal.f_82481_);
    }

    public Vec3 bounceAxis(Vec3 velocity, Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        double x = velocity.f_82479_;
        double y = velocity.f_82480_;
        double z = velocity.f_82481_;
        if (axis == Direction.Axis.X) {
            x = -x;
        } else if (axis == Direction.Axis.Y) {
            y = -y;
        } else if (axis == Direction.Axis.Z) {
            z = -z;
        }
        return new Vec3(x, y, z);
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity livingentity;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (!(!(entity instanceof LivingEntity) || this.m_150171_((Entity)(livingentity = (LivingEntity)entity)) || this.originatedFrom((Entity)livingentity) || this.hasHit((Entity)livingentity) || livingentity instanceof BossMob)) {
            livingentity.m_6469_(ReduxDamageTypes.entitySource(this.m_9236_(), ReduxDamageTypes.EMBER, this.m_19749_()), 1.0f);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Direction d = result.m_82434_();
        Direction.Axis axis = d.m_122434_();
        Vec3 loc = result.m_82450_();
        Vec3 velocity = this.m_20184_();
        velocity = velocity.m_82542_(Math.abs(velocity.f_82479_) > 0.1 ? 1.0 : 0.0, Math.abs(velocity.f_82480_) > 0.1 ? 1.0 : 0.0, Math.abs(velocity.f_82481_) > 0.1 ? 1.0 : 0.0);
        Vec3 bounce = this.bounceAxis(velocity, d);
        double spread = velocity.m_82553_() * 2.5;
        for (int i = 0; i < Mth.m_14107_((double)(velocity.m_82553_() * 15.0)); ++i) {
            float angle = this.m_9236_().m_213780_().m_188501_() * 360.0f * ((float)Math.PI / 180);
            double opp = (double)Mth.m_14031_((float)angle) * spread;
            double adj = (double)Mth.m_14089_((float)angle) * spread;
            if (axis == Direction.Axis.X) {
                this.m_9236_().m_7106_((ParticleOptions)ReduxParticleTypes.SPARK.get(), loc.m_7096_(), loc.m_7098_(), loc.m_7094_(), velocity.m_82553_(), opp, adj);
                continue;
            }
            if (axis == Direction.Axis.Y) {
                this.m_9236_().m_7106_((ParticleOptions)ReduxParticleTypes.SPARK.get(), loc.m_7096_(), loc.m_7098_(), loc.m_7094_(), opp, velocity.m_82553_(), adj);
                continue;
            }
            if (axis != Direction.Axis.Z) continue;
            this.m_9236_().m_7106_((ParticleOptions)ReduxParticleTypes.SPARK.get(), loc.m_7096_(), loc.m_7098_(), loc.m_7094_(), opp, adj, velocity.m_82553_());
        }
        SoundEvent sound = velocity.m_82553_() <= 0.75 ? (SoundEvent)ReduxSoundEvents.EMBER_BOUNCE_SMALL.get() : (velocity.m_82553_() <= 1.5 ? (SoundEvent)ReduxSoundEvents.EMBER_BOUNCE_MED.get() : (SoundEvent)ReduxSoundEvents.EMBER_BOUNCE_BIG.get());
        this.m_9236_().m_6263_(null, loc.m_7096_(), loc.m_7098_(), loc.m_7094_(), sound, SoundSource.NEUTRAL, (float)(velocity.m_82553_() * 10.0), 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        this.m_20256_(bounce.m_82490_(0.5));
        this.m_146884_(loc);
    }

    protected void m_8097_() {
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double d0 = packet.m_131503_();
        double d1 = packet.m_131504_();
        double d2 = packet.m_131505_();
        this.m_20334_(d0, d1, d2);
    }
}

