/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.data.resource.biome.registry;

import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.Tags;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.data.resource.biome.Blight;
import net.zepalesque.redux.data.resource.biome.Cloudcaps;
import net.zepalesque.redux.data.resource.biome.FrostedForests;
import net.zepalesque.redux.data.resource.biome.GildedGrasslands;
import net.zepalesque.redux.data.resource.biome.GildedGroves;
import net.zepalesque.redux.data.resource.biome.GlacialTundra;
import net.zepalesque.redux.data.resource.biome.Skyfields;
import net.zepalesque.redux.data.resource.biome.SkyrootShrublands;
import net.zepalesque.redux.data.resource.biome.registry.BiomeGenerator;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.misc.ReduxTags;

public class ReduxBiomes {
    public static final ResourceKey<Biome> THE_BLIGHT = ReduxBiomes.createKey("the_blight");
    public static final ResourceKey<Biome> FROSTED_FORESTS = ReduxBiomes.createKey("frosted_forests");
    public static final ResourceKey<Biome> GLACIAL_TUNDRA = ReduxBiomes.createKey("glacial_tundra");
    public static final ResourceKey<Biome> GILDED_GROVES = ReduxBiomes.createKey("gilded_groves");
    public static final ResourceKey<Biome> GILDED_GRASSLANDS = ReduxBiomes.createKey("gilded_grasslands");
    public static final ResourceKey<Biome> SKYFIELDS = ReduxBiomes.createKey("skyfields");
    public static final ResourceKey<Biome> CLOUDCAPS = ReduxBiomes.createKey("cloudcaps");
    public static final ResourceKey<Biome> SKYROOT_SHRUBLANDS = ReduxBiomes.createKey("skyroot_shrublands");
    public static final ResourceKey<Biome> SHIMMERING_HILLS = ReduxBiomes.createKey("shimmering_hills");
    public static final ResourceKey<Biome> QUICKSOIL_DUNES = ReduxBiomes.createKey("quicksoil_dunes");
    public static final ResourceKey<Biome> QUICKSOIL_OASIS = ReduxBiomes.createKey("quicksoil_oasis");
    public static final int BLEAKMOSS_GRASS_COLOR = 12033729;
    public static final int AETHER_GRASS_COLOR = 11401668;
    public static final int GILDED_GRASS_COLOR = 16772502;
    public static final int GILDED_GRASSLANDS_COLOR = 16774563;
    public static final int BLIGHT_GRASS_COLOR = 12496613;
    public static final int FROSTED_GRASS_COLOR = 0xCCF7FF;
    public static final int SKYFIELDS_GRASS_COLOR = 12582892;
    public static final int SHRUBLANDS_GRASS_COLOR = 14155724;
    public static final int CLOUDCAP_GRASS_COLOR = 13035007;
    public static final int SHIMMERING_GRASS_COLOR = 12251391;
    public static final int DUNES_GRASS_COLOR = 0xEEFFE0;
    public static final int OASIS_GRASS_COLOR = 0xD6FFD6;
    public static final int FROZEN_GRASS_COLOR = 13364478;
    public static final int PALE_GRASS_COLOR = 12707530;
    public static final int AERGLOW_GRASS_COLOR = 0xCFFFF1;
    public static final int AERLAVENDER_GRASS_COLOR = 12905936;
    public static final int BLUE_AERGLOW_GRASS_COLOR = 13565949;
    public static final int MYSTIC_AERGLOW_GRASS_COLOR = 13762535;
    public static final int GOLDEN_GRASS_COLOR = 0xFFF47F;
    public static final int LUMINESCENT_GRASS_COLOR = 12582884;
    public static final ImmutableMap<ResourceKey<Biome>, Integer> AETHER_GRASS_COLORS = new ImmutableMap.Builder().put(THE_BLIGHT, (Object)12496613).put(FROSTED_FORESTS, (Object)0xCCF7FF).put(GLACIAL_TUNDRA, (Object)0xCCF7FF).put(GILDED_GROVES, (Object)16772502).put(GILDED_GRASSLANDS, (Object)16774563).put(SKYFIELDS, (Object)12582892).put(CLOUDCAPS, (Object)13035007).put(SKYROOT_SHRUBLANDS, (Object)14155724).build();
    public static final ImmutableMap<TagKey<Biome>, Integer> TAG_GRASSES = new ImmutableMap.Builder().put(ReduxTags.Biomes.FOREST_COLORS, (Object)10678972).put(ReduxTags.Biomes.WOODLAND_COLORS, (Object)9889968).put(ReduxTags.Biomes.MEADOW_COLORS, (Object)12255179).build();
    public static final ImmutableMap<TagKey<Biome>, Integer> OVERWORLD_BIOME_AETHER_GRASS_COLORS = new ImmutableMap.Builder().put((Object)Tags.Biomes.IS_COLD, (Object)0xCCF7FF).put((Object)Tags.Biomes.IS_DESERT, (Object)0xD6FFD6).put((Object)Tags.Biomes.IS_LUSH, (Object)12582892).put((Object)Tags.Biomes.IS_MUSHROOM, (Object)13035007).put((Object)Tags.Biomes.IS_MAGICAL, (Object)12251391).put((Object)Tags.Biomes.IS_PLATEAU, (Object)16772502).put((Object)Tags.Biomes.IS_SPARSE, (Object)16774563).put((Object)BiomeTags.f_207612_, (Object)0xEEFFE0).put((Object)BiomeTags.f_215818_, (Object)12496613).build();
    public static final int WATER = 5403045;
    public static final int WATER_FOG = 791347;
    public static final int CRYSTAL_GRASS = 12576255;

    private static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Redux.locate(name));
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(THE_BLIGHT, (Object)Blight.generate(context));
        context.m_255272_(CLOUDCAPS, (Object)Cloudcaps.generate(context));
        context.m_255272_(FROSTED_FORESTS, (Object)FrostedForests.generate(context));
        context.m_255272_(GLACIAL_TUNDRA, (Object)GlacialTundra.generate(context));
        context.m_255272_(GILDED_GROVES, (Object)GildedGroves.generate(context));
        context.m_255272_(GILDED_GRASSLANDS, (Object)GildedGrasslands.generate(context));
        context.m_255272_(SKYFIELDS, (Object)Skyfields.generate(context));
        context.m_255272_(SKYROOT_SHRUBLANDS, (Object)SkyrootShrublands.generate(context));
    }

    public static Biome simpleBiome(BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder mobSpawns, Music music, int waterColor, int waterFogColor, int grassColor) {
        return BiomeGenerator.biomeBase(gen, mobSpawns, music, waterColor, waterFogColor, grassColor, 0xC0C0FF, 9671612, false, 0.8f, 0.0f);
    }

    public static Biome climateBiome(BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder mobSpawns, Music music, int waterColor, int waterFogColor, int grassColor, boolean precip, float temp, float downfall) {
        return BiomeGenerator.biomeBase(gen, mobSpawns, music, waterColor, waterFogColor, grassColor, 0xC0C0FF, 9671612, precip, temp, downfall);
    }

    public static Biome biomeSky(BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder mobSpawns, Music music, int waterColor, int waterFogColor, int grassColor, int skyColor, int skyFogColor) {
        return BiomeGenerator.biomeBase(gen, mobSpawns, music, waterColor, waterFogColor, grassColor, skyColor, skyFogColor, false, 0.8f, 0.0f);
    }

    public static MobSpawnSettings.Builder defaultMobSpawnsNoPassive(MobSpawnSettings.Builder builder) {
        return builder.m_48370_((EntityType)AetherEntityTypes.COCKATRICE.get(), 0.5, 0.15).m_48370_((EntityType)AetherEntityTypes.ZEPHYR.get(), 0.6, 0.16).m_48370_((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 0.4, 0.11).m_48370_((EntityType)AetherEntityTypes.BLUE_SWET.get(), 0.5, 0.1).m_48370_((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 0.5, 0.1).m_48370_((EntityType)AetherEntityTypes.WHIRLWIND.get(), 0.4, 0.1).m_48370_((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 0.4, 0.1).m_48370_((EntityType)AetherEntityTypes.AERWHALE.get(), 0.5, 0.11).m_48376_(AetherMobCategory.AETHER_DARKNESS_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.COCKATRICE.get(), 8, 1, 1)).m_48376_(AetherMobCategory.AETHER_SKY_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.ZEPHYR.get(), 20, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 7, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.BLUE_SWET.get(), 6, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 6, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.WHIRLWIND.get(), 3, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 1, 1, 1)).m_48376_(AetherMobCategory.AETHER_AERWHALE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERWHALE.get(), 10, 1, 1));
    }

    public static MobSpawnSettings.Builder defaultMobSpawns(MobSpawnSettings.Builder builder) {
        return ReduxBiomes.defaultMobSpawnsNoPassive(builder).m_48368_(0.25f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.PHYG.get(), 10, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.SHEEPUFF.get(), 12, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.FLYING_COW.get(), 12, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERBUNNY.get(), 11, 3, 3)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.MOA.get(), 8, 1, 3));
    }

    public static MobSpawnSettings.Builder cloudcapMobs(MobSpawnSettings.Builder builder) {
        return ReduxBiomes.defaultMobSpawnsNoPassive(builder).m_48368_(0.25f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ReduxEntityTypes.SHIMMERCOW.get(), 12, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ReduxEntityTypes.MYKAPOD.get(), 5, 1, 3));
    }

    public static MobSpawnSettings.Builder increasedMobSpawns(MobSpawnSettings.Builder builder) {
        return ReduxBiomes.defaultMobSpawnsNoPassive(builder).m_48368_(0.25f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.PHYG.get(), 10, 5, 7)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.SHEEPUFF.get(), 12, 5, 6)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.FLYING_COW.get(), 12, 4, 6)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERBUNNY.get(), 18, 3, 9)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.MOA.get(), 8, 1, 4));
    }

    public static Biome fullDefinition(boolean precipitation, float temperature, float downfall, BiomeSpecialEffects effects, MobSpawnSettings spawnSettings, BiomeGenerationSettings generationSettings, Biome.TemperatureModifier temperatureModifier) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(effects).m_47605_(spawnSettings).m_47601_(generationSettings).m_47599_(temperatureModifier).m_47592_();
    }
}

