/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.data.resource;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.zepalesque.redux.data.resource.builder.ReduxNoiseBuilders;
import net.zepalesque.redux.world.density.PerlinNoiseFunction;

public class ReduxDensityFunctions
extends ReduxNoiseBuilders {
    public static final ResourceKey<DensityFunction> THE_AETHER_DEPTH = ReduxDensityFunctions.createKey("the_aether/depth");
    public static final ResourceKey<DensityFunction> REDUX_3D_NOISE = ReduxDensityFunctions.createKey("redux_3d_noise");
    public static final ResourceKey<DensityFunction> CLOUDBED_NOISE = ReduxDensityFunctions.createKey("cloudbed_noise");
    public static final ResourceKey<DensityFunction> CLOUDBED_Y_OFFSET = ReduxDensityFunctions.createKey("cloudbed_y_offset");
    public static final ResourceKey<DensityFunction> REDUX_FINAL_DENSITY = ReduxDensityFunctions.createKey("redux_final_density");

    private static ResourceKey<DensityFunction> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation("aether_redux", name));
    }

    public static void bootstrap(BootstapContext<DensityFunction> context) {
        HolderGetter functions = context.m_255420_(Registries.f_257040_);
        context.m_255272_(CLOUDBED_NOISE, (Object)DensityFunctions.m_208363_((DensityFunction)new PerlinNoiseFunction(new NormalNoise.NoiseParameters(0, 1.0, new double[]{1.0, 1.0, 1.0, 1.0}), 0.01, 0.0, 42L), (DensityFunction)DensityFunctions.m_208264_((double)1.5)));
        context.m_255272_(CLOUDBED_Y_OFFSET, (Object)DensityFunctions.m_208363_((DensityFunction)new PerlinNoiseFunction(new NormalNoise.NoiseParameters(0, 1.0, new double[]{1.0}), 0.005, 0.0, 95L), (DensityFunction)DensityFunctions.m_208264_((double)1.5)));
        context.m_255272_(THE_AETHER_DEPTH, (Object)DensityFunctions.m_208266_((int)0, (int)255, (double)1.5, (double)-1.5));
        context.m_255272_(REDUX_3D_NOISE, (Object)BlendedNoise.m_230477_((double)0.25, (double)0.375, (double)80.0, (double)80.0, (double)8.0));
        context.m_255272_(REDUX_FINAL_DENSITY, (Object)ReduxDensityFunctions.createFinal(ReduxDensityFunctions.getFunction((HolderGetter<DensityFunction>)functions, REDUX_3D_NOISE)));
    }

    public static DensityFunction get(HolderGetter<DensityFunction> densityFunctions, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)densityFunctions.m_255043_(key));
    }

    public static DensityFunction get(RegistryAccess access, ResourceKey<DensityFunction> key) {
        Optional optional = access.m_254861_(Registries.f_257040_);
        if (optional.isPresent()) {
            HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)optional.get();
            return (DensityFunction)lookup.m_255043_(key).m_203334_();
        }
        throw new NullPointerException("Optional value is not present!");
    }

    public static DensityFunction get(Level level, ResourceKey<DensityFunction> key) {
        return (DensityFunction)level.m_9598_().m_175515_(Registries.f_257040_).m_123013_(key);
    }
}

