/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.zepalesque.redux.api.Conditional;
import net.zepalesque.redux.builtin.BuiltinPackUtils;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReduxOverridesPackResources
extends AbstractPackResources {
    private final PackMetadataSection packMeta;
    private final List<Conditional<PackResources>> delegates;
    private final Map<String, List<Conditional<PackResources>>> namespacesAssets;
    private static final Gson GSON = new Gson();
    private final Path source;

    public ReduxOverridesPackResources(String packId, boolean isBuiltin, PackMetadataSection packMeta, List<Conditional<PackResources>> packs) {
        super(packId, isBuiltin);
        this.source = BuiltinPackUtils.path(packId);
        this.packMeta = packMeta;
        this.delegates = ImmutableList.copyOf(packs);
        this.namespacesAssets = this.buildNamespaceMap(PackType.CLIENT_RESOURCES, packs);
    }

    public Path getSource() {
        return this.source;
    }

    protected Path resolve(String ... paths) {
        Path path = this.getSource();
        String[] var3 = paths;
        int var4 = paths.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String name = var3[var5];
            path = path.resolve(name);
        }
        return path;
    }

    private Map<String, List<Conditional<PackResources>>> buildNamespaceMap(PackType type, List<Conditional<PackResources>> packList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (Conditional<PackResources> optional : packList) {
            if (!optional.isPopulated()) continue;
            PackResources pack = optional.getAnyway();
            for (String namespace : pack.m_5698_(type)) {
                map.computeIfAbsent(namespace, k -> new ArrayList()).add(optional);
            }
        }
        map.replaceAll((k, list) -> ImmutableList.copyOf((Collection)list));
        return ImmutableMap.copyOf(map);
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        return (T)(deserializer.m_7991_().equals("pack") ? this.packMeta : null);
    }

    public void m_8031_(PackType type, String resourceNamespace, String paths, PackResources.ResourceOutput resourceOutput) {
        for (PackResources delegate : this.getAvaliablePacks()) {
            delegate.m_8031_(type, resourceNamespace, paths, resourceOutput);
        }
    }

    @NotNull
    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? this.namespacesAssets.keySet() : Set.of();
    }

    public void close() {
        for (PackResources pack : this.getAllPacks()) {
            pack.close();
        }
    }

    @javax.annotation.Nullable
    public IoSupplier<InputStream> m_8017_(String ... paths) {
        Path path = this.resolve(paths);
        return !Files.exists(path, new LinkOption[0]) ? null : IoSupplier.m_246697_((Path)path);
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (location.m_135815_().matches("lang/.+\\.json")) {
            ArrayList matches = Lists.newArrayList();
            JsonObject combined = new JsonObject();
            for (PackResources pack : this.getCandidatePacks(type, location)) {
                IoSupplier ioSupplier = pack.m_214146_(type, location);
                if (ioSupplier == null) continue;
                try {
                    JsonObject jsonobject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader((InputStream)ioSupplier.m_247737_(), StandardCharsets.UTF_8), JsonObject.class);
                    matches.add(jsonobject.entrySet());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!matches.isEmpty()) {
                for (Set entrySet : matches) {
                    for (Map.Entry entry : entrySet) {
                        combined.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
            } else {
                return null;
            }
            String input = GSON.toJson((JsonElement)combined);
            return () -> new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        }
        for (PackResources pack : this.getCandidatePacks(type, location)) {
            IoSupplier ioSupplier = pack.m_214146_(type, location);
            if (ioSupplier == null) continue;
            return pack.m_214146_(type, location);
        }
        return null;
    }

    @Nullable
    public Collection<PackResources> getChildren() {
        return this.getAvaliablePacks();
    }

    public Collection<PackResources> getAvaliablePacks() {
        return this.delegates.stream().filter(Conditional::isAvailable).map(Conditional::get).toList();
    }

    public Collection<PackResources> getAllPacks() {
        return this.delegates.stream().filter(Conditional::isPopulated).map(Conditional::getAnyway).toList();
    }

    private List<PackResources> getCandidatePacks(PackType type, ResourceLocation location) {
        if (type == PackType.CLIENT_RESOURCES) {
            Map<String, List<Conditional<PackResources>>> map = this.namespacesAssets;
            List<Conditional<PackResources>> packsWithNamespace = map.get(location.m_135827_());
            return packsWithNamespace == null ? Collections.emptyList() : packsWithNamespace.stream().filter(Conditional::isAvailable).map(Conditional::get).toList();
        }
        return Collections.emptyList();
    }

    public String toString() {
        return String.format("%s: %s", ((Object)((Object)this)).getClass().getName(), this.getSource());
    }
}

