/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.zepalesque.redux.entity.monster.Blightbunny;

public class BlightbunnyModel
extends EntityModel<Blightbunny> {
    public final ModelPart base;
    public final ModelPart head;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart rightWhiskers;
    public final ModelPart leftWhiskers;
    public final ModelPart body;
    public final ModelPart puff;
    public final ModelPart tail;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightBackLeg;
    public final ModelPart leftBackLeg;
    public float puffiness;

    public BlightbunnyModel(ModelPart root) {
        this.base = root.m_171324_("base");
        this.head = this.base.m_171324_("head");
        this.rightEar = this.head.m_171324_("right_ear");
        this.leftEar = this.head.m_171324_("left_ear");
        this.rightWhiskers = this.head.m_171324_("right_whiskers");
        this.leftWhiskers = this.head.m_171324_("left_whiskers");
        this.body = this.base.m_171324_("body");
        this.puff = this.base.m_171324_("puff");
        this.tail = this.body.m_171324_("tail");
        this.rightFrontLeg = this.body.m_171324_("right_front_leg");
        this.leftFrontLeg = this.body.m_171324_("left_front_leg");
        this.rightBackLeg = this.body.m_171324_("right_back_leg");
        this.leftBackLeg = this.body.m_171324_("left_back_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition base = partdefinition.m_171599_("base", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition head = base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -1.0f, -4.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(23, 13).m_171488_(1.0f, -4.0f, -4.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(14, 3).m_171488_(-2.0f, -3.0f, -4.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(23, 7).m_171488_(-2.0f, -4.0f, -4.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("right_whiskers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("left_whiskers", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition puff = base.m_171599_("puff", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        puff.m_171599_("puff_rotation", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-3.5f, -3.5f, -4.5f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(16, 21).m_171488_(0.0f, -5.5f, -2.5f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = base.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        tail.m_171599_("tail_box", CubeListBuilder.m_171558_().m_171514_(32, 19).m_171488_(-1.5f, -1.125f, -3.4f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.7453f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-2.0f, 0.0f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-3.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(0.0f, 0.0f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-3.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(8, 32).m_171488_(-2.0f, 0.0f, -3.75f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)4.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(8, 26).m_171488_(0.0f, 0.0f, -3.75f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)4.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Blightbunny aerbunny, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.m_6839_((Entity)aerbunny, limbSwing, limbSwingAmount, partialTicks);
        this.puffiness = Mth.m_14179_((float)partialTicks, (float)aerbunny.getPuffiness(), (float)(aerbunny.getPuffiness() - aerbunny.getPuffSubtract())) / 20.0f;
    }

    public void setupAnim(Blightbunny aerbunny, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount - this.body.f_104203_;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount - this.body.f_104203_;
        this.rightBackLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount - this.body.f_104203_;
        this.leftBackLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount - this.body.f_104203_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float a;
        this.head.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85836_();
        this.puff.f_233553_ = a = 1.0f + this.puffiness * 0.5f;
        this.puff.f_233554_ = a;
        this.puff.f_233555_ = a;
        this.puff.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

