/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.layer.entity;

import com.aetherteam.aether.client.renderer.entity.model.CockatriceModel;
import com.aetherteam.aether.entity.monster.Cockatrice;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.zepalesque.redux.capability.cockatrice.CockatriceExtension;
import net.zepalesque.redux.client.render.entity.model.entity.CockatriceReduxModel;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.CockatriceModelType;
import net.zepalesque.redux.util.math.MathUtil;
import org.jetbrains.annotations.NotNull;

public class CockatriceReduxLayer
extends RenderLayer<Cockatrice, CockatriceModel> {
    private final CockatriceReduxModel legacy;
    private final CockatriceReduxModel refreshed;
    private static final ResourceLocation COCKATRICE_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/cockatrice/cockatrice_redux.png");
    private static final RenderType COCKATRICE_MARKINGS = RenderType.m_234338_((ResourceLocation)new ResourceLocation("aether", "textures/entity/mobs/cockatrice/cockatrice_emissive_redux.png"));
    private static final RenderType COCKATRICE_EYES = RenderType.m_110488_((ResourceLocation)new ResourceLocation("aether", "textures/entity/mobs/cockatrice/cockatrice_eyes_redux.png"));

    public CockatriceReduxLayer(RenderLayerParent<Cockatrice, CockatriceModel> entityRenderer, CockatriceReduxModel legsModel, CockatriceReduxModel refreshed) {
        super(entityRenderer);
        this.legacy = legsModel;
        this.refreshed = refreshed;
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @NotNull Cockatrice cockatrice, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Boolean)ReduxConfig.CLIENT.cockatrice_model_upgrade.get()).booleanValue() && (Minecraft.m_91087_().f_91074_ == null || !cockatrice.m_20177_((Player)Minecraft.m_91087_().f_91074_))) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
            CockatriceReduxModel model = ReduxConfig.CLIENT.cockatrice_model_type.get() == CockatriceModelType.legacy ? this.legacy : this.refreshed;
            float progress = cockatrice.isEntityOnGround() ? 0.0f : 1.0f;
            float progressAttack = 0.0f;
            float progressAttackAlways = 0.0f;
            float swingCalc = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (CockatriceExtension.get(cockatrice).isPresent()) {
                CockatriceExtension cockatriceAnim = (CockatriceExtension)CockatriceExtension.get(cockatrice).orElseThrow(() -> new IllegalStateException("Could not find CockatriceExtension capability!"));
                progress = Mth.m_14179_((float)partialTicks, (float)cockatriceAnim.getPrevLegAnim(), (float)cockatriceAnim.getLegAnim()) * 0.2f;
                progressAttack = (1.0f - progress) * Mth.m_14179_((float)partialTicks, (float)cockatriceAnim.getPrevTargetAnim(), (float)cockatriceAnim.getTargetAnim()) * 0.1f;
                progressAttackAlways = Mth.m_14179_((float)partialTicks, (float)cockatriceAnim.getPrevTargetAnim(), (float)cockatriceAnim.getTargetAnim()) * 0.1f;
            }
            if (ReduxConfig.CLIENT.cockatrice_model_type.get() != CockatriceModelType.refreshed) {
                model.leg1.f_233556_ = false;
                model.leg2.f_233556_ = false;
                model.leg1.f_104203_ = MathUtil.costrp(progress, -swingCalc * 0.8f, 0.2617994f);
                model.leg2.f_104203_ = MathUtil.costrp(progress, swingCalc * 0.8f, 0.2617994f);
                model.lower_leg1.f_104203_ = MathUtil.costrp(progress, -MathUtil.returnZeroWhenNegative(MathUtil.animCos(limbSwing * 0.6662f), swingCalc) * 0.3333f * limbSwingAmount, 0.43633232f);
                model.lower_leg2.f_104203_ = MathUtil.costrp(progress, -MathUtil.returnZeroWhenNegative(MathUtil.animCos((float)((double)(limbSwing * 0.6662f) + Math.PI)), -swingCalc) * 0.333f * limbSwingAmount, 0.43633232f);
                model.toes_stepanim_leg1.f_104203_ = MathUtil.costrp(progress, -model.lower_leg1.f_104203_ * 0.3333f, 0.0f);
                model.toes_stepanim_leg2.f_104203_ = MathUtil.costrp(progress, -model.lower_leg2.f_104203_ * 0.3333f, 0.0f);
                model.toes_leg1.f_104203_ = MathUtil.costrp(progress, 0.0f, 0.17453292f);
                model.toes_leg2.f_104203_ = MathUtil.costrp(progress, 0.0f, 0.17453292f);
                model.back_toes_leg1.f_104203_ = MathUtil.costrp(progress, 0.0f, -1.3089969f);
                model.back_toes_leg2.f_104203_ = MathUtil.costrp(progress, 0.0f, -1.3089969f);
            } else {
                model.leg1.f_233556_ = true;
                model.leg2.f_233556_ = true;
            }
            model.neck.f_104204_ = ((CockatriceModel)this.m_117386_()).head.f_104204_ * 0.333f;
            model.neck.f_104203_ = ((CockatriceModel)this.m_117386_()).head.f_104203_ * 0.125f;
            model.head.f_104204_ = ((CockatriceModel)this.m_117386_()).head.f_104204_ * 0.667f;
            model.head.f_104203_ = ((CockatriceModel)this.m_117386_()).head.f_104203_ * 0.875f;
            model.jaw.f_104203_ = ((CockatriceModel)this.m_117386_()).jaw.f_104203_;
            float breathe = MathUtil.cockatriceBreathing((Entity)cockatrice, partialTicks);
            boolean doHurtAnim = cockatrice.f_20916_ > 0 && (float)cockatrice.f_20916_ - partialTicks > 0.0f;
            int hit = cockatrice.f_20917_ - cockatrice.f_20916_;
            float hitSmooth = (float)hit + partialTicks;
            float baseRot = hitSmooth >= (float)cockatrice.f_20917_ * 0.25f + 0.0f ? -Mth.m_14089_((float)(0.41887906f * (hitSmooth + 5.0f))) + 1.0f : -Mth.m_14089_((float)(1.2566371f * hitSmooth));
            float rot = MathUtil.costrp(progressAttack, baseRot * 0.5497787f, baseRot * 0.3926991f);
            float shortened = Math.min(0.75f, progressAttack) * 1.3333334f;
            float shortenedAlways = Math.min(0.75f, progressAttackAlways) * 1.3333334f;
            float delayed = Math.max(0.0f, progressAttack - 0.5f) * 2.0f;
            model.neck_hurtanim.f_104203_ = (!doHurtAnim ? 0.0f : 0.6667f * rot) + MathUtil.costrp(shortened, 0.0f, 0.6981317f);
            model.body.f_104203_ = (!doHurtAnim ? breathe : 0.3333f * rot + breathe) + MathUtil.costrp(shortened, 0.0f, -1.0471976f);
            model.lower_tail.f_104203_ = MathUtil.costrp(shortened, 0.0f, 0.6981317f);
            model.lower_tail.m_104227_(0.0f, MathUtil.costrp(delayed, 0.0f, -10.0f) + 6.0f, 5.0f);
            model.head_hurtanim.f_104203_ = (!doHurtAnim ? 0.0f : -rot) + MathUtil.costrp(shortened, 0.0f, 0.34906584f);
            model.crown_feather.f_104203_ = MathUtil.costrp(shortened, 0.0f, 0.5235988f) + breathe * 1.5f;
            model.wing_2.m_104227_(8.01f, 4.0f, -8.0f + MathUtil.costrp(delayed, 0.0f, 1.5f));
            model.wing_1.f_104202_ = model.wing_2.f_104202_;
            model.wing_1.f_104203_ = MathUtil.costrp(shortened, ((CockatriceModel)this.m_117386_()).rightWing.f_104203_ * 0.625f + 0.17453292f, 0.0f) + 1.5707964f;
            model.wing_1.f_104204_ = MathUtil.costrp(shortened, 0.0f, -0.6981317f);
            model.wing_2.f_104203_ = model.wing_1.f_104203_;
            model.wing_2.f_104204_ = -model.wing_1.f_104204_;
            model.ribcage.f_104203_ = MathUtil.costrp(shortened, 0.0f, 1.5707964f);
            model.claw1.f_104203_ = MathUtil.costrp(shortened, 0.0f, -1.134464f);
            model.claw1.f_104204_ = MathUtil.costrp(shortened, 0.0f, -0.61086524f);
            model.claw2.f_104203_ = model.claw1.f_104203_;
            model.claw2.f_104204_ = -model.claw1.f_104204_;
            model.z_rot_wing_1.f_104205_ = MathUtil.costrp(shortened, ((CockatriceModel)this.m_117386_()).rightWing.f_104204_ * 0.875f + 0.2617889f, 0.0f) - breathe;
            model.z_rot_wing_1.f_104203_ = MathUtil.costrp(delayed, 0.0f, -1.4835298f);
            model.z_rot_wing_1.f_104204_ = -model.z_rot_wing_1.f_104203_;
            model.z_rot_wing_2.f_104205_ = -model.z_rot_wing_1.f_104205_;
            model.z_rot_wing_2.f_104203_ = model.z_rot_wing_1.f_104203_;
            model.z_rot_wing_2.f_104204_ = -model.z_rot_wing_1.f_104204_;
            model.feathers_3_wing1.f_104203_ = (cockatrice.isEntityOnGround() ? 0.0f : -0.7853982f) - MathUtil.breatheBase((Entity)cockatrice, partialTicks, 0.025f, 0.1f, 0.0f) + MathUtil.costrp(shortenedAlways, 0.0f, 0.34906584f);
            model.feathers_2_wing1.f_104203_ = (cockatrice.isEntityOnGround() ? 0.0f : -0.5235988f) - MathUtil.breatheBase((Entity)cockatrice, partialTicks, 0.025f, 0.1f, 0.3333f) + MathUtil.costrp(shortenedAlways, 0.0f, 0.2617994f);
            model.feathers_1_wing1.f_104203_ = (cockatrice.isEntityOnGround() ? 0.0f : -0.43633232f) - MathUtil.breatheBase((Entity)cockatrice, partialTicks, 0.025f, 0.1f, 0.6667f) + MathUtil.costrp(shortenedAlways, 0.0f, 0.34906584f);
            model.feathers_3_wing2.f_104203_ = model.feathers_3_wing1.f_104203_;
            model.feathers_2_wing2.f_104203_ = model.feathers_2_wing1.f_104203_;
            model.feathers_1_wing2.f_104203_ = model.feathers_1_wing1.f_104203_;
            model.feathers_3_wing1.f_104204_ = MathUtil.costrp(shortenedAlways, 0.0f, 0.34906584f);
            model.feathers_2_wing1.f_104204_ = MathUtil.costrp(shortenedAlways, 0.0f, 0.43633232f);
            model.feathers_1_wing1.f_104204_ = MathUtil.costrp(shortenedAlways, 0.0f, 0.43633232f);
            model.feathers_3_wing2.f_104204_ = -model.feathers_3_wing1.f_104204_;
            model.feathers_2_wing2.f_104204_ = -model.feathers_2_wing1.f_104204_;
            model.feathers_1_wing2.f_104204_ = -model.feathers_1_wing1.f_104204_;
            model.head_feather_left.f_104204_ = MathUtil.costrp(shortenedAlways, 0.0f, 0.87266463f) + MathUtil.breatheBase((Entity)cockatrice, partialTicks, 0.15f, 0.1f, 0.125f);
            model.head_feather_right.f_104204_ = -model.head_feather_left.f_104204_;
            model.head_feather_top.f_104203_ = MathUtil.costrp(shortenedAlways, 0.0f, 0.87266463f) + MathUtil.breatheBase((Entity)cockatrice, partialTicks, 0.15f, 0.1f, 0.0f);
            model.middle_feather.f_104203_ = MathUtil.staggeredBreatheBase((Entity)cockatrice, partialTicks, MathUtil.costrp(progressAttack, 0.1f, 0.05f), 0.1f, 0.0f, 7.3f, 0.15f) + MathUtil.costrp(progressAttack, 0.0f, 0.6981317f);
            model.left_feather.f_104203_ = MathUtil.staggeredBreatheBase((Entity)cockatrice, partialTicks, MathUtil.costrp(progressAttack, 0.1f, 0.05f), 0.1f, 0.6667f, 7.3f, 0.15f) + MathUtil.costrp(progressAttack, 0.0f, 0.9599311f);
            model.right_feather.f_104203_ = MathUtil.staggeredBreatheBase((Entity)cockatrice, partialTicks, MathUtil.costrp(progressAttack, 0.1f, 0.05f), 0.1f, 0.3333f, 7.3f, 0.15f) + MathUtil.costrp(progressAttack, 0.0f, 0.9599311f);
            model.left_feather.f_104205_ = model.right_feather.f_104205_ = MathUtil.costrp(progressAttack, 0.0f, 0.17453292f);
            model.top_feather_2.f_104205_ = MathUtil.costrp(progressAttackAlways, 0.0f, 0.17453292f) + breathe;
            model.top_feather_2.f_104204_ = MathUtil.costrp(progressAttackAlways, 0.0f, 0.7853982f) + breathe;
            model.top_feather_1.f_104205_ = model.top_feather_2.f_104205_;
            model.top_feather_1.f_104204_ = -model.top_feather_2.f_104204_;
            if (!cockatrice.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
                ResourceLocation feathersLoc = this.getTextureLocation(cockatrice);
                VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)feathersLoc));
                model.m_7695_(poseStack, consumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)cockatrice, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                VertexConsumer emissiveConsumer = buffer.m_6299_(COCKATRICE_MARKINGS);
                model.m_7695_(poseStack, emissiveConsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)cockatrice, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            VertexConsumer eyesConsumer = buffer.m_6299_(COCKATRICE_EYES);
            model.m_7695_(poseStack, eyesConsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)cockatrice, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull Cockatrice cockatrice) {
        return COCKATRICE_TEXTURE;
    }
}

