/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.layer.entity;

import com.aetherteam.aether_genesis.entity.monster.BattleSentry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.zepalesque.redux.client.render.entity.model.entity.BattleSentryReduxModel;
import net.zepalesque.redux.config.ReduxConfig;

public class BattleSentryReduxLayer
extends RenderLayer<BattleSentry, SlimeModel<BattleSentry>> {
    private static final ResourceLocation SENTRY_OFF = new ResourceLocation("aether_genesis", "textures/entity/mobs/battle_sentry/battle_sentry_dormant_redux.png");
    private static final ResourceLocation SENTRY_ON = new ResourceLocation("aether_genesis", "textures/entity/mobs/battle_sentry/battle_sentry_redux.png");
    private static final RenderType SENTRY_EYE = RenderType.m_110488_((ResourceLocation)new ResourceLocation("aether_genesis", "textures/entity/mobs/battle_sentry/battle_sentry_eye_redux.png"));
    private final BattleSentryReduxModel<BattleSentry> model;

    public BattleSentryReduxLayer(RenderLayerParent<BattleSentry, SlimeModel<BattleSentry>> renderer, BattleSentryReduxModel<BattleSentry> model) {
        super(renderer);
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, BattleSentry sentry, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Boolean)ReduxConfig.CLIENT.sentry_model_upgrade.get()).booleanValue()) {
            this.model.setupAnim(sentry, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (Minecraft.m_91087_().f_91074_ != null) {
                if (!sentry.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
                    ResourceLocation modelLoc = this.shouldBeOn(sentry) ? SENTRY_ON : SENTRY_OFF;
                    VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)modelLoc));
                    this.model.m_7695_(poseStack, consumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)sentry, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                }
                VertexConsumer eyesConsumer = buffer.m_6299_(SENTRY_EYE);
                this.model.m_7695_(poseStack, eyesConsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)sentry, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public boolean shouldBeOn(BattleSentry sentry) {
        if (sentry.f_20916_ > 0) {
            return Mth.m_14031_((float)sentry.f_20916_) >= 0.0f;
        }
        return sentry.isAwake();
    }
}

