/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.screen.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.zepalesque.redux.config.ReduxConfig;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DynamicCubeMap
extends CubeMap {
    private final Supplier<String> folder;
    private final String namespace;
    private final String formattedPath;
    protected final Map<String, ResourceLocation[]> folders = new HashMap<String, ResourceLocation[]>();

    public DynamicCubeMap(Supplier<String> folder, String namespace, String formattedPath, String defaultFolder) {
        super(new ResourceLocation(namespace, formattedPath.formatted(defaultFolder)));
        this.folder = folder;
        this.namespace = namespace;
        this.formattedPath = formattedPath;
    }

    protected ResourceLocation[] createImageArray(String folder) {
        ResourceLocation[] array = new ResourceLocation[6];
        ResourceLocation base = new ResourceLocation(this.namespace, this.formattedPath.formatted(folder));
        for (int i = 0; i < 6; ++i) {
            array[i] = base.m_247449_(base.m_135815_() + "_" + i + ".png");
        }
        return array;
    }

    public void m_108849_(Minecraft mc, float pitch, float yaw, float alpha) {
        if (!ReduxConfig.CLIENT_SPEC.isLoaded()) {
            return;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Matrix4f matrix4f = new Matrix4f().setPerspective(1.4835298f, (float)mc.m_91268_().m_85441_() / (float)mc.m_91268_().m_85442_(), 0.05f, 10.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276450_);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        for (int j = 0; j < 4; ++j) {
            posestack.m_85836_();
            float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
            float f1 = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
            float f2 = 0.0f;
            posestack.m_252880_(f, f1, 0.0f);
            posestack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            posestack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            RenderSystem.applyModelViewMatrix();
            for (int k = 0; k < 6; ++k) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.folders.computeIfAbsent(this.folder.get(), this::createImageArray)[k]);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                int l = Math.round(255.0f * alpha) / (j + 1);
                if (k == 0) {
                    bufferbuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                }
                if (k == 1) {
                    bufferbuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                }
                if (k == 2) {
                    bufferbuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                }
                if (k == 3) {
                    bufferbuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                }
                if (k == 4) {
                    bufferbuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                }
                if (k == 5) {
                    bufferbuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                }
                tesselator.m_85914_();
            }
            posestack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.restoreProjectionMatrix();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }
}

