/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client;

import com.aetherteam.aether.block.AetherBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.builderdog.ancient_aether.block.blockstate.AetherGrassType;
import net.builderdog.ancient_aether.block.blockstate.AncientAetherBlockStateProperties;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.util.state.ReduxStates;
import net.zepalesque.redux.block.util.state.enums.BlightGrassColor;

public class ReduxColors {
    public static Map<Biome, Integer> AETHER_GRASS_COLORS = new HashMap<Biome, Integer>();
    public static ColorResolver AETHER_GRASS_RESOLVER = (biome, x, z) -> AETHER_GRASS_COLORS.getOrDefault(biome, 11401668);
    private static final Consumer<String> BLOCK_ERROR = s -> Redux.LOGGER.warn("Tried to register compat color for block that does not exist! Could not find: {}", s);
    private static final Consumer<String> ITEM_ERROR = s -> Redux.LOGGER.warn("Tried to register compat color for item that does not exist! Could not find: {}", s);

    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        Redux.LOGGER.debug("Beginning block color registration for the Aether: Redux");
        event.register((state, level, pos, index) -> index == 1 ? (level != null && pos != null ? ReduxColors.getAverageColor(level, pos, AETHER_GRASS_RESOLVER) : 11401668) : 0xFFFFFF, new Block[]{(Block)AetherBlocks.AETHER_GRASS_BLOCK.get()});
        event.register((state, level, pos, index) -> index == 1 ? (level != null && pos != null ? (state.m_61143_(ReduxStates.BLIGHT_GRASS_COLOR) == BlightGrassColor.CONSTANT ? 12496613 : ReduxColors.getAverageColor(level, pos, AETHER_GRASS_RESOLVER)) : 11401668) : 0xFFFFFF, new Block[]{(Block)ReduxBlocks.BLIGHTED_AETHER_GRASS_BLOCK.get()});
        event.register((state, level, pos, index) -> state.m_61138_((Property)ReduxStates.ENCHANTED) && (Boolean)state.m_61143_((Property)ReduxStates.ENCHANTED) != false ? 0xFFFFFF : ReduxColors.getColor(state, level, pos, index, 0), new Block[]{(Block)ReduxBlocks.SHORT_AETHER_GRASS.get(), (Block)ReduxBlocks.SPLITFERN.get()});
        event.register((state, level, pos, index) -> {
            int color = ReduxColors.getColor(state, level, pos, 1, 1);
            return index == 1 ? color : (index == 2 ? FastColor.ARGB32.m_13660_((int)255, (int)((FastColor.ARGB32.m_13665_((int)color) + 255) / 2), (int)((FastColor.ARGB32.m_13667_((int)color) + 255) / 2), (int)((FastColor.ARGB32.m_13669_((int)color) + 255) / 2)) : 0xFFFFFF);
        }, new Block[]{(Block)ReduxBlocks.GOLDEN_CLOVER.get()});
        event.register((state, level, pos, index) -> ReduxColors.getColor(state, level, pos, index, 1), new Block[]{(Block)ReduxBlocks.WYNDSPROUTS.get(), (Block)AetherBlocks.WHITE_FLOWER.get(), (Block)AetherBlocks.POTTED_WHITE_FLOWER.get(), (Block)AetherBlocks.PURPLE_FLOWER.get(), (Block)AetherBlocks.POTTED_PURPLE_FLOWER.get(), (Block)ReduxBlocks.SKYSPROUTS.get(), (Block)ReduxBlocks.LUXWEED.get(), (Block)ReduxBlocks.BLIGHTSHADE.get(), (Block)ReduxBlocks.POTTED_BLIGHTSHADE.get(), (Block)ReduxBlocks.DAGGERBLOOM.get(), (Block)ReduxBlocks.POTTED_DAGGERBLOOM.get(), (Block)ReduxBlocks.THERATIP.get(), (Block)ReduxBlocks.POTTED_THERATIP.get(), (Block)ReduxBlocks.FLAREBLOSSOM.get(), (Block)ReduxBlocks.POTTED_FLAREBLOSSOM.get(), (Block)ReduxBlocks.INFERNIA.get(), (Block)ReduxBlocks.POTTED_INFERNIA.get(), (Block)ReduxBlocks.AURUM.get(), (Block)ReduxBlocks.POTTED_AURUM.get(), (Block)ReduxBlocks.IRIDIA.get(), (Block)ReduxBlocks.POTTED_IRIDIA.get(), (Block)ReduxBlocks.LUMINA.get(), (Block)ReduxBlocks.POTTED_LUMINA.get(), (Block)ReduxBlocks.ZYATRIX.get(), (Block)ReduxBlocks.POTTED_ZYATRIX.get(), (Block)ReduxBlocks.SPIROLYCTIL.get(), (Block)ReduxBlocks.POTTED_SPIROLYCTIL.get(), (Block)ReduxBlocks.XAELIA_PATCH.get()});
        if (Redux.ancientAetherCompat()) {
            ReduxColors.register(event, (state, level, pos, index) -> level != null && pos != null ? (state.m_61138_((Property)AncientAetherBlockStateProperties.TYPE) && state.m_61143_((Property)AncientAetherBlockStateProperties.TYPE) == AetherGrassType.ENCHANTED ? 0xFFFFFF : ReduxColors.getColor(state, level, pos, index, 0)) : 11401668, new ResourceLocation("ancient_aether", "sky_grass"));
            ReduxColors.register(event, (state, level, pos, index) -> ReduxColors.getColor(state, level, pos, index, 1), new ResourceLocation("ancient_aether", "wynd_thistle"), new ResourceLocation("ancient_aether", "potted_wynd_thistle"), new ResourceLocation("ancient_aether", "sky_blues"), new ResourceLocation("ancient_aether", "potted_sky_blues"), new ResourceLocation("ancient_aether", "sunset_rose"), new ResourceLocation("ancient_aether", "potted_sunset_rose"), new ResourceLocation("ancient_aether", "elevetia"), new ResourceLocation("ancient_aether", "potted_elevetia"));
        }
        if (Redux.deepAetherCompat()) {
            ReduxColors.register(event, (state, level, pos, index) -> ReduxColors.getColor(state, level, pos, index, 1), new ResourceLocation("deep_aether", "radiant_orchid"), new ResourceLocation("deep_aether", "potted_radiant_orchid"), new ResourceLocation("deep_aether", "aerlavender"), new ResourceLocation("deep_aether", "potted_aerlavender"), new ResourceLocation("deep_aether", "tall_aerlavender"), new ResourceLocation("deep_aether", "feather_grass"), new ResourceLocation("deep_aether", "potted_tall_aerlavender"), new ResourceLocation("deep_aether", "sky_tulips"), new ResourceLocation("deep_aether", "potted_sky_tulips"), new ResourceLocation("deep_aether", "iaspove"), new ResourceLocation("deep_aether", "potted_iaspove"), new ResourceLocation("deep_aether", "golden_aspess"), new ResourceLocation("deep_aether", "potted_golden_aspess"), new ResourceLocation("deep_aether", "echaisy"), new ResourceLocation("deep_aether", "potted_echaisy"), new ResourceLocation("deep_aether", "glowing_spores"));
            ReduxColors.register(event, (state, level, pos, index) -> pos != null ? ReduxColors.getColor(state, level, state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos, index, 1) : 11401668, new ResourceLocation("deep_aether", "tall_feather_grass"));
            ReduxColors.register(event, (state, level, pos, index) -> {
                boolean isTop;
                boolean bl = isTop = state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
                return pos != null ? ReduxColors.getColor(state, level, isTop ? pos.m_7495_() : pos, index, isTop ? 1 : 0) : 11401668;
            }, new ResourceLocation("deep_aether", "tall_glowing_grass"));
        }
    }

    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        Redux.LOGGER.debug("Beginning item color registration for the Aether: Redux");
        event.register((stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)AetherBlocks.AETHER_GRASS_BLOCK.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)AetherBlocks.WHITE_FLOWER.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)AetherBlocks.PURPLE_FLOWER.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12496613 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.BLIGHTED_AETHER_GRASS_BLOCK.get()});
        event.register((stack, tintIndex) -> tintIndex == 0 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.SHORT_AETHER_GRASS.get()});
        event.register((stack, tintIndex) -> tintIndex == 0 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.SPLITFERN.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.FLAREBLOSSOM.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.INFERNIA.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12496613 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.LUXWEED.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.WYNDSPROUTS.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12582892 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.SKYSPROUTS.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12582892 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.XAELIA_PATCH.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 16772502 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.AURUM.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 16774563 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.ZYATRIX.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12582892 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.IRIDIA.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12582892 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.DAGGERBLOOM.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 14155724 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.THERATIP.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 0xCCF7FF : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.LUMINA.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12496613 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.SPIROLYCTIL.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? 12496613 : 0xFFFFFF, new ItemLike[]{(ItemLike)ReduxBlocks.BLIGHTSHADE.get()});
        if (Redux.ancientAetherCompat()) {
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 0 ? 11401668 : 0xFFFFFF, new ResourceLocation("ancient_aether", "sky_grass"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 13364478 : 0xFFFFFF, new ResourceLocation("ancient_aether", "wynd_thistle"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ResourceLocation("ancient_aether", "sky_blues"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ResourceLocation("ancient_aether", "sunset_rose"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 12707530 : 0xFFFFFF, new ResourceLocation("ancient_aether", "elevetia"));
        }
        if (Redux.deepAetherCompat()) {
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 0xCFFFF1 : 0xFFFFFF, new ResourceLocation("deep_aether", "radiant_orchid"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 12905936 : 0xFFFFFF, new ResourceLocation("deep_aether", "aerlavender"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 12905936 : 0xFFFFFF, new ResourceLocation("deep_aether", "tall_aerlavender"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 13565949 : 0xFFFFFF, new ResourceLocation("deep_aether", "feather_grass"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 13565949 : 0xFFFFFF, new ResourceLocation("deep_aether", "tall_feather_grass"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ResourceLocation("deep_aether", "sky_tulips"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ResourceLocation("deep_aether", "iaspove"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ResourceLocation("deep_aether", "golden_aspess"));
            ReduxColors.register(event, (stack, tintIndex) -> tintIndex == 1 ? 11401668 : 0xFFFFFF, new ResourceLocation("deep_aether", "echaisy"));
        }
    }

    public static int getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index, int indexGoal) {
        return index == indexGoal ? (level != null && pos != null ? (level.m_8055_(pos.m_7495_()).m_60713_((Block)ReduxBlocks.BLIGHTMOSS_BLOCK.get()) ? 12033729 : (level.m_8055_(pos.m_7495_()).m_60713_((Block)ReduxBlocks.BLIGHTED_AETHER_GRASS_BLOCK.get()) ? 12496613 : ReduxColors.getAverageColor(level, pos, AETHER_GRASS_RESOLVER))) : 11401668) : 0xFFFFFF;
    }

    private static int getAverageColor(BlockAndTintGetter level, BlockPos blockPos, ColorResolver colorResolver) {
        try {
            return level.m_6171_(blockPos, colorResolver);
        }
        catch (Exception e) {
            Redux.LOGGER.error("Failed to get Aether Grass color, this is not intended! Ignoring exception and using default color", (Throwable)e);
            return 11401668;
        }
    }

    public static void resolvers(RegisterColorHandlersEvent.ColorResolvers event) {
        event.register(AETHER_GRASS_RESOLVER);
    }

    private static void register(RegisterColorHandlersEvent.Item colors, ItemColor resolver, Consumer<String> onError, ResourceLocation ... locations) {
        for (ResourceLocation location : locations) {
            if (ForgeRegistries.ITEMS.containsKey(location)) {
                colors.register(resolver, new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(location)});
                continue;
            }
            onError.accept(location.toString());
        }
    }

    private static void register(RegisterColorHandlersEvent.Item colors, ItemColor resolver, ResourceLocation ... locations) {
        ReduxColors.register(colors, resolver, ITEM_ERROR, locations);
    }

    private static void register(RegisterColorHandlersEvent.Block colors, BlockColor resolver, ResourceLocation ... locations) {
        ReduxColors.register(colors, resolver, BLOCK_ERROR, locations);
    }

    private static void register(RegisterColorHandlersEvent.Block colors, BlockColor resolver, Consumer<String> onError, ResourceLocation ... locations) {
        for (ResourceLocation location : locations) {
            if (ForgeRegistries.BLOCKS.containsKey(location)) {
                colors.register(resolver, new Block[]{(Block)ForgeRegistries.BLOCKS.getValue(location)});
                continue;
            }
            onError.accept(location.toString());
        }
    }
}

