/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.player;

import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.simple.SimpleChannel;
import net.zepalesque.redux.capability.player.AdrenalineModule;
import net.zepalesque.redux.capability.player.BlightshadeModule;
import net.zepalesque.redux.capability.player.LoreBookModule;
import net.zepalesque.redux.capability.player.ReduxPlayer;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.ReduxPlayerSyncPacket;
import net.zepalesque.redux.util.player.AbilityUtil;
import org.apache.commons.lang3.tuple.Triple;

public class ReduxPlayerCapability
implements ReduxPlayer {
    private final Player player;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setMaxAirJumps", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setMaxAirJumps((Integer)object), this::getMaxAirJumps)));
    private final LoreBookModule lore;
    private final BlightshadeModule blightshade;
    private final AdrenalineModule adrenaline;
    int maxAirJumps = 0;
    int ticksInAir = 0;
    int airJumps = 0;
    int prevTickAirJumps = 0;
    int airJumpCooldown = 0;
    private boolean secondFireball = false;

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public ReduxPlayerCapability(Player pPlayer) {
        this.player = pPlayer;
        this.lore = new LoreBookModule();
        this.blightshade = new BlightshadeModule(pPlayer);
        this.adrenaline = new AdrenalineModule(pPlayer);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getMaxAirJumps() {
        return this.maxAirJumps;
    }

    @Override
    public void setMaxAirJumps(int jumps) {
        this.maxAirJumps = jumps;
    }

    @Override
    public int getAirJumpsPerformed() {
        return this.airJumps;
    }

    @Override
    public boolean increaseAirJumpCount() {
        if (this.airJumpCooldown == 0 && this.airJumps < this.maxAirJumps) {
            ++this.airJumps;
            this.airJumpCooldown = 4;
            return true;
        }
        return false;
    }

    @Override
    public int getPrevTickAirJumps() {
        return this.prevTickAirJumps;
    }

    @Override
    public int getAirJumpCooldown() {
        return this.airJumpCooldown;
    }

    @Override
    public int ticksInAir() {
        return this.ticksInAir;
    }

    @Override
    public LoreBookModule getLoreModule() {
        return this.lore;
    }

    @Override
    public BlightshadeModule getBlightshadeModule() {
        return this.blightshade;
    }

    @Override
    public AdrenalineModule getAdrenalineModule() {
        return this.adrenaline;
    }

    @Override
    public void tick() {
        this.blightshade.tick();
        this.adrenaline.tick();
        this.prevTickAirJumps = this.airJumps;
        if (this.getPlayer().m_20096_()) {
            this.ticksInAir = 0;
            this.airJumps = 0;
            this.airJumpCooldown = 0;
        } else {
            ++this.ticksInAir;
        }
        if (this.airJumpCooldown > 0) {
            --this.airJumpCooldown;
        }
    }

    @Override
    public boolean doubleJump() {
        if (this.increaseAirJumpCount()) {
            AbilityUtil.doDoubleJumpMovement((LivingEntity)this.getPlayer());
            return true;
        }
        return false;
    }

    @Override
    public boolean fireballSetup() {
        if (this.player.m_36335_().m_41519_((Item)ReduxItems.SOLAR_EMBLEM.get())) {
            return false;
        }
        if (EquipmentUtil.hasCurio((LivingEntity)this.getPlayer(), (Item)((Item)ReduxItems.SOLAR_EMBLEM.get()))) {
            this.player.m_36335_().m_41524_((Item)ReduxItems.SOLAR_EMBLEM.get(), this.player.m_7500_() ? 4 : 40);
        }
        return true;
    }

    @Override
    public boolean canShootFireball() {
        return !this.player.m_9236_().m_5776_() && !this.player.m_36335_().m_41519_((Item)ReduxItems.SOLAR_EMBLEM.get()) && EquipmentUtil.hasCurio((LivingEntity)this.player, (Item)((Item)ReduxItems.SOLAR_EMBLEM.get()));
    }

    public boolean doubleFireball() {
        if (this.secondFireball) {
            this.secondFireball = false;
            return true;
        }
        return false;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new ReduxPlayerSyncPacket(this.getPlayer().m_19879_(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return ReduxPacketHandler.INSTANCE;
    }

    @Override
    public void deserializeSynchableNBT(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("max_jumps", this.maxAirJumps);
        tag.m_128405_("jumps", this.airJumps);
        tag.m_128405_("ticks_in_air", this.ticksInAir);
        tag.m_128365_("lore_module", this.lore.serializeNBT());
        tag.m_128365_("blightshade_module", this.blightshade.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.maxAirJumps = nbt.m_128451_("max_jumps");
        this.airJumps = nbt.m_128451_("jumps");
        this.ticksInAir = nbt.m_128451_("ticks_in_air");
        this.lore.deserializeNBT(nbt.m_128423_("lore_module"));
        this.blightshade.deserializeNBT(nbt.m_128423_("blightshade_module"));
    }
}

