/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.player;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.BlightshadeParticlePacket;

public class BlightshadeModule
implements INBTSerializable {
    private int blightshadeCooldown;
    private int blightshadeEffectCooldown;
    private final Player player;

    public BlightshadeModule(Player plr) {
        this.player = plr;
    }

    public void tick() {
        if (this.blightshadeCooldown > 0) {
            --this.blightshadeCooldown;
        }
        if (this.blightshadeEffectCooldown > 0) {
            if (this.blightshadeEffectCooldown == 1) {
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 210, 0));
            }
            --this.blightshadeEffectCooldown;
        }
    }

    public int getBlightshadeCooldown() {
        return this.blightshadeCooldown;
    }

    public boolean blightshade(BlockPos pos, AABB bounds, LivingEntity entity) {
        if (!this.player.m_9236_().m_5776_()) {
            if (this.blightshadeCooldown > 0) {
                return false;
            }
            this.blightshadeCooldown = 100;
            this.doParticles(bounds, entity);
            this.player.m_9236_().m_5594_(null, pos, (SoundEvent)ReduxSoundEvents.BLIGHTSHADE_SPRAY.get(), SoundSource.BLOCKS, 0.8f, 0.9f + this.player.m_9236_().f_46441_.m_188501_() * 0.2f);
            this.blightshadeEffectCooldown = 10;
            return true;
        }
        return false;
    }

    public void doParticles(AABB bounds, LivingEntity entity) {
        Vec3 pos = entity.m_20182_();
        ReduxPacketHandler.sendToNear(new BlightshadeParticlePacket(bounds), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100.0, (ResourceKey<Level>)entity.m_9236_().m_46472_());
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("cooldown", this.blightshadeCooldown);
        tag.m_128405_("effect_cooldown", this.blightshadeEffectCooldown);
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            this.blightshadeCooldown = tag.m_128451_("cooldown");
            this.blightshadeEffectCooldown = tag.m_128451_("effect_cooldown");
        }
    }
}

