/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;
import net.zepalesque.redux.item.ReduxItems;

public class SproutsCropBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.m_49796_((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.m_49796_((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.m_49796_((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0)};

    public SproutsCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_);
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 5;
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public final boolean isMaxAge(BlockState state) {
        return this.getAge(state) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        int i;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (f = SproutsCropBlock.getGrowthSpeed((Block)this, (BlockGetter)level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, this.getStateForAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(level);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        level.m_7731_(pos, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)1, (int)3);
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = level.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(level, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)block)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(level, pos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.m_122012_();
        BlockPos blockpos2 = pos.m_122019_();
        BlockPos blockpos3 = pos.m_122024_();
        BlockPos blockpos4 = pos.m_122029_();
        boolean flag = level.m_8055_(blockpos3).m_60713_(block) || level.m_8055_(blockpos4).m_60713_(block);
        boolean bl = flag1 = level.m_8055_(blockpos1).m_60713_(block) || level.m_8055_(blockpos2).m_60713_(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = level.m_8055_(blockpos3.m_122012_()).m_60713_(block) || level.m_8055_(blockpos4.m_122012_()).m_60713_(block) || level.m_8055_(blockpos4.m_122019_()).m_60713_(block) || level.m_8055_(blockpos3.m_122019_()).m_60713_(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) && super.m_7898_(state, level, pos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ReduxItems.WYND_OATS.get();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growCrops((Level)level, pos, state);
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.CROP;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

