/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.function.Function;

public interface Mapper<T> {
    public Optional<T> decode(JsonElement var1);

    public JsonElement encode(T var1);

    public Optional<T> read(String var1);

    public String write(T var1);

    default public <Q> Mapper<Q> xmap(Function<T, Q> to, final Function<Q, T> from) {
        final Function<Optional, Optional> optionalFunc = ogVal -> ogVal.isEmpty() ? Optional.empty() : Optional.of(to.apply(ogVal.get()));
        final Mapper og = this;
        return new Mapper<Q>(){

            @Override
            public Optional<Q> decode(JsonElement json) {
                return (Optional)optionalFunc.apply(og.decode(json));
            }

            @Override
            public JsonElement encode(Q q) {
                return og.encode(from.apply(q));
            }

            @Override
            public Optional<Q> read(String s) {
                return (Optional)optionalFunc.apply(og.read(s));
            }

            @Override
            public String write(Q q) {
                return og.write(from.apply(q));
            }
        };
    }

    public static <A extends Enum<A>> Mapper<A> fromEnum(final Class<A> clazz) {
        return new Mapper<A>(){

            @Override
            public Optional<A> decode(JsonElement json) {
                try {
                    return json.isJsonPrimitive() ? Optional.of(Enum.valueOf(clazz, json.getAsString())) : Optional.empty();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }

            @Override
            public JsonElement encode(A a) {
                return new JsonPrimitive(((Enum)a).name());
            }

            @Override
            public Optional<A> read(String s) {
                try {
                    return Optional.of(Enum.valueOf(clazz, s));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }

            @Override
            public String write(A a) {
                return ((Enum)a).name();
            }
        };
    }
}

