/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.packconfig;

import com.google.gson.JsonElement;
import java.util.Optional;
import java.util.function.Supplier;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.packconfig.Category;
import net.zepalesque.redux.api.packconfig.IConfigSaving;
import net.zepalesque.redux.api.serialization.client.WidgetMapper;
import net.zepalesque.redux.api.serialization.client.WidgetMappers;
import org.jetbrains.annotations.Nullable;

public class PackConfig<T>
implements IConfigSaving,
Supplier<T> {
    private final String id;
    private boolean hasComment = false;
    @Nullable
    private final Category parent;
    private final WidgetMapper<T> mapper;
    private T value;
    private final T defVal;

    PackConfig(String id, WidgetMapper<T> mapper, T defVal, @Nullable Category parent) {
        this.id = id;
        this.parent = parent;
        this.mapper = mapper;
        this.value = defVal;
        this.defVal = defVal;
    }

    public boolean hasComment() {
        return this.hasComment;
    }

    public void markComment() {
        this.hasComment = true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public JsonElement write() {
        return this.mapper().encode(this.value);
    }

    @Override
    public void read(JsonElement json) {
        this.mapper().decode(json).ifPresent(this::setVal);
    }

    private void setVal(T val) {
        this.value = val;
    }

    public boolean set(T val) {
        if (this.value != val) {
            this.setVal(val);
            if (this.parent != null) {
                this.parent.save();
            }
            return true;
        }
        return false;
    }

    public WidgetMapper<T> mapper() {
        return this.mapper;
    }

    @Override
    @Nullable
    public Category parent() {
        return this.parent;
    }

    public boolean parseString(String s) {
        Optional optional = this.mapper().read(s);
        if (optional.isPresent()) {
            Object obj = optional.get();
            return this.set(obj);
        }
        return false;
    }

    public boolean validate(String s) {
        return this.mapper().read(s).isPresent();
    }

    public String asText() {
        return this.mapper().write(this.value);
    }

    public static class Builder {
        Category current;
        final Category base;
        boolean hasComment;

        Builder(Category base) {
            this.current = base;
            this.base = base;
        }

        public Builder comment() {
            this.hasComment = true;
            return this;
        }

        public Builder pop() {
            Category popTo = this.current.parent();
            if (popTo != null) {
                this.current = popTo;
            } else {
                Redux.LOGGER.warn("Already at top level, cannot pop config builder!");
            }
            return this;
        }

        public Builder pop(int amount) {
            if (amount < 0) {
                Redux.LOGGER.warn("Cannot pop a negative amount! Use the push method instead!");
                return this;
            }
            if (amount == 0) {
                Redux.LOGGER.warn("Popping zero times does nothing!");
                return this;
            }
            for (int i = 0; i < amount; ++i) {
                this.pop();
            }
            return this;
        }

        public Builder push(String id) {
            this.current = this.current.getOrCreate(id);
            return this;
        }

        public Builder push(String ... ids) {
            for (String id : ids) {
                this.push(id);
            }
            return this;
        }

        public <T> PackConfig<T> cfg(String id, T defVal, WidgetMapper<T> codec, @Nullable String possibleValues) {
            PackConfig<T> config = new PackConfig<T>(id, codec, defVal, this.current);
            if (this.hasComment) {
                config.markComment();
            }
            this.hasComment = false;
            this.current.addMember(config);
            return config;
        }

        public <T> PackConfig<T> cfg(String id, T defVal, WidgetMapper<T> codec) {
            return this.cfg(id, defVal, codec, null);
        }

        public PackConfig<Boolean> cfg(String id, boolean defVal) {
            return this.cfg(id, defVal, WidgetMappers.BOOL);
        }
    }
}

