/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraftforge.common.ForgeConfigSpec;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.api.condition.ConditionSerializers;
import net.zepalesque.redux.config.util.ReduxConfigSerialization;

public class ReduxConfigCondition
implements AbstractCondition<ReduxConfigCondition> {
    public static final Codec<ReduxConfigCondition> CODEC = RecordCodecBuilder.create(condition -> condition.group((App)Codec.STRING.fieldOf("config_path").forGetter(config -> ReduxConfigSerialization.serialize(config.config))).apply((Applicative)condition, ReduxConfigCondition::fromText));
    protected final ForgeConfigSpec.ConfigValue<Boolean> config;

    public static ReduxConfigCondition fromText(String config) {
        return new ReduxConfigCondition(ReduxConfigSerialization.deserialize(config));
    }

    public ReduxConfigCondition(ForgeConfigSpec.ConfigValue<Boolean> config) {
        this.config = config;
    }

    @Override
    public boolean isConditionMet() {
        if (this.config == null) {
            Redux.LOGGER.warn("Config Condition value was null! Printing stack trace...");
            Thread.dumpStack();
        }
        return this.config != null && (Boolean)this.config.get() != false;
    }

    @Override
    public Codec<ReduxConfigCondition> codec() {
        return (Codec)ConditionSerializers.REDUX_CONFIG.get();
    }

    @Override
    public String text() {
        return "ReduxConfigCondition{config='" + this.config.toString() + "'}";
    }
}

