/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.blockhandler;

import com.aetherteam.aether.block.construction.BookshelfBlock;
import com.aetherteam.aether.block.natural.AetherLogBlock;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;
import net.zepalesque.redux.api.blockhandler.BlockHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.construction.LayeredBookshelfBlock;
import net.zepalesque.redux.block.natural.ReduxNaturalLog;
import net.zepalesque.redux.block.natural.ReduxNaturalWall;
import net.zepalesque.redux.block.sign.ReduxCeilingHangingSignBlock;
import net.zepalesque.redux.block.sign.ReduxSignBlock;
import net.zepalesque.redux.block.sign.ReduxWallHangingSignBlock;
import net.zepalesque.redux.block.sign.ReduxWallSignBlock;
import net.zepalesque.redux.blockentity.ReduxBlockEntityTypes;
import net.zepalesque.redux.blockentity.ReduxHangingSignBlockEntity;
import net.zepalesque.redux.blockentity.ReduxSignBlockEntity;
import net.zepalesque.redux.blockhandlers.WoodHandlers;
import net.zepalesque.redux.data.ReduxBlockstateData;
import net.zepalesque.redux.data.ReduxItemModelData;
import net.zepalesque.redux.data.ReduxLanguageData;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.entity.misc.ReduxBoat;
import net.zepalesque.redux.entity.misc.ReduxChestBoat;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.item.misc.ReduxBoatItem;
import net.zepalesque.redux.misc.ReduxTags;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WoodHandler
implements BlockHandler {
    public final TagKey<Item> logsTag;
    public final TagKey<Block> logsBlockTag;
    public final Optional<TagKey<Block>> sporingBlocksBlockTag;
    public final RegistryObject<Block> planks;
    public final RegistryObject<RotatedPillarBlock> log;
    public final RegistryObject<RotatedPillarBlock> wood;
    public final Optional<RegistryObject<RotatedPillarBlock>> strippedLog;
    public final Optional<RegistryObject<RotatedPillarBlock>> strippedWood;
    public final RegistryObject<StairBlock> stairs;
    public final RegistryObject<SlabBlock> slab;
    public final RegistryObject<FenceBlock> fence;
    public final RegistryObject<FenceGateBlock> fenceGate;
    public final RegistryObject<DoorBlock> door;
    public final RegistryObject<TrapDoorBlock> trapdoor;
    public final RegistryObject<PressurePlateBlock> pressurePlate;
    public final RegistryObject<ButtonBlock> button;
    public final RegistryObject<BookshelfBlock> bookshelf;
    public final RegistryObject<StandingSignBlock> sign;
    public final RegistryObject<WallSignBlock> wallSign;
    public final RegistryObject<WallHangingSignBlock> wallHangingSign;
    public final RegistryObject<CeilingHangingSignBlock> hangingSign;
    public final RegistryObject<SignItem> signItem;
    public final RegistryObject<HangingSignItem> hangingSignItem;
    public final RegistryObject<ReduxBoatItem> boatItem;
    public final RegistryObject<ReduxBoatItem> chestBoatItem;
    public final RegistryObject<WallBlock> logWall;
    public final RegistryObject<WallBlock> woodWall;
    public final Optional<RegistryObject<WallBlock>> strippedLogWall;
    public final Optional<RegistryObject<WallBlock>> strippedWoodWall;
    public final RegistryObject<EntityType<ReduxBoat>> boatEntity;
    public final RegistryObject<EntityType<ReduxChestBoat>> chestBoatEntity;
    public final RegistryObject<BlockEntityType<ReduxSignBlockEntity>> signEntity;
    public final RegistryObject<BlockEntityType<ReduxHangingSignBlockEntity>> hangingSignEntity;
    public final WoodType woodType;
    public final BlockSetType blockSet;
    public final String woodName;
    @Nullable
    public final String langName;
    public final boolean alwaysLogWalls;
    public final SoundType plankSoundType;
    public final SoundType logSoundType;
    public final String logSuffix;
    public final String woodSuffix;
    public final boolean hasSporingLogs;
    public final boolean hasStrippedLogs;
    public final boolean layeredBookshelf;
    public final Optional<RegistryObject<RotatedPillarBlock>> sporingLog;
    public final Optional<RegistryObject<RotatedPillarBlock>> sporingWood;
    public final String treeName;

    public static BiFunction<String, SoundType, BlockSetType> createBlockSet(SoundEvent doorClose, SoundEvent doorOpen, SoundEvent trapdoorClose, SoundEvent trapdoorOpen, SoundEvent pressurePlateClickOff, SoundEvent pressurePlateClickOn, SoundEvent buttonClickOff, SoundEvent buttonClickOn) {
        return (name, soundType) -> new BlockSetType(name, true, soundType, doorClose, doorOpen, trapdoorClose, trapdoorOpen, pressurePlateClickOff, pressurePlateClickOn, buttonClickOff, buttonClickOn);
    }

    public static BiFunction<String, SoundType, BlockSetType> bambooSoundBlockSet() {
        return WoodHandler.createBlockSet(SoundEvents.f_244543_, SoundEvents.f_243707_, SoundEvents.f_243699_, SoundEvents.f_243903_, SoundEvents.f_244533_, SoundEvents.f_244181_, SoundEvents.f_244603_, SoundEvents.f_244067_);
    }

    public static BiFunction<String, SoundType, BlockSetType> cherrySoundBlockSet() {
        return WoodHandler.createBlockSet(SoundEvents.f_271488_, SoundEvents.f_271095_, SoundEvents.f_271262_, SoundEvents.f_271395_, SoundEvents.f_271444_, SoundEvents.f_271406_, SoundEvents.f_271322_, SoundEvents.f_271171_);
    }

    public static BiFunction<String, SoundType, BlockSetType> netherSoundBlockSet() {
        return WoodHandler.createBlockSet(SoundEvents.f_243719_, SoundEvents.f_244275_, SoundEvents.f_244033_, SoundEvents.f_244318_, SoundEvents.f_243893_, SoundEvents.f_244210_, SoundEvents.f_244344_, SoundEvents.f_244414_);
    }

    public static BiFunction<String, SoundType, BlockSetType> woodSoundBlockSet() {
        return WoodHandler.createBlockSet(SoundEvents.f_12626_, SoundEvents.f_12627_, SoundEvents.f_12628_, SoundEvents.f_12629_, SoundEvents.f_12636_, SoundEvents.f_12637_, SoundEvents.f_12631_, SoundEvents.f_12632_);
    }

    public static WoodHandler tree(String pWoodname, boolean pLogWalls, MapColor pBarkColor, MapColor pWoodColor, boolean layeredBookshelf) {
        return WoodHandler.handler(pWoodname, null, true, WoodHandler.woodSoundBlockSet(), "trees", "log", "wood", SoundType.f_56736_, SoundType.f_56736_, pLogWalls, pBarkColor, pWoodColor, false, layeredBookshelf);
    }

    public static WoodHandler fungus(String pWoodname, boolean pLogWalls, MapColor pBarkColor, MapColor pWoodColor, boolean layeredBookshelf) {
        return WoodHandler.handler(pWoodname, null, true, WoodHandler.netherSoundBlockSet(), "mushrooms", "stem", "hyphae", SoundType.f_244244_, SoundType.f_56763_, pLogWalls, pBarkColor, pWoodColor, false, layeredBookshelf);
    }

    public static WoodHandler noStrippingFungus(String pWoodname, boolean pLogWalls, MapColor pBarkColor, MapColor pWoodColor, boolean layeredBookshelf) {
        return WoodHandler.handler(pWoodname, null, false, WoodHandler.netherSoundBlockSet(), "mushrooms", "stem", "hyphae", SoundType.f_244244_, SoundType.f_56763_, pLogWalls, pBarkColor, pWoodColor, false, layeredBookshelf);
    }

    public static WoodHandler handler(String pWoodName, @Nullable String pLangName, boolean pStrippedLog, BiFunction<String, SoundType, BlockSetType> blockSetTypeFunction, String pTreeName, String pLogSuffix, String pWoodSuffix, SoundType pPlankSoundType, SoundType pLogSoundType, boolean pLogWalls, MapColor barkColor, MapColor woodColor, boolean hasSporingLogs, boolean layeredBookshelf) {
        try {
            return new WoodHandler(pWoodName, pLangName, pStrippedLog, blockSetTypeFunction, pTreeName, pLogSuffix, pWoodSuffix, pPlankSoundType, pLogSoundType, pLogWalls, barkColor, woodColor, hasSporingLogs, layeredBookshelf);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected WoodHandler(String pWoodName, @Nullable String pLangName, boolean pStrippedLogs, BiFunction<String, SoundType, BlockSetType> blockSetTypeFunction, String pTreeName, String pLogSuffix, String pWoodSuffix, SoundType pPlankSoundType, SoundType pLogSoundType, boolean pLogWalls, MapColor barkColor, MapColor woodColor, boolean pSporingLogs, boolean layeredBookshelf) {
        this.hasSporingLogs = pSporingLogs;
        this.hasStrippedLogs = pStrippedLogs;
        this.treeName = pTreeName;
        if (pSporingLogs) {
            RegistryObject sporingLogRegistry = ReduxBlocks.register("sporing_" + pWoodName + "_" + pLogSuffix, () -> new AetherLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(pLogSoundType).m_284180_(barkColor)));
            this.sporingLog = Optional.of(sporingLogRegistry);
            RegistryObject sporingWoodRegistry = ReduxBlocks.register("sporing_" + pWoodName + "_" + pWoodSuffix, () -> new AetherLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(pLogSoundType).m_284180_(barkColor)));
            this.sporingWood = Optional.of(sporingWoodRegistry);
            this.sporingBlocksBlockTag = Optional.of(ReduxTags.Blocks.tag("sporing_" + pWoodName + "_" + pLogSuffix + "s"));
        } else {
            this.sporingLog = Optional.empty();
            this.sporingWood = Optional.empty();
            this.sporingBlocksBlockTag = Optional.empty();
        }
        this.logSuffix = pLogSuffix;
        this.woodSuffix = pWoodSuffix;
        this.alwaysLogWalls = pLogWalls;
        this.plankSoundType = pPlankSoundType;
        this.logSoundType = pLogSoundType;
        this.logsTag = ReduxTags.Items.tag(pWoodName + "_" + pLogSuffix + "s");
        this.logsBlockTag = ReduxTags.Blocks.tag(pWoodName + "_" + pLogSuffix + "s");
        this.woodName = pWoodName;
        this.langName = pLangName;
        this.bookshelf = ReduxBlocks.register(pWoodName + "_bookshelf", layeredBookshelf ? () -> new LayeredBookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_).m_284180_(woodColor).m_60918_(pPlankSoundType)) : () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_).m_284180_(woodColor).m_60918_(pPlankSoundType)));
        this.layeredBookshelf = layeredBookshelf;
        this.blockSet = blockSetTypeFunction.apply("aether_redux:" + pWoodName, pPlankSoundType);
        this.woodType = new WoodType("aether_redux:" + pWoodName, this.blockSet);
        this.signEntity = ReduxBlockEntityTypes.BLOCK_ENTITY_TYPES.register(pWoodName + "_sign", () -> BlockEntityType.Builder.m_155273_((pPos, pState) -> new ReduxSignBlockEntity(pPos, pState, (BlockEntityType<ReduxSignBlockEntity>)((BlockEntityType)this.getSign().get())), (Block[])new Block[]{(Block)this.getSignBlock().get(), (Block)this.getWallSignBlock().get()}).m_58966_(null));
        this.hangingSignEntity = ReduxBlockEntityTypes.BLOCK_ENTITY_TYPES.register(pWoodName + "_hanging_sign", () -> BlockEntityType.Builder.m_155273_((pPos, pState) -> new ReduxHangingSignBlockEntity(pPos, pState, (BlockEntityType<ReduxHangingSignBlockEntity>)((BlockEntityType)this.getHangingSign().get())), (Block[])new Block[]{(Block)this.getHangingSignBlock().get(), (Block)this.getWallHangingSignBlock().get()}).m_58966_(null));
        this.boatEntity = ReduxEntityTypes.ENTITY_TYPES.register(pWoodName + "_boat", () -> EntityType.Builder.m_20704_(ReduxBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(pWoodName + "_boat"));
        this.chestBoatEntity = ReduxEntityTypes.ENTITY_TYPES.register(pWoodName + "_chest_boat", () -> EntityType.Builder.m_20704_(ReduxChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(pWoodName + "_chest_boat"));
        this.log = ReduxBlocks.register(pWoodName + "_" + pLogSuffix, () -> new AetherLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(pLogSoundType).m_284180_(barkColor)));
        this.wood = ReduxBlocks.register(pWoodName + "_" + pWoodSuffix, () -> new ReduxNaturalLog(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60918_(pLogSoundType).m_284180_(barkColor)));
        if (this.hasStrippedLogs) {
            RegistryObject strippedLog = ReduxBlocks.register("stripped_" + pWoodName + "_" + pLogSuffix, () -> new ReduxNaturalLog(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_60918_(pLogSoundType).m_284180_(woodColor)));
            this.strippedLog = Optional.of(strippedLog);
            RegistryObject strippedWood = ReduxBlocks.register("stripped_" + pWoodName + "_" + pWoodSuffix, () -> new ReduxNaturalLog(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_).m_60918_(pLogSoundType).m_284180_(woodColor)));
            this.strippedWood = Optional.of(strippedWood);
            RegistryObject strippedLogWall = ReduxBlocks.register("stripped_" + this.woodName + "_" + pLogSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_284310_().m_284180_(woodColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
            RegistryObject strippedWoodWall = ReduxBlocks.register("stripped_" + this.woodName + "_" + pWoodSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_284310_().m_284180_(woodColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
            this.strippedLogWall = Optional.of(strippedLogWall);
            this.strippedWoodWall = Optional.of(strippedWoodWall);
        } else {
            this.strippedLog = Optional.empty();
            this.strippedWood = Optional.empty();
            this.strippedLogWall = Optional.empty();
            this.strippedWoodWall = Optional.empty();
        }
        this.planks = ReduxBlocks.register(pWoodName + "_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60918_(pPlankSoundType).m_284180_(woodColor)));
        this.stairs = ReduxBlocks.register(pWoodName + "_stairs", () -> new StairBlock(() -> ((Block)this.planks.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.planks.get()))));
        this.slab = ReduxBlocks.register(pWoodName + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.planks.get())).m_60913_(2.0f, 3.0f)));
        this.fence = ReduxBlocks.register(pWoodName + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_).m_60918_(pPlankSoundType).m_284180_(woodColor)));
        this.fenceGate = ReduxBlocks.register(pWoodName + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_).m_60918_(pPlankSoundType).m_284180_(woodColor), this.woodType));
        this.door = ReduxBlocks.register(pWoodName + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_).m_60918_(pPlankSoundType).m_284180_(woodColor), this.blockSet));
        this.trapdoor = ReduxBlocks.register(pWoodName + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_).m_60918_(pPlankSoundType).m_284180_(woodColor), this.blockSet));
        this.pressurePlate = ReduxBlocks.register(pWoodName + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60918_(pPlankSoundType).m_284180_(woodColor), this.blockSet));
        this.button = ReduxBlocks.register(pWoodName + "_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_60918_(pPlankSoundType).m_284180_(woodColor), this.blockSet, 30, true));
        this.sign = ReduxBlocks.BLOCKS.register(pWoodName + "_sign", () -> new ReduxSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(woodColor).m_60910_().m_60978_(1.0f).m_60918_(pPlankSoundType), this.woodType){

            @Override
            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return new ReduxSignBlockEntity(pos, state, (BlockEntityType<ReduxSignBlockEntity>)((BlockEntityType)WoodHandler.this.getSign().get()));
            }
        });
        this.wallSign = ReduxBlocks.BLOCKS.register(pWoodName + "_wall_sign", () -> new ReduxWallSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(woodColor).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), this.woodType){

            @Override
            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return new ReduxSignBlockEntity(pos, state, (BlockEntityType<ReduxSignBlockEntity>)((BlockEntityType)WoodHandler.this.getSign().get()));
            }
        });
        this.hangingSign = ReduxBlocks.BLOCKS.register(pWoodName + "_hanging_sign", () -> new ReduxCeilingHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(woodColor).m_60910_().m_60978_(1.0f).m_60918_(pPlankSoundType), this.woodType){

            @Override
            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return new ReduxHangingSignBlockEntity(pos, state, (BlockEntityType<ReduxHangingSignBlockEntity>)((BlockEntityType)WoodHandler.this.getHangingSign().get()));
            }
        });
        this.wallHangingSign = ReduxBlocks.BLOCKS.register(pWoodName + "_wall_hanging_sign", () -> new ReduxWallHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(woodColor).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), this.woodType){

            @Override
            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return new ReduxHangingSignBlockEntity(pos, state, (BlockEntityType<ReduxHangingSignBlockEntity>)((BlockEntityType)WoodHandler.this.getHangingSign().get()));
            }
        });
        this.boatItem = ReduxItems.ITEMS.register(pWoodName + "_boat", () -> new ReduxBoatItem(false, new Item.Properties().m_41487_(1), (level, hitresult) -> new ReduxBoat(this, (Level)level, hitresult.m_82450_().f_82479_, hitresult.m_82450_().f_82480_, hitresult.m_82450_().f_82481_){}));
        this.chestBoatItem = ReduxItems.ITEMS.register(pWoodName + "_chest_boat", () -> new ReduxBoatItem(false, new Item.Properties().m_41487_(1), (level, hitresult) -> new ReduxChestBoat(this, (Level)level, hitresult.m_82450_().f_82479_, hitresult.m_82450_().f_82480_, hitresult.m_82450_().f_82481_){}));
        this.signItem = ReduxItems.register(pWoodName + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)this.sign.get(), (Block)this.wallSign.get()));
        this.hangingSignItem = ReduxItems.register(pWoodName + "_hanging_sign", () -> new HangingSignItem((Block)this.hangingSign.get(), (Block)this.wallHangingSign.get(), new Item.Properties().m_41487_(16)));
        this.logWall = ReduxBlocks.register(this.woodName + "_" + pLogSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_284310_().m_284180_(barkColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
        this.woodWall = ReduxBlocks.register(this.woodName + "_" + pWoodSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_284310_().m_284180_(barkColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
    }

    private RegistryObject<BlockEntityType<ReduxSignBlockEntity>> getSign() {
        return this.signEntity;
    }

    private RegistryObject<StandingSignBlock> getSignBlock() {
        return this.sign;
    }

    private RegistryObject<WallSignBlock> getWallSignBlock() {
        return this.wallSign;
    }

    private RegistryObject<BlockEntityType<ReduxHangingSignBlockEntity>> getHangingSign() {
        return this.hangingSignEntity;
    }

    private RegistryObject<CeilingHangingSignBlock> getHangingSignBlock() {
        return this.hangingSign;
    }

    private RegistryObject<WallHangingSignBlock> getWallHangingSignBlock() {
        return this.wallHangingSign;
    }

    @Override
    public void generateBlockstateData(ReduxBlockstateData data) {
        data.log((RotatedPillarBlock)this.log.get());
        this.strippedLog.ifPresent(reg -> data.log((RotatedPillarBlock)reg.get()));
        data.block((Block)this.planks.get(), "construction/");
        data.wood((RotatedPillarBlock)this.wood.get(), (RotatedPillarBlock)this.log.get());
        this.strippedWood.ifPresent(reg -> data.wood((RotatedPillarBlock)reg.get(), (RotatedPillarBlock)this.strippedLog.get().get()));
        data.stairs((StairBlock)this.stairs.get(), (Block)this.planks.get(), "construction/");
        data.slab((SlabBlock)this.slab.get(), (Block)this.planks.get(), "construction/");
        data.fence((FenceBlock)this.fence.get(), (Block)this.planks.get(), "construction/");
        data.fenceGateBlock((FenceGateBlock)this.fenceGate.get(), (Block)this.planks.get(), "construction/");
        data.doorBlock((DoorBlock)this.door.get(), data.texture(data.name((Block)this.door.get()), "construction/", "_bottom"), data.texture(data.name((Block)this.door.get()), "construction/", "_top"));
        data.trapdoorBlock((TrapDoorBlock)this.trapdoor.get(), data.texture(data.name((Block)this.trapdoor.get()), "construction/"), true);
        data.pressurePlateBlock((PressurePlateBlock)this.pressurePlate.get(), data.texture(data.name((Block)this.planks.get()), "construction/"));
        data.buttonBlock((ButtonBlock)this.button.get(), data.texture(data.name((Block)this.planks.get()), "construction/"));
        data.signBlock((StandingSignBlock)this.sign.get(), (WallSignBlock)this.wallSign.get(), data.texture(data.name((Block)this.planks.get()), "construction/"));
        data.hangingSignBlock((CeilingHangingSignBlock)this.hangingSign.get(), (WallHangingSignBlock)this.wallHangingSign.get(), data.texture(data.name((Block)this.planks.get()), "construction/"));
        if (this.layeredBookshelf) {
            data.layeredBookshelf((Block)this.bookshelf.get(), (Block)this.planks.get());
        } else {
            data.bookshelf((Block)this.bookshelf.get(), (Block)this.planks.get());
        }
        BlockModelBuilder postBig = data.makeWallPostModel(4, 16, "wooden_post_big");
        BlockModelBuilder postShort = data.makeWallPostModel(3, 14, "wooden_post_short");
        BlockModelBuilder postTall = data.makeWallPostModel(3, 16, "wooden_post_tall");
        BlockModelBuilder side = data.makeWallSideModel(5, 14, "wooden_side", ModelBuilder.FaceRotation.CLOCKWISE_90, 0, 5);
        BlockModelBuilder sideAlt = data.makeWallSideModel(5, 14, "wooden_side_alt", ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90, 11, 16);
        BlockModelBuilder sideTall = data.makeWallSideModel(5, 16, "wooden_side_tall", ModelBuilder.FaceRotation.CLOCKWISE_90, 0, 5);
        BlockModelBuilder sideTallAlt = data.makeWallSideModel(5, 16, "wooden_side_tall_alt", ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90, 11, 16);
        BlockModelBuilder sideShort = data.makeWallSideModel(4, 14, "wooden_side_short", ModelBuilder.FaceRotation.CLOCKWISE_90, 0, 4);
        BlockModelBuilder sideAltShort = data.makeWallSideModel(4, 14, "wooden_side_alt_short", ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90, 12, 16);
        BlockModelBuilder sideTallShort = data.makeWallSideModel(4, 16, "wooden_side_tall_short", ModelBuilder.FaceRotation.CLOCKWISE_90, 0, 4);
        BlockModelBuilder sideTallAltShort = data.makeWallSideModel(4, 16, "wooden_side_tall_alt_short", ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90, 12, 16);
        data.logWallBlock((WallBlock)this.logWall.get(), (Block)this.log.get(), "natural/", this.log.getId().m_135827_(), true, (ModelFile)postBig, (ModelFile)postShort, (ModelFile)postTall, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)sideTall, (ModelFile)sideTallAlt, (ModelFile)sideShort, (ModelFile)sideAltShort, (ModelFile)sideTallShort, (ModelFile)sideTallAltShort);
        this.strippedLogWall.ifPresent(arg_0 -> this.lambda$generateBlockstateData$41(data, (ModelFile)postBig, (ModelFile)postShort, (ModelFile)postTall, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)sideTall, (ModelFile)sideTallAlt, (ModelFile)sideShort, (ModelFile)sideAltShort, (ModelFile)sideTallShort, (ModelFile)sideTallAltShort, arg_0));
        data.logWallBlock((WallBlock)this.woodWall.get(), (Block)this.log.get(), "natural/", this.log.getId().m_135827_(), false, (ModelFile)postBig, (ModelFile)postShort, (ModelFile)postTall, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)sideTall, (ModelFile)sideTallAlt, (ModelFile)sideShort, (ModelFile)sideAltShort, (ModelFile)sideTallShort, (ModelFile)sideTallAltShort);
        this.strippedWoodWall.ifPresent(arg_0 -> this.lambda$generateBlockstateData$42(data, (ModelFile)postBig, (ModelFile)postShort, (ModelFile)postTall, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)sideTall, (ModelFile)sideTallAlt, (ModelFile)sideShort, (ModelFile)sideAltShort, (ModelFile)sideTallShort, (ModelFile)sideTallAltShort, arg_0));
        this.sporingLog.ifPresent(sLog -> {
            data.enchantedLogGlow((RotatedPillarBlock)sLog.get(), (RotatedPillarBlock)this.log.get());
            this.sporingWood.ifPresent(sWood -> data.woodGlow((RotatedPillarBlock)sWood.get(), (RotatedPillarBlock)sLog.get()));
        });
    }

    @Override
    public void generateItemModels(ReduxItemModelData data) {
        data.itemBlock((Supplier<? extends Block>)this.log);
        this.strippedLog.ifPresent(reg -> data.itemBlock((Block)reg.get()));
        data.itemBlock((Supplier<? extends Block>)this.planks);
        this.strippedWood.ifPresent(reg -> data.itemBlock((Block)reg.get()));
        data.itemBlock((Supplier<? extends Block>)this.wood);
        data.itemBlock((Supplier<? extends Block>)this.stairs);
        data.itemBlock((Supplier<? extends Block>)this.slab);
        data.itemBlock((Supplier<? extends Block>)this.bookshelf);
        data.itemBlock((Supplier<? extends Block>)this.trapdoor, "_bottom");
        data.itemFence((Block)this.fence.get(), (Block)this.planks.get(), "construction/");
        data.itemBlock((Supplier<? extends Block>)this.fenceGate);
        data.item(((DoorBlock)this.door.get()).m_5456_(), "misc/");
        data.itemBlock((Supplier<? extends Block>)this.pressurePlate);
        data.itemButton((Block)this.button.get(), (Block)this.planks.get(), "construction/");
        data.item(((SignItem)this.signItem.get()).m_5456_(), "misc/");
        data.item(((HangingSignItem)this.hangingSignItem.get()).m_5456_(), "misc/");
        data.item(((ReduxBoatItem)((Object)this.boatItem.get())).m_5456_(), "misc/");
        data.item(((ReduxBoatItem)((Object)this.chestBoatItem.get())).m_5456_(), "misc/");
        data.itemLogWallBlock((Block)this.logWall.get(), (Block)this.log.get(), "natural/", "aether_redux");
        this.strippedLogWall.ifPresent(reg -> data.itemLogWallBlock((Block)reg.get(), (Block)this.strippedLog.get().get(), "natural/", "aether_redux"));
        data.itemWoodWallBlock((Block)this.woodWall.get(), (Block)this.log.get(), "natural/", "aether_redux");
        this.strippedWoodWall.ifPresent(reg -> data.itemWoodWallBlock((Block)reg.get(), (Block)this.strippedLog.get().get(), "natural/", "aether_redux"));
        this.sporingLog.ifPresent(data::itemBlock);
        this.sporingWood.ifPresent(data::itemBlock);
    }

    @Override
    public void generateLanguageData(ReduxLanguageData data) {
        boolean useAn = BlockHandler.isVowel(this.woodName.charAt(0));
        this.sporingLog.ifPresent(block -> {
            data.addBlock((Supplier)block, "Infected " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix));
            data.addLore((Supplier)block, "This variant of the " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + " has spores on it, which it drops when mined with a Zanite Axe or better.");
        });
        this.sporingWood.ifPresent(block -> {
            data.addBlock((Supplier)block, "Infected " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix));
            data.addLore((Supplier)block, "This variant of the " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix) + " has spores on it, which it drops when mined with a Zanite Axe or better.");
        });
        data.addItem((Supplier)this.boatItem, this.getLocalizedName() + " Boat");
        data.addLore((Supplier)this.boatItem, "Crafted from " + this.getLocalizedName() + " Planks. While the Aether does not have many large bodies of water, a boat can occasionally be a useful tool for crossing large distances over ice!");
        data.addItem((Supplier)this.chestBoatItem, this.getLocalizedName() + " Boat with Chest");
        data.addLore((Supplier)this.chestBoatItem, (String)(useAn ? "An " : "A " + this.getLocalizedName() + " Boat with a handy chest in the back. Helpful for transporting more items over long stretches of water, which are famously difficult to find in the Aether."));
        data.addBlock((Supplier)this.logWall, this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + " Wall");
        data.addLore((Supplier)this.logWall, "Crafted from " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + "s. Can be used for decorative enclosures and defences. Great for keeping nasty intruders away!");
        this.strippedLogWall.ifPresent(reg -> {
            data.addBlock((Supplier)reg, "Stripped " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + " Wall");
            data.addLore((Supplier)reg, "Crafted from Stripped " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + "s. Can be used for decorative enclosures and defences. Great for keeping nasty intruders away!");
        });
        data.addBlock((Supplier)this.woodWall, this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix) + " Wall");
        data.addLore((Supplier)this.woodWall, "Crafted from " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix) + ". Can be used for decorative enclosures and defences. Great for keeping nasty intruders away!");
        this.strippedWoodWall.ifPresent(reg -> {
            data.addBlock((Supplier)reg, "Stripped " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix) + " Wall");
            data.addLore((Supplier)reg, "Crafted from Stripped " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix) + ". Can be used for decorative enclosures and defences. Great for keeping nasty intruders away!");
        });
        data.addBlock((Supplier)this.log, this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix));
        data.addLore((Supplier)this.log, "These spawn with " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.treeName) + ". They can be double dropped with Skyroot Axes. When put in a crafting table they will provide 4 " + this.getLocalizedName() + " Planks.");
        this.strippedLog.ifPresent(reg -> {
            data.addBlock((Supplier)reg, "Stripped " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix));
            data.addLore((Supplier)reg, (String)(useAn ? "An " : "A " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + " that has had its bark stripped away with an Axe. When put in a crafting table they will provide 4 " + this.getLocalizedName() + " Planks."));
        });
        data.addBlock((Supplier)this.planks, this.getLocalizedName() + " Planks");
        data.addLore((Supplier)this.planks, "Planks from the " + this.getLocalizedName() + " tree. Can be used as a building material, along with several other useful things.");
        data.addBlock((Supplier)this.wood, this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix));
        data.addLore((Supplier)this.wood, "Six-sided variant of " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.logSuffix) + "s. When put in a crafting table they will provide 4 " + this.getLocalizedName() + " Planks.");
        this.strippedWood.ifPresent(reg -> {
            data.addBlock((Supplier)reg, "Stripped " + this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix));
            data.addLore((Supplier)reg, this.getLocalizedName() + " " + StringUtils.capitalise((String)this.woodSuffix) + " that has had its bark stripped away with an Axe. When put in a crafting table they will provide 4 " + this.getLocalizedName() + " Planks.");
        });
        data.addBlock((Supplier)this.stairs, this.getLocalizedName() + " Stairs");
        data.addLore((Supplier)this.stairs, "Crafted from " + this.getLocalizedName() + " Planks. Stairs are useful for adding verticality to builds and are often used for decoration too!");
        data.addBlock((Supplier)this.slab, this.getLocalizedName() + " Slab");
        data.addLore((Supplier)this.slab, "Crafted from " + this.getLocalizedName() + " Planks. Slabs are half blocks, versatile for decoration and smooth slopes. Try adding some to a building's roofing!");
        data.addBlock((Supplier)this.fence, this.getLocalizedName() + " Fence");
        data.addLore((Supplier)this.fence, "Crafted from " + this.getLocalizedName() + " Planks and Skyroot Sticks. Fences are great for keeping your livestock safe from wandering predators!");
        data.addBlock((Supplier)this.fenceGate, this.getLocalizedName() + " Fence Gate");
        data.addLore((Supplier)this.fenceGate, "Crafted from " + this.getLocalizedName() + " Planks and Skyroot Sticks. Fence gates give a homely entrance and exit to your precious enclosures.");
        data.addBlock((Supplier)this.door, this.getLocalizedName() + " Door");
        data.addLore((Supplier)this.door, "Crafted from " + this.getLocalizedName() + (this == WoodHandlers.CLOUDCAP ? " Planks. Some have said that these doors cause places to almost feel more spacious inside than out." : " Planks. Doors are an ornate entrance helpful for keeping an enclosed and safe space without worry of monsters wandering in!"));
        data.addBlock((Supplier)this.trapdoor, this.getLocalizedName() + " Trapdoor");
        data.addLore((Supplier)this.trapdoor, "Crafted from " + this.getLocalizedName() + " Planks. Trapdoors are useful for covering entryways one block wide. They are often used to add extra protection to staircases.");
        data.addBlock((Supplier)this.pressurePlate, this.getLocalizedName() + " Pressure Plate");
        data.addLore((Supplier)this.pressurePlate, "Crafted from " + this.getLocalizedName() + " Planks. A wooden pressure plate used to activate mechanisms and redstone.");
        data.addBlock((Supplier)this.button, this.getLocalizedName() + " Button");
        data.addLore((Supplier)this.button, "Crafted from " + this.getLocalizedName() + " Planks, a button used to activate mechanisms and redstone.");
        data.addBlock((Supplier)this.sign, this.getLocalizedName() + " Sign");
        data.addLore((Supplier)this.sign, "Crafted from " + this.getLocalizedName() + " Planks. A helpful sign perfect for writing messages and directions on.");
        data.addBlock((Supplier)this.hangingSign, this.getLocalizedName() + " Hanging Sign");
        data.addLore((Supplier)this.hangingSign, "Crafted from " + this.getLocalizedName() + " Planks. A helpful hanging sign perfect for writing messages and directions on.");
        data.addBlock((Supplier)this.bookshelf, this.getLocalizedName() + " Bookshelf");
        data.addLore((Supplier)this.bookshelf, "A nice bookshelf made of " + this.getLocalizedName() + " wood. These are nice for decoration, and also will enhance the abilities of Enchanting Tables!");
        data.addEntityType((Supplier)this.boatEntity, this.getLocalizedName() + " Boat");
        data.addEntityType((Supplier)this.chestBoatEntity, this.getLocalizedName() + " Boat with Chest");
    }

    private String getLocalizedName() {
        return StringUtils.capitalise((String)(this.langName == null ? this.woodName : this.langName));
    }

    private /* synthetic */ void lambda$generateBlockstateData$42(ReduxBlockstateData data, ModelFile postBig, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt, ModelFile sideShort, ModelFile sideAltShort, ModelFile sideTallShort, ModelFile sideTallAltShort, RegistryObject reg) {
        data.logWallBlock((WallBlock)reg.get(), (Block)this.strippedLog.get().get(), "natural/", reg.getId().m_135827_(), false, postBig, postShort, postTall, side, sideAlt, sideTall, sideTallAlt, sideShort, sideAltShort, sideTallShort, sideTallAltShort);
    }

    private /* synthetic */ void lambda$generateBlockstateData$41(ReduxBlockstateData data, ModelFile postBig, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt, ModelFile sideShort, ModelFile sideAltShort, ModelFile sideTallShort, ModelFile sideTallAltShort, RegistryObject reg) {
        data.logWallBlock((WallBlock)reg.get(), (Block)this.strippedLog.get().get(), "natural/", reg.getId().m_135827_(), true, postBig, postShort, postTall, side, sideAlt, sideTall, sideTallAlt, sideShort, sideAltShort, sideTallShort, sideTallAltShort);
    }
}

