/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Conditional<T> {
    private final T value;
    private final Supplier<Boolean> condition;

    private Conditional(T value, Supplier<Boolean> condition) {
        this.value = value;
        this.condition = condition;
    }

    public static <T> Conditional<T> never(T val) {
        return new Conditional<T>(val, () -> false);
    }

    public static <T> Conditional<T> always(T val) {
        return new Conditional<T>(val, () -> true);
    }

    public static <T> Conditional<T> of(T value, Supplier<Boolean> condition) {
        return new Conditional<T>(value, condition);
    }

    public T get() {
        return this.condition.get() != false ? (T)this.value : null;
    }

    public boolean isUnavailable() {
        return !this.isAvailable();
    }

    public boolean isAvailable() {
        return this.condition.get() != false && this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isPopulated() {
        return this.value != null;
    }

    public void ifAvailable(Consumer<? super T> action) {
        if (this.isAvailable()) {
            action.accept(this.value);
        }
    }

    public T getAnyway() {
        return this.value;
    }

    public void ifAvailableOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isAvailable()) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public T orElse(T other) {
        return this.isAvailable() ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isAvailable() ? this.value : supplier.get();
    }

    public T orElseThrow() {
        if (this.isUnavailable()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isAvailable()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

