/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.advancement.predicate;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeTypePredicate {
    public static final RecipeTypePredicate ANY = new RecipeTypePredicate(null);
    @Nullable
    private final Set<RecipeType> recipes;

    public RecipeTypePredicate(@Nullable Set<RecipeType> recipes) {
        this.recipes = recipes;
    }

    public static RecipeTypePredicate of(@Nullable Set<RecipeType> recipes) {
        return new RecipeTypePredicate(recipes);
    }

    public static RecipeTypePredicate of(RecipeType recipe) {
        return new RecipeTypePredicate((Set<RecipeType>)ImmutableSet.of((Object)recipe));
    }

    public boolean matches(RecipeType recipe) {
        return this.recipes == null || this.recipes.contains(recipe);
    }

    public JsonElement serializeToJson() {
        JsonObject jsonobject = new JsonObject();
        if (this.recipes != null && !this.recipes.isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            for (RecipeType recipe : this.recipes) {
                jsonarray.add(BuiltInRegistries.f_256990_.m_7981_((Object)recipe).toString());
            }
            jsonobject.add("recipes", (JsonElement)jsonarray);
        }
        return jsonobject;
    }

    public static RecipeTypePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || !json.isJsonObject()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)"RecipeTypePredicate");
        JsonArray array = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"recipes", null);
        if (array == null || array.isEmpty()) {
            return ANY;
        }
        ImmutableSet set = null;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonElement jsonelement : array) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13805_((JsonElement)jsonelement, (String)"recipe type"));
            builder.add((Object)((RecipeType)BuiltInRegistries.f_256990_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown recipe type '" + resourcelocation + "'"))));
        }
        set = builder.build();
        return new RecipeTypePredicate((Set<RecipeType>)set);
    }
}

