/*
 * Decompiled with CFR 0.152.
 */
package net.cyber_rat.extra_compat.core.event.forge;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MusselBlock;
import com.github.alexmodguy.alexscaves.server.item.MarineSnowItem;
import java.util.HashMap;
import java.util.Map;
import net.cyber_rat.extra_compat.core.event.forge.EventAdapter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class MarineSnowClickEventAdapter
implements EventAdapter<PlayerInteractEvent.RightClickBlock> {
    public static final Map<Block, Block> GROWTH_INTERACTIONS = new HashMap<Block, Block>();
    public static final Map<Block, ItemStack> DUPLICATES_INTERACTIONS = new HashMap<Block, ItemStack>();

    @Override
    public void adapt(PlayerInteractEvent.RightClickBlock event) {
        ItemStack handItemStack = event.getItemStack();
        Item itemInHand = handItemStack.m_41720_();
        if (itemInHand instanceof MarineSnowItem) {
            Level level = event.getLevel();
            BlockPos clickedBlockPos = event.getHitVec().m_82425_();
            if (MarineSnowClickEventAdapter.scanForWater(clickedBlockPos, (BlockGetter)level)) {
                boolean flag = false;
                BlockState clickedBlockState = level.m_8055_(clickedBlockPos);
                Block clickedBlock = clickedBlockState.m_60734_();
                if (GROWTH_INTERACTIONS.containsKey(clickedBlock)) {
                    flag = true;
                    BlockState transform = GROWTH_INTERACTIONS.getOrDefault(clickedBlock, Blocks.f_50016_).m_49966_();
                    for (Property property : clickedBlockState.m_61147_()) {
                        transform = transform.m_61138_(property) ? (BlockState)transform.m_61124_(property, clickedBlockState.m_61143_(property)) : transform;
                    }
                    level.m_46597_(clickedBlockPos, transform);
                } else if (DUPLICATES_INTERACTIONS.containsKey(clickedBlock)) {
                    flag = true;
                    if (level.m_213780_().m_188503_(2) == 0) {
                        ItemStack spawn = DUPLICATES_INTERACTIONS.getOrDefault(clickedBlock, ItemStack.f_41583_);
                        Vec3 spawnItemAt = event.getHitVec().m_82450_();
                        ItemEntity itemEntity = new ItemEntity(level, spawnItemAt.f_82479_, spawnItemAt.f_82480_, spawnItemAt.f_82481_, spawn);
                        level.m_7967_((Entity)itemEntity);
                    }
                } else if (clickedBlockState.m_60713_((Block)ACBlockRegistry.MUSSEL.get()) && (Integer)clickedBlockState.m_61143_((Property)MusselBlock.MUSSELS) < 5) {
                    flag = true;
                    level.m_46597_(clickedBlockPos, (BlockState)clickedBlockState.m_61124_((Property)MusselBlock.MUSSELS, (Comparable)Integer.valueOf((Integer)clickedBlockState.m_61143_((Property)MusselBlock.MUSSELS) + 1)));
                }
                if (flag) {
                    Player player = event.getEntity();
                    player.m_6674_(event.getHand());
                    if (!level.f_46443_) {
                        level.m_46796_(1505, clickedBlockPos, 0);
                    }
                    if (!player.m_7500_()) {
                        handItemStack.m_41774_(1);
                    }
                    event.setResult(event.getUseItem());
                }
            }
        }
    }

    private static boolean scanForWater(BlockPos blockPos, BlockGetter blockGetter) {
        if (blockGetter.m_8055_(blockPos).m_60819_().m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!blockGetter.m_6425_(blockPos.m_121945_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }
}

