/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.entity.goal;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class LeapAtTargetWolfGoal
extends Goal {
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 45, 50, 55, 58}));
    private final Mob mob;
    protected final float maxJumpVelocityMultiplier;
    private LivingEntity target;
    private int jumpCooldown;

    public LeapAtTargetWolfGoal(Mob p_25492_, float maxJumpVelocityMultiplier) {
        this.mob = p_25492_;
        this.maxJumpVelocityMultiplier = maxJumpVelocityMultiplier;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        double d0;
        if (this.mob.m_217005_()) {
            return false;
        }
        this.target = this.mob.m_5448_();
        if (this.target == null) {
            return false;
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if ((d0 = (double)this.mob.m_20270_((Entity)this.target)) < 0.5 || d0 > 3.0) {
            return false;
        }
        return this.mob.m_20096_() && this.jumpCooldown <= 0;
    }

    public boolean m_8045_() {
        return !this.mob.m_20096_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_147244_(false);
        this.jumpStop(this.mob);
    }

    public void m_8056_() {
        this.jumpCooldown = 20 + this.mob.m_217043_().m_188503_(20);
        BlockPos blockpos = LeapAtTargetWolfGoal.snapToSurface((LivingEntity)this.mob, this.target.m_20182_());
        if (blockpos != null) {
            BlockState blockstate = this.mob.m_9236_().m_8055_(blockpos.m_7495_());
            if (!this.mob.m_6095_().m_20630_(blockstate) && (LeapAtTargetWolfGoal.hasLineOfSight((LivingEntity)this.mob, blockpos.m_252807_()) || LeapAtTargetWolfGoal.hasLineOfSight((LivingEntity)this.mob, blockpos.m_6630_(4).m_252807_()))) {
                Vec3 vec32 = this.calculateOptimalJumpVector(this.mob, this.mob.m_217043_(), Vec3.m_82539_((Vec3i)blockpos)).orElse(null);
                if (vec32 == null) {
                    return;
                }
                this.mob.m_147244_(true);
                this.mob.m_20256_(vec32);
            }
        }
        this.jumpStart(this.mob);
    }

    public void jumpStart(Mob mob) {
        this.mob.m_216990_(SoundEvents.f_144167_);
    }

    public void jumpStop(Mob mob) {
    }

    public static boolean hasLineOfSight(LivingEntity p_316785_, Vec3 p_316249_) {
        Vec3 vec3 = new Vec3(p_316785_.m_20185_(), p_316785_.m_20186_(), p_316785_.m_20189_());
        return p_316249_.m_82554_(vec3) > 50.0 ? false : p_316785_.m_9236_().m_45547_(new ClipContext(vec3, p_316249_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_316785_)).m_6662_() == HitResult.Type.MISS;
    }

    @Nullable
    private static BlockPos snapToSurface(LivingEntity p_311909_, Vec3 p_312597_) {
        ClipContext clipcontext = new ClipContext(p_312597_, p_312597_.m_231075_(Direction.DOWN, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_311909_);
        BlockHitResult hitresult = p_311909_.m_9236_().m_45547_(clipcontext);
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            return BlockPos.m_274446_((Position)hitresult.m_82450_()).m_7494_();
        }
        ClipContext clipcontext1 = new ClipContext(p_312597_, p_312597_.m_231075_(Direction.UP, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_311909_);
        BlockHitResult hitresult1 = p_311909_.m_9236_().m_45547_(clipcontext1);
        return hitresult1.m_6662_() == HitResult.Type.BLOCK ? BlockPos.m_274446_((Position)hitresult1.m_82450_()).m_7494_() : null;
    }

    private Optional<Vec3> calculateOptimalJumpVector(Mob p_312651_, RandomSource p_312364_, Vec3 p_312758_) {
        Iterator iterator = Util.m_214611_(ALLOWED_ANGLES, (RandomSource)p_312364_).iterator();
        while (iterator.hasNext()) {
            float f = (float)((double)0.42f * (double)this.maxJumpVelocityMultiplier);
            int i = (Integer)iterator.next();
            Optional<Vec3> optional = LeapAtTargetWolfGoal.calculateJumpVectorForAngle(p_312651_, p_312758_, f, i, true);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<Vec3> calculateJumpVectorForAngle(Mob p_311799_, Vec3 p_312876_, float p_312407_, int p_311991_, boolean p_312784_) {
        Vec3 vec3 = p_311799_.m_20182_();
        Vec3 vec31 = new Vec3(p_312876_.f_82479_ - vec3.f_82479_, 0.0, p_312876_.f_82481_ - vec3.f_82481_).m_82541_().m_82490_(0.5);
        Vec3 vec32 = p_312876_.m_82546_(vec31);
        Vec3 vec33 = vec32.m_82546_(vec3);
        float f = (float)p_311991_ * (float)Math.PI / 180.0f;
        double d0 = Math.atan2(vec33.f_82481_, vec33.f_82479_);
        double d1 = vec33.m_82492_(0.0, vec33.f_82480_, 0.0).m_82556_();
        double d2 = Math.sqrt(d1);
        double d3 = vec33.f_82480_;
        double d4 = p_311799_.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        double d5 = Math.sin(2.0f * f);
        double d6 = Math.pow(Math.cos(f), 2.0);
        double d7 = Math.sin(f);
        double d8 = Math.cos(f);
        double d9 = Math.sin(d0);
        double d10 = Math.cos(d0);
        double d11 = d1 * d4 / (d2 * d5 - 2.0 * d3 * d6);
        if (d11 < 0.0) {
            return Optional.empty();
        }
        double d12 = Math.sqrt(d11);
        if (d12 > (double)p_312407_) {
            return Optional.empty();
        }
        double d13 = d12 * d8;
        double d14 = d12 * d7;
        if (p_312784_) {
            int i = Mth.m_14165_((double)(d2 / d13)) * 2;
            double d15 = 0.0;
            Vec3 vec34 = null;
            EntityDimensions entitydimensions = p_311799_.m_6972_(Pose.LONG_JUMPING);
            for (int j = 0; j < i - 1; ++j) {
                double d16 = d7 / d8 * (d15 += d2 / (double)i) - Math.pow(d15, 2.0) * d4 / (2.0 * d11 * Math.pow(d8, 2.0));
                double d17 = d15 * d10;
                double d18 = d15 * d9;
                Vec3 vec35 = new Vec3(vec3.f_82479_ + d17, vec3.f_82480_ + d16, vec3.f_82481_ + d18);
                if (vec34 != null && !LeapAtTargetWolfGoal.isClearTransition(p_311799_, entitydimensions, vec34, vec35)) {
                    return Optional.empty();
                }
                vec34 = vec35;
            }
        }
        return Optional.of(new Vec3(d13 * d10, d14, d13 * d9).m_82490_((double)0.95f));
    }

    private static boolean isClearTransition(Mob p_312910_, EntityDimensions p_312734_, Vec3 p_311995_, Vec3 p_312896_) {
        Vec3 vec3 = p_312896_.m_82546_(p_311995_);
        double d0 = Math.min(p_312734_.f_20377_, p_312734_.f_20378_);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / d0));
        Vec3 vec31 = vec3.m_82541_();
        Vec3 vec32 = p_311995_;
        for (int j = 0; j < i; ++j) {
            Vec3 vec33 = vec32 = j == i - 1 ? p_312896_ : vec32.m_82549_(vec31.m_82490_(d0 * (double)0.9f));
            if (p_312910_.m_9236_().m_45756_((Entity)p_312910_, p_312734_.m_20393_(vec32))) continue;
            return false;
        }
        return true;
    }
}

