/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class TrophyBlock
extends Block
implements SimpleWaterloggedBlock {
    public static IntegerProperty ROTTING = IntegerProperty.m_61631_((String)"rotting", (int)0, (int)2);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape NORTH_AABB;

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTTING, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext hit) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            default -> EAST_AABB;
        };
    }

    public int getMaxRottingStage() {
        return 2;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int maxRotting;
        if (worldIn.f_46443_ || state.m_60734_() != MNDBlocks.HOGLIN_TROPHY.get()) {
            return;
        }
        if (worldIn.m_204166_(pos).m_203656_(BiomeTags.f_207612_) || worldIn.m_6042_().f_63857_()) {
            return;
        }
        int currentRotting = (Integer)state.m_61143_((Property)ROTTING);
        if (currentRotting >= (maxRotting = this.getMaxRottingStage())) {
            return;
        }
        int nextRotting = Math.min(currentRotting + 1, maxRotting);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ROTTING, (Comparable)Integer.valueOf(nextRotting)), 3);
        if (nextRotting == maxRotting) {
            this.convertToZoglin(worldIn, pos, random);
        } else if (nextRotting == maxRotting - 1) {
            worldIn.m_5594_(null, pos, SoundEvents.f_11961_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void convertToZoglin(ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockState currentState = worldIn.m_8055_(pos);
        worldIn.m_5594_(null, pos, SoundEvents.f_11959_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Direction facing = (Direction)currentState.m_61143_((Property)FACING);
        worldIn.m_7731_(pos, (BlockState)MNDBlocks.ZOGLIN_TROPHY.get().m_49966_().m_61124_((Property)FACING, (Comparable)facing), 3);
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() + random.m_188500_();
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123811_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block = state.m_60734_();
        ItemStack heldItem = player.m_21120_(hand);
        SimpleParticleType secondParticle = null;
        SoundEvent secondSoundEvent = null;
        boolean useSecondEffects = false;
        if (block == MNDBlocks.HOGLIN_TROPHY.get() && heldItem.m_204117_(MNDTags.HOGLIN_WAXED)) {
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.WAXED_HOGLIN_TROPHY.get(), SoundEvents.f_144178_, (ParticleOptions)ParticleTypes.f_175828_, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return InteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.WAXED_HOGLIN_TROPHY.get() && heldItem.m_204117_(ForgeTags.TOOLS_AXES)) {
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.HOGLIN_TROPHY.get(), SoundEvents.f_144178_, (ParticleOptions)ParticleTypes.f_175829_, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return InteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.ZOGLIN_TROPHY.get() && heldItem.m_204117_(MNDTags.HOGLIN_CURE)) {
            secondParticle = ParticleTypes.f_123809_;
            secondSoundEvent = SoundEvents.f_11887_;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.HOGLIN_TROPHY.get(), SoundEvents.f_12644_, (ParticleOptions)ParticleTypes.f_123796_, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return InteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.HOGLIN_TROPHY.get() && heldItem.m_204117_(ForgeTags.TOOLS_KNIVES)) {
            secondParticle = ParticleTypes.f_123796_;
            secondSoundEvent = SoundEvents.f_11961_;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.SKOGLIN_TROPHY.get(), (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), (ParticleOptions)ParticleTypes.f_123798_, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            int j = 1 + level.f_46441_.m_188503_(2);
            TrophyBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42454_, j));
            return InteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.ZOGLIN_TROPHY.get() && heldItem.m_204117_(ForgeTags.TOOLS_KNIVES)) {
            secondParticle = ParticleTypes.f_123796_;
            secondSoundEvent = SoundEvents.f_12596_;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.SKOGLIN_TROPHY.get(), (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), (ParticleOptions)ParticleTypes.f_123798_, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            int j = 1 + level.f_46441_.m_188503_(2);
            TrophyBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42583_, j));
            return InteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.SKOGLIN_TROPHY.get() && heldItem.m_204117_(MNDTags.HOGLIN_HIDE)) {
            secondParticle = ParticleTypes.f_123796_;
            secondSoundEvent = SoundEvents.f_11956_;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.HOGLIN_TROPHY.get(), SoundEvents.f_11678_, (ParticleOptions)ParticleTypes.f_123748_, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void processTrophyInteraction(Level level, BlockPos pos, Player player, InteractionHand hand, Block trophyBlock, SoundEvent soundEvent, ParticleOptions particle, ParticleOptions secondParticle, SoundEvent secondSoundEvent, boolean useSecondEffects) {
        if (level.m_5776_()) {
            return;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_204117_(ForgeTags.TOOLS)) {
            heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        } else if (!player.m_150110_().f_35937_) {
            heldItem.m_41774_(1);
        }
        level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 0.8f, 0.8f);
        level.m_46597_(pos, (BlockState)trophyBlock.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FACING))));
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 6; ++i) {
                double d0 = (double)pos.m_123341_() + level.m_213780_().m_188500_();
                double d1 = (double)pos.m_123342_() + level.m_213780_().m_188500_();
                double d2 = (double)pos.m_123343_() + level.m_213780_().m_188500_();
                serverLevel.m_8767_(particle, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                if (!useSecondEffects) continue;
                serverLevel.m_8767_(secondParticle, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                level.m_5594_(null, pos, secondSoundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private boolean canAttachTo(BlockGetter level, BlockPos pos, Direction facing) {
        return level.m_8055_(pos).m_60783_(level, pos, facing);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.m_121945_(direction.m_122424_()), direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = this.m_49966_();
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (!level.m_6042_().f_63857_() && state.m_60734_() == MNDBlocks.HOGLIN_TROPHY.get()) {
            int i = 0;
            while ((double)i < 0.5) {
                double offsetX = random.m_188583_() * 0.2;
                double offsetY = random.m_188583_() * 0.2;
                double offsetZ = random.m_188583_() * 0.2;
                double x = (double)pos.m_123341_() + random.m_188500_();
                double y = (double)pos.m_123342_() + random.m_188500_();
                double z = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123808_, x, y, z, offsetX, offsetY, offsetZ);
                ++i;
            }
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation facing) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror facing) {
        return state.m_60717_(facing.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, ROTTING});
        super.m_7926_(builder);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    static {
        NORTH_AABB = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)4.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)2.0, (double)8.0, (double)9.0, (double)14.0, (double)12.0, (double)13.0), Block.m_49796_((double)2.0, (double)6.0, (double)7.0, (double)14.0, (double)10.0, (double)11.0), Block.m_49796_((double)2.0, (double)4.0, (double)5.0, (double)14.0, (double)8.0, (double)9.0), Block.m_49796_((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)6.0, (double)7.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        EAST_AABB = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0), Block.m_49796_((double)3.0, (double)8.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0), Block.m_49796_((double)5.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0, (double)14.0), Block.m_49796_((double)7.0, (double)4.0, (double)2.0, (double)11.0, (double)8.0, (double)14.0), Block.m_49796_((double)9.0, (double)2.0, (double)2.0, (double)13.0, (double)6.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        SOUTH_AABB = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)1.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)2.0, (double)8.0, (double)3.0, (double)14.0, (double)12.0, (double)7.0), Block.m_49796_((double)2.0, (double)6.0, (double)5.0, (double)14.0, (double)10.0, (double)9.0), Block.m_49796_((double)2.0, (double)4.0, (double)7.0, (double)14.0, (double)8.0, (double)11.0), Block.m_49796_((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)6.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        WEST_AABB = Stream.of(Block.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)15.0), Block.m_49796_((double)15.0, (double)3.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)13.0, (double)4.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)9.0, (double)8.0, (double)2.0, (double)13.0, (double)12.0, (double)14.0), Block.m_49796_((double)7.0, (double)6.0, (double)2.0, (double)11.0, (double)10.0, (double)14.0), Block.m_49796_((double)5.0, (double)4.0, (double)2.0, (double)9.0, (double)8.0, (double)14.0), Block.m_49796_((double)3.0, (double)2.0, (double)2.0, (double)7.0, (double)6.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }
}

