/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;

public class Sparkle
extends Animal {
    private static final EntityDataAccessor<Integer> CRYSTAL_TYPE = SynchedEntityData.m_135353_(Sparkle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Sparkle>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)((SensorType)GSensorTypes.SPARKLE_TEMPTATIONS.get()), (Object)((SensorType)GSensorTypes.NEAREST_POLLINATED_CLUSTER.get()), (Object)SensorType.f_217824_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_148197_, (Object)((MemoryModuleType)GMemoryModuleTypes.POLLINATED_COOLDOWN.get()), (Object)MemoryModuleType.f_148198_, (Object)MemoryModuleType.f_26381_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26382_, MemoryModuleType.f_148194_, MemoryModuleType.f_217766_, MemoryModuleType.f_217768_});
    private static final UniformInt REGROWTH_TICKS = UniformInt.m_146622_((int)6000, (int)12000);
    private final Map<Block, Block> clustersToGlinted = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put((Block)GBlocks.ALLURITE_CLUSTER.get(), (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        map.put((Block)GBlocks.LUMIERE_CLUSTER.get(), (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
        map.put(Blocks.f_152492_, (Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get());
    });
    private int growthTicks;

    public Sparkle(EntityType<? extends Sparkle> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 4.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
    }

    public Map<Block, Block> getClustersToGlinted() {
        return this.clustersToGlinted;
    }

    public float m_5610_(BlockPos p_27573_, LevelReader p_27574_) {
        return 0.0f;
    }

    protected Brain.Provider<Sparkle> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return SparkleAi.makeBrain((Brain<Sparkle>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Sparkle> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("sparkleBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("sparkleActivityUpdate");
        SparkleAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public void m_7023_(Vec3 deltaMovement) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), deltaMovement);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(deltaMovement);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRYSTAL_TYPE, (Object)0);
    }

    public static boolean checkSparkleSpawnRules(EntityType<? extends LivingEntity> sparkle, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(GBlockTags.SPARKLES_SPAWNABLE_ON);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        CrystalType type = this.getRandomType();
        this.setCrystalType(type);
        return super.m_6518_(world, difficulty, spawnReason, data, tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCrystalType(CrystalType.BY_ID[tag.m_128451_("CrystalType")]);
        this.setGrowthTicks(tag.m_128451_("GrowthTicks"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CrystalType", this.getCrystaltype().getId());
        tag.m_128405_("GrowthTicks", this.getGrowthTicks());
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public void setCrystalType(CrystalType type) {
        this.f_19804_.m_135381_(CRYSTAL_TYPE, (Object)type.getId());
    }

    public CrystalType getCrystaltype() {
        return CrystalType.BY_ID[(Integer)this.f_19804_.m_135370_(CRYSTAL_TYPE)];
    }

    protected PathNavigation m_6037_(Level world) {
        return new SparklePathNavigation(this, world);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(GItemTags.SPARKLE_TEMPT_ITEMS);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mob) {
        Sparkle sparkleEntity = (Sparkle)((EntityType)GEntityTypes.SPARKLE.get()).m_20615_((Level)world);
        if (sparkleEntity != null) {
            sparkleEntity.setCrystalType(CrystalType.NONE);
        }
        return sparkleEntity;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if (this.getGrowthTicks() > 0) {
                this.setGrowthTicks(this.getGrowthTicks() - 1);
            }
            if (this.getGrowthTicks() == 0 && this.getCrystaltype() == CrystalType.NONE) {
                CrystalType type = this.getRandomType();
                this.setCrystalType(type);
            }
        }
    }

    public CrystalType getRandomType() {
        return this.f_19796_.m_188499_() ? CrystalType.ALLURITE : CrystalType.LUMIERE;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getCrystaltype() != CrystalType.NONE && stack.m_41720_() instanceof PickaxeItem && !this.m_6162_()) {
            this.extractShard(stack);
            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (this.getCrystaltype() == CrystalType.NONE && stack.m_204117_(GItemTags.SPARKLE_TEMPT_ITEMS)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setGrowthTicks(this.getGrowthTicks() - Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40));
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void extractShard(ItemStack stack) {
        this.spawnShard(stack);
        this.m_5496_(SoundEvents.f_144094_, 1.0f, 1.0f);
        this.setCrystalType(CrystalType.NONE);
        this.setGrowthTicks(REGROWTH_TICKS.m_214085_(this.m_217043_()));
    }

    private void spawnShard(ItemStack stack) {
        Item item = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0 ? this.getCrystaltype().getSilktouchItem() : this.getCrystaltype().getItem();
        int rolls = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)stack) > 0 ? 1 + EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)stack) : 1;
        for (int i = 0; i < rolls; ++i) {
            this.m_19998_((ItemLike)item);
        }
    }

    public static enum CrystalType {
        NONE(0, "none", null, null),
        ALLURITE(1, "allurite", (Item)GItems.ALLURITE_SHARD.get(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).m_5456_()),
        LUMIERE(2, "lumiere", (Item)GItems.LUMIERE_SHARD.get(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).m_5456_());

        public static final CrystalType[] BY_ID;
        private final int id;
        private final String name;
        private final Item item;
        private final Item silktouchItem;

        private CrystalType(int id, String name, Item item, Item silktouchItem) {
            this.id = id;
            this.name = name;
            this.item = item;
            this.silktouchItem = silktouchItem;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Item getItem() {
            return this.item;
        }

        public Item getSilktouchItem() {
            return this.silktouchItem;
        }

        static {
            BY_ID = (CrystalType[])Arrays.stream(CrystalType.values()).sorted(Comparator.comparingInt(CrystalType::getId)).toArray(CrystalType[]::new);
        }
    }

    static class SparklePathNavigation
    extends AmphibiousPathNavigation {
        SparklePathNavigation(Sparkle sparkle, Level world) {
            super((Mob)sparkle, world);
        }

        public boolean m_264193_(BlockPathTypes blockPathTypes) {
            return blockPathTypes != BlockPathTypes.WATER_BORDER && super.m_264193_(blockPathTypes);
        }
    }
}

