/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.function.Predicate;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.orcinus.galosphere.init.GBiomes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEnchantments;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.items.SilverSmithingTemplateItem;

public class GLanguageProvider
extends LanguageProvider {
    public GLanguageProvider(PackOutput output) {
        super(output, "galosphere", "en_us");
    }

    protected void addTranslations() {
        GBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> this.add((Block)block, this.reformat(ForgeRegistries.BLOCKS.getKey(block).m_135815_())));
        GItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(Predicate.not(BlockItem.class::isInstance).or(ItemNameBlockItem.class::isInstance)).filter(Predicate.not(SilverSmithingTemplateItem.class::isInstance).and(Predicate.not(((Item)GItems.PRESERVED_TEMPLATE.get())::equals))).forEach(item -> {
            if (item != GItems.PRESERVED_TEMPLATE.get() || item != GItems.SILVER_UPGRADE_SMITHING_TEMPLATE.get()) {
                this.add((Item)item, this.reformat(ForgeRegistries.ITEMS.getKey(item).m_135815_()));
            }
        });
        GEntityTypes.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get).forEach(entityType -> this.add((EntityType)entityType, this.reformat(ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_())));
        GMobEffects.MOB_EFFECTS.getEntries().stream().map(RegistryObject::get).forEach(mobEffect -> this.add((MobEffect)mobEffect, this.reformat(ForgeRegistries.MOB_EFFECTS.getKey(mobEffect).m_135815_())));
        GEnchantments.ENCHANTMENTS.getEntries().stream().map(RegistryObject::get).forEach(enchantment -> this.add((Enchantment)enchantment, this.reformat(ForgeRegistries.ENCHANTMENTS.getKey(enchantment).m_135815_())));
        this.add("item.galosphere.preserved", "Preserved");
        this.add("item.galosphere.silver_bomb.duration", "Duration");
        this.add("item.galosphere.silver_bomb.explosion", "Explosion");
        this.add("item.galosphere.silver_bomb.bouncy", "Bouncy");
        this.add("subtitles.block.monstrometer.activate", "Monstrometer activates");
        this.add("subtitles.block.monstrometer.charge", "Monstrometer is charged");
        this.add("subtitles.block.monstrometer.deactivate", "Monstrometer deactivates");
        this.add("subtitles.block.pink_salt_chamber.summon", "Pink Salt Chamber summons");
        this.add("subtitles.block.pink_salt_chamber.deactivate", "Pink Salt Chamber deactivates");
        this.add("subtitles.block.lumiere.compost", "Composter filled with Lumiere Shard");
        this.add("subtitles.entity.specterpillar.death", "Specterpillar dies");
        this.add("subtitles.entity.specterpillar.hurt", "Specterpillar hurts");
        this.add("subtitles.entity.spectre.ambient", "Spectre chirps");
        this.add("subtitles.entity.spectre.death", "Spectre dies");
        this.add("subtitles.entity.spectre.hurt", "Spectre hurts");
        this.add("subtitles.entity.spectre.lock_to_spyglass", "Spyglass locks to Spectre");
        this.add("subtitles.entity.spectre.receive_item", "Spectre receives Item");
        this.add("subtitles.entity.berserker.shake", "Berserker shakes");
        this.add("subtitles.entity.berserker.roar", "Berserker roars");
        this.add("subtitles.entity.berserker.idle", "Berserker grunts");
        this.add("subtitles.entity.berserker.smash", "Berserker smashes");
        this.add("subtitles.entity.berserker.step", "Berserker steps");
        this.add("subtitles.entity.berserker.hurt", "Berserker hurts");
        this.add("subtitles.entity.berserker.death", "Berserker dies");
        this.add("subtitles.entity.berserker.summoning", "Berserker summons");
        this.add("subtitles.entity.berserker.punch", "Berserker hits");
        this.add("subtitles.entity.preserved.death", "Preserved dies");
        this.add("subtitles.entity.preserved.idle", "Preserved groans");
        this.add("subtitles.entity.preserved.hurt", "Preserved hurts");
        this.add("subtitles.entity.preserved.emerge", "Preserved emerges");
        this.add("subtitles.entity.pink_salt_pillar.emerge", "Pink Salt Pillar pierces");
        this.add("subtitles.entity.pink_salt_shard.land", "Pink Salt Shard lands");
        this.add("subtitles.item.saltbound_tablet.prepare_attack", "Saltbound Tablet charges up");
        this.add("subtitles.item.saltbound_tablet.cast_attack", "Saltbound Tablet fires");
        this.add("subtitles.item.saltbound_tablet.cooldown_over", "Saltbound Tablet recharged");
        GBiomes.getIds().forEach(resourceLocation -> this.add("biome.galosphere." + resourceLocation.m_135815_(), this.reformat(resourceLocation.m_135815_())));
        this.add("galosphere.midnightconfig.title", "Galosphere Config");
        this.add("galosphere.midnightconfig.slowBuddingAmethystDestroySpeed", "Slowed Budding Amethyst Destroy Speed");
        this.add("galosphere.midnightconfig.pillagerDropSilverIngot", "Pillager Drop Silver Ingots");
        this.add("galosphere.midnightconfig.spectreFlareAncientCityLoot", "Spectre Flares spawn in Ancient City chest loot");
        this.add("advancements.galosphere.crystal_lamps.description", "Have all Crystal Lamps in your inventory");
        this.add("advancements.galosphere.crystal_lamps.title", "Balanced, As All Things Should Be");
        this.add("advancements.galosphere.light_spread.description", "Deploy a Glow Flare");
        this.add("advancements.galosphere.light_spread.title", "Spread the Light!");
        this.add("advancements.galosphere.lumiere_compost.description", "Create Glowstone Dust by Composting with a Lumiere Shard");
        this.add("advancements.galosphere.lumiere_compost.title", "Fragility of Light");
        this.add("advancements.galosphere.silver_bomb.description", "Construct a Silver Bomb");
        this.add("advancements.galosphere.silver_bomb.title", "It's About Drive, It's About Power");
        this.add("advancements.galosphere.silver_ingot.description", "Obtain a Silver Ingot");
        this.add("advancements.galosphere.silver_ingot.title", "Multi-Disciplined");
        this.add("advancements.galosphere.sterling_armor.description", "Don a full suit of Sterling Armor");
        this.add("advancements.galosphere.sterling_armor.title", "Looking Good, Partner!");
        this.add("advancements.galosphere.use_spectre_spyglass.description", "Spectate a Spectre");
        this.add("advancements.galosphere.use_spectre_spyglass.title", "Watchdog");
        this.add("advancements.galosphere.use_spectre_flare.description", "Use a Spectre Flare");
        this.add("advancements.galosphere.use_spectre_flare.title", "I spy with my little eye");
        this.add("advancements.galosphere.warped_teleport.description", "Teleport to a Warped Anchor");
        this.add("advancements.galosphere.warped_teleport.title", "What is this Place?");
        this.add("advancements.galosphere.activate_pink_salt_chamber.title", "Knock Knock");
        this.add("advancements.galosphere.activate_pink_salt_chamber.description", "Activate a Pink Salt Chamber");
        this.add("advancements.galosphere.find_pink_salt_shrine.title", "Peaceful Revolution");
        this.add("advancements.galosphere.find_pink_salt_shrine.description", "Enter a Pink Salt Shrine");
        this.add("advancements.galosphere.summon_berserker.title", "Reign of Terror");
        this.add("advancements.galosphere.summon_berserker.description", "Summon the Berserker");
        this.add("attribute.name.generic.illager_resistance", "Illager Resistance");
        this.add("item.minecraft.potion.effect.astral", "Potion of Astral");
        this.add("item.minecraft.splash_potion.effect.astral", "Splash Potion of Astral");
        this.add("item.minecraft.lingering_potion.effect.astral", "Lingering Potion of Astral");
        this.add("item.minecraft.lingering_potion.tipped_arrow.astral", "Arrow of Astral");
        this.add("itemGroup.galosphere.galosphere", "Galosphere");
        this.add("upgrade.galosphere.silver_upgrade", "Silver Upgrade");
        this.add("item.galosphere.smithing_template.silver_upgrade.applies_to", "Leather Equipment");
        this.add("item.galosphere.smithing_template.silver_upgrade.ingredients", "Silver Ingot");
        this.add("item.galosphere.smithing_template.silver_upgrade.base_slot_description", "Add Leather Armor");
        this.add("item.galosphere.smithing_template.silver_upgrade.additions_slot_description", "Add Silver Ingot");
        this.add("upgrade.galosphere.preserved_upgrade", "Preserved Upgrade");
        this.add("item.galosphere.smithing_template.preserved_upgrade.applies_to", "All items");
        this.add("item.galosphere.smithing_template.preserved_upgrade.ingredients", "Pink Salt Shard");
        this.add("item.galosphere.smithing_template.preserved_upgrade.base_slot_description", "Add an item");
        this.add("item.galosphere.smithing_template.preserved_upgrade.additions_slot_description", "Add Pink Salt Shard");
        this.add("container.galosphere.combustion_table", "Combustion Table");
    }

    private String reformat(String id) {
        char[] buffer = id.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            boolean flag1;
            boolean bl = flag1 = i > 0 && String.valueOf(buffer[i - 1]).equals("_");
            if (i != 0 && !flag1) continue;
            buffer[i] = Character.toUpperCase(buffer[i]);
            if (!flag1) continue;
            buffer[i - 1] = 32;
        }
        return new String(buffer);
    }
}

