/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.blocks.MonstrometerBlock;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IndicatorParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private static final Vector3f SAFE_COLOR = Vec3.m_82501_((int)16757273).m_252839_();
    private static final Vector3f UNSAFE_COLOR = Vec3.m_82501_((int)9681407).m_252839_();

    public IndicatorParticle(ClientLevel world, double x, double y, double z, double pQuadSizeMulitiplier, SpriteSet sprites) {
        super(world, x, y, z);
        this.f_107230_ = 1.0f;
        this.f_107663_ = 0.0f;
        this.f_107225_ = 48;
        this.f_107227_ = this.getColor().x();
        this.f_107228_ = this.getColor().y();
        this.f_107229_ = this.getColor().z();
        this.sprites = sprites;
        this.m_108339_(this.sprites);
    }

    private Vector3f getColor() {
        return MonstrometerBlock.isUnsafe((Level)this.f_107208_, BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)) ? UNSAFE_COLOR : SAFE_COLOR;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107663_ = Mth.m_14179_((float)0.06f, (float)this.f_107663_, (float)0.5f);
        this.f_107227_ = Mth.m_14179_((float)0.25f, (float)this.f_107227_, (float)this.getColor().x());
        this.f_107228_ = Mth.m_14179_((float)0.25f, (float)this.f_107228_, (float)this.getColor().y());
        this.f_107229_ = Mth.m_14179_((float)0.25f, (float)this.f_107229_, (float)this.getColor().z());
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else if (this.f_107224_ > this.f_107225_ / 2) {
            this.f_107230_ -= 0.04f;
        }
        this.m_108339_(this.sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float delta) {
        this.renderParticle(consumer, camera, delta, Axis.f_252529_.m_252961_(1.5707964f));
        this.renderParticle(consumer, camera, delta, Axis.f_252495_.m_252961_(1.5707964f));
    }

    private void renderParticle(VertexConsumer consumer, Camera camera, float delta, Quaternionf quaternion) {
        Vec3 vec3 = camera.m_90583_();
        Vec3 vec32 = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (vec3.m_82554_(vec32) >= (double)MonstrometerBlock.getParticleViewRange()) {
            return;
        }
        Vector3f[] veca = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vec = veca[i];
            quaternion.transform(vec);
            vec.mul(this.m_5902_(delta));
            float f = (float)(Mth.m_14139_((double)delta, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
            float f1 = (float)(Mth.m_14139_((double)delta, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
            float f2 = (float)(Mth.m_14139_((double)delta, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
            vec.add(f, f1, f2);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int j = this.m_6355_(delta);
        consumer.m_5483_((double)veca[0].x(), (double)veca[0].y(), (double)veca[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)veca[1].x(), (double)veca[1].y(), (double)veca[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)veca[2].x(), (double)veca[2].y(), (double)veca[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)veca[3].x(), (double)veca[3].y(), (double)veca[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    protected int m_6355_(float tint) {
        return Math.max(50, super.m_6355_(tint));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double speed, double pYSpeed, double pZSpeed) {
            return new IndicatorParticle(pLevel, pX, pY, pZ, speed, this.sprites);
        }
    }
}

