/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class PotionBowAttackGoal<T extends Monster>
extends Goal {
    private final Mob mob;
    private final RangedAttackMob owner;
    private final double mobSpeed;
    private final int minIntervalTicks;
    private final int maxIntervalTicks;
    private final float maxShootRange;
    private final float squaredMaxShootRange;
    private final T actor;
    private final double speed;
    private final float squaredRange;
    @Nullable
    private LivingEntity target;
    private int updateCountdownTicks = -1;
    private int seenTargetTicks;
    private int attackInterval;
    private int cooldown = -1;
    private int targetSeeingTicker;
    private boolean movingToLeft;
    private boolean backward;
    private int combatTicks = -1;

    public PotionBowAttackGoal(T actor, double speed, int attackInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.owner = (RangedAttackMob)actor;
        this.mob = actor;
        this.mobSpeed = speed;
        this.minIntervalTicks = attackInterval;
        this.maxIntervalTicks = attackInterval;
        this.maxShootRange = range;
        this.squaredMaxShootRange = this.maxShootRange * this.maxShootRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackInterval(int attackInterval) {
        this.attackInterval = attackInterval;
    }

    public boolean m_8036_() {
        return this.actor.m_5448_() != null && this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.actor.m_21055_(Items.f_42411_) || this.actor.m_21055_(Items.f_42739_);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.actor.m_21573_().m_26571_()) && this.isHoldingBow();
    }

    public void m_8056_() {
        super.m_8056_();
        this.actor.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.actor.m_21561_(false);
        this.targetSeeingTicker = 0;
        this.cooldown = -1;
        this.actor.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean bl;
        double d;
        LivingEntity livingEntity = this.actor.m_5448_();
        if (livingEntity == null) {
            return;
        }
        if (this.actor.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42739_)) {
            int updateCountdownTicks;
            d = this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            bl = this.mob.m_21574_().m_148306_((Entity)livingEntity);
            int n = this.seenTargetTicks = bl ? (this.seenTargetTicks = this.seenTargetTicks + 1) : 0;
            if (d > (double)this.squaredMaxShootRange || this.seenTargetTicks < 5) {
                this.mob.m_21573_().m_5624_((Entity)livingEntity, this.mobSpeed);
            } else {
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            this.updateCountdownTicks = updateCountdownTicks = this.updateCountdownTicks - 1;
            if (updateCountdownTicks == 0) {
                if (!bl) {
                    return;
                }
                float f = (float)Math.sqrt(d) / this.maxShootRange;
                float g = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.owner.m_6504_(livingEntity, g);
                this.updateCountdownTicks = Mth.m_14143_((float)(f * (float)(this.maxIntervalTicks - this.minIntervalTicks) + (float)this.minIntervalTicks));
            } else if (this.updateCountdownTicks < 0) {
                this.updateCountdownTicks = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d) / (double)this.maxShootRange), (double)this.minIntervalTicks, (double)this.maxIntervalTicks));
            }
        }
        if (this.actor.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42411_)) {
            boolean bl2;
            d = this.actor.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            bl = this.actor.m_21574_().m_148306_((Entity)livingEntity);
            boolean bl3 = bl2 = this.targetSeeingTicker > 0;
            if (bl != bl2) {
                this.targetSeeingTicker = 0;
            }
            this.targetSeeingTicker = bl ? ++this.targetSeeingTicker : --this.targetSeeingTicker;
            if (d > (double)this.squaredRange || this.targetSeeingTicker < 20) {
                this.actor.m_21573_().m_5624_((Entity)livingEntity, this.speed);
                this.combatTicks = -1;
            } else {
                this.actor.m_21573_().m_26573_();
                ++this.combatTicks;
            }
            if (this.combatTicks >= 20) {
                if ((double)this.actor.m_217043_().m_188501_() < 0.3) {
                    this.movingToLeft = false;
                }
                if ((double)this.actor.m_217043_().m_188501_() < 0.3) {
                    this.backward = !this.backward;
                }
                this.combatTicks = 0;
            }
            if (this.combatTicks > -1) {
                if (d > (double)(this.squaredRange * 0.75f)) {
                    this.backward = false;
                } else if (d < (double)(this.squaredRange * 0.25f)) {
                    this.backward = true;
                }
                this.actor.m_21566_().m_24988_(this.backward ? -0.5f : 0.5f, this.movingToLeft ? 0.5f : -0.5f);
                this.actor.m_21391_((Entity)livingEntity, 30.0f, 30.0f);
            } else {
                this.actor.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            }
            if (this.actor.m_6117_()) {
                int i;
                if (!bl && this.targetSeeingTicker < -60) {
                    this.actor.m_5810_();
                } else if (bl && (i = this.actor.m_21252_()) >= 20) {
                    this.actor.m_5810_();
                    ((RangedAttackMob)this.actor).m_6504_(livingEntity, BowItem.m_40661_((int)i));
                    this.cooldown = this.attackInterval;
                }
            } else {
                int cooldown;
                this.cooldown = cooldown = this.cooldown - 1;
                if (cooldown <= 0 && this.targetSeeingTicker >= -60 && this.actor.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42411_)) {
                    this.actor.m_6672_(ProjectileUtil.m_37297_(this.actor, (Item)Items.f_42411_));
                }
            }
        }
    }
}

