/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion;

import fuzs.illagerinvasion.config.RaidWavesConfigHelper;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.core.CommonAbstractions;
import fuzs.illagerinvasion.handler.PlatinumTrimHandler;
import fuzs.illagerinvasion.handler.VillagerGoalHandler;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.init.v2.PotionBrewingRegistry;
import fuzs.puzzleslib.api.init.v2.RegistryReference;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IllagerInvasion
implements ModConstructor {
    public static final String MOD_ID = "illagerinvasion";
    public static final String MOD_NAME = "Illager Invasion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Illager Invasion");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"illagerinvasion").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        IllagerInvasion.registerHandlers();
    }

    private static void registerHandlers() {
        PlayerEvents.BREAK_SPEED.register(PlatinumTrimHandler::onBreakSpeed);
        LivingExperienceDropCallback.EVENT.register(PlatinumTrimHandler::onLivingExperienceDrop);
        BlockEvents.FARMLAND_TRAMPLE.register(PlatinumTrimHandler::onFarmlandTrample);
        ServerEntityLevelEvents.LOAD.register(VillagerGoalHandler::onEntityJoinServerLevel);
        LootTableLoadEvents.MODIFY.register((lootManager, identifier, addPool, removePool) -> {
            IllagerInvasion.injectLootPool(identifier, addPool, EntityType.f_20459_.m_20677_(), ModRegistry.ILLUSIONER_INJECT_LOOT_TABLE);
            IllagerInvasion.injectLootPool(identifier, addPool, EntityType.f_20513_.m_20677_(), ModRegistry.PILLAGER_INJECT_LOOT_TABLE);
            IllagerInvasion.injectLootPool(identifier, addPool, EntityType.f_20518_.m_20677_(), ModRegistry.RAVAGER_INJECT_LOOT_TABLE);
        });
    }

    private static void injectLootPool(ResourceLocation identifier, Consumer<LootPool> addPool, ResourceLocation builtInLootTable, ResourceLocation injectedLootTable) {
        if (identifier.equals((Object)builtInLootTable)) {
            addPool.accept(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)injectedLootTable)).m_79082_());
        }
    }

    public void onCommonSetup() {
        IllagerInvasion.registerRaiderTypes();
        IllagerInvasion.registerPotionRecipes();
        VillagerGoalHandler.init();
    }

    private static void registerRaiderTypes() {
        IllagerInvasion.registerRaiderType(ModRegistry.BASHER_ENTITY_TYPE, RaidWavesConfigHelper.BASHER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.PROVOKER_ENTITY_TYPE, RaidWavesConfigHelper.PROVOKER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.NECROMANCER_ENTITY_TYPE, RaidWavesConfigHelper.NECROMANCER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.SORCERER_ENTITY_TYPE, RaidWavesConfigHelper.SORCERER_RAID_WAVES);
        IllagerInvasion.registerRaiderType((Holder.Reference<? extends EntityType<? extends Raider>>)EntityType.f_20459_.m_204041_(), RaidWavesConfigHelper.ILLUSIONER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.ARCHIVIST_ENTITY_TYPE, RaidWavesConfigHelper.ARCHIVIST_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.MARAUDER_ENTITY_TYPE, RaidWavesConfigHelper.MARAUDER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.INQUISITOR_ENTITY_TYPE, RaidWavesConfigHelper.INQUISITOR_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.ALCHEMIST_ENTITY_TYPE, RaidWavesConfigHelper.ALCHEMIST_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.INVOKER_ENTITY_TYPE, RaidWavesConfigHelper.INVOKER_RAID_WAVES);
    }

    private static void registerRaiderType(Holder.Reference<? extends EntityType<? extends Raider>> holder, int[] spawnsPerWaveBeforeBonus) {
        IllagerInvasion.registerRaiderType((ResourceKey<? extends EntityType<? extends Raider>>)holder.m_205785_(), (EntityType<? extends Raider>)((EntityType)holder.m_203334_()), spawnsPerWaveBeforeBonus);
    }

    private static void registerRaiderType(RegistryReference<? extends EntityType<? extends Raider>> registryReference, int[] spawnsPerWaveBeforeBonus) {
        IllagerInvasion.registerRaiderType((ResourceKey<? extends EntityType<? extends Raider>>)registryReference.getResourceKey(), (EntityType<? extends Raider>)((EntityType)registryReference.get()), spawnsPerWaveBeforeBonus);
    }

    private static void registerRaiderType(ResourceKey<? extends EntityType<? extends Raider>> resourceKey, EntityType<? extends Raider> entityType, int[] spawnsPerWaveBeforeBonus) {
        CommonAbstractions.INSTANCE.registerRaiderType(resourceKey.m_135782_().m_179910_().toUpperCase(Locale.ROOT), entityType, spawnsPerWaveBeforeBonus);
    }

    private static void registerPotionRecipes() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43602_, Items.f_220219_, (Potion)ModRegistry.BERSERKING_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.BERSERKING_POTION.get(), Items.f_42451_, (Potion)ModRegistry.LONG_BERSERKING_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.BERSERKING_POTION.get(), Items.f_42525_, (Potion)ModRegistry.STRONG_BERSERKING_POTION.get());
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.ALCHEMIST_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.38));
        context.registerEntityAttributes((EntityType)ModRegistry.ARCHIVIST_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.36));
        context.registerEntityAttributes((EntityType)ModRegistry.BASHER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, 0.31).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.2));
        context.registerEntityAttributes((EntityType)ModRegistry.FIRECALLER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, 0.38));
        context.registerEntityAttributes((EntityType)ModRegistry.INQUISITOR_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 1.6).m_22268_(Attributes.f_22278_, 0.8));
        context.registerEntityAttributes((EntityType)ModRegistry.INVOKER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, 0.36).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22281_, 8.0));
        context.registerEntityAttributes((EntityType)ModRegistry.MARAUDER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.3));
        context.registerEntityAttributes((EntityType)ModRegistry.PROVOKER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.38));
        context.registerEntityAttributes((EntityType)ModRegistry.SORCERER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, 0.38));
        context.registerEntityAttributes((EntityType)ModRegistry.SURRENDERED_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22281_, 5.0));
        context.registerEntityAttributes((EntityType)ModRegistry.NECROMANCER_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, 0.38));
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.ALCHEMIST_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.ARCHIVIST_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.BASHER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.FIRECALLER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.INQUISITOR_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.INVOKER_ENTITY_TYPE.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MARAUDER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.PROVOKER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.SORCERER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        context.registerSpawnPlacement((EntityType)ModRegistry.SURRENDERED_ENTITY_TYPE.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.NECROMANCER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new ItemStack((ItemLike)ModRegistry.HORN_OF_SIGHT_ITEM.get())).displayItems((itemDisplayParameters, output) -> {
            output.m_246326_((ItemLike)ModRegistry.IMBUIING_TABLE_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.UNUSUAL_DUST_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.ILLUSIONARY_DUST_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.HALLOWED_GEM_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.PRIMAL_ESSENCE_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.PLATINUM_CHUNK_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.PLATINUM_SHEET_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.PLATINUM_INFUSED_HATCHET_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.HORN_OF_SIGHT_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.LOST_CANDLE_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MAGICAL_FIRE_CHARGE_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.PROVOKER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.BASHER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.SORCERER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.ARCHIVIST_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.INQUISITOR_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MARAUDER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.INVOKER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.ALCHEMIST_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.FIRECALLER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.NECROMANCER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.SURRENDERED_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.ILLUSIONER_SPAWN_EGG_ITEM.get());
        }));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

