/*
 * Decompiled with CFR 0.152.
 */
package toni.easydisenchanting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import toni.easydisenchanting.foundation.config.AllConfigs;

@Mod.EventBusSubscriber(modid="easydisenchanting")
public class AnvilModifier {
    @SubscribeEvent
    public static void onRepair(AnvilRepairEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (right.m_41720_() == Items.f_42517_) {
            AnvilModifier.checkGiveItems(event, left, right);
        } else if (left.m_41720_() == Items.f_42517_) {
            AnvilModifier.checkGiveItems(event, right, left);
        } else if (left.m_41720_() == Items.f_42690_) {
            AnvilModifier.checkGiveItems(event, right, left);
        }
    }

    private static void checkGiveItems(AnvilRepairEvent event, ItemStack left, ItemStack right) {
        if (!left.m_41793_() || left.m_41720_() == Items.f_42690_) {
            return;
        }
        if ((Integer)AllConfigs.common().return_value.get() == 0) {
            return;
        }
        ItemStack disenchanted = left.m_41777_();
        AnvilModifier.setEnchantments(new HashMap<Enchantment, Integer>(), disenchanted);
        if ((Integer)AllConfigs.common().fixed_value.get() == 0) {
            event.getEntity().m_6749_(1);
        }
        if (!event.getEntity().m_150109_().m_36054_(disenchanted)) {
            event.getEntity().m_36176_(disenchanted, true);
        }
    }

    @SubscribeEvent
    public static void onUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        AnvilModifier.checkUpdate(event, left, right);
        AnvilModifier.checkUpdate(event, right, left);
        AnvilModifier.checkMerge(event, right, left);
    }

    private static void checkUpdate(AnvilUpdateEvent event, ItemStack left, ItemStack right) {
        if (!left.m_41793_() || left.m_41720_() == Items.f_42690_ || right.m_41720_() != Items.f_42517_ || right.m_41613_() != 1) {
            return;
        }
        ItemStack finalBook = new ItemStack((ItemLike)Items.f_42690_);
        Map<Enchantment, Integer> toRemove = AnvilModifier.getEnchantments(left);
        AnvilModifier.setEnchantments(toRemove, finalBook);
        event.setOutput(finalBook);
        event.setCost(AnvilModifier.getCost(left, right, toRemove));
    }

    private static void checkMerge(AnvilUpdateEvent event, ItemStack left, ItemStack right) {
        if (!left.m_41793_() || right.m_41720_() != Items.f_42690_ || right.m_41613_() != 1) {
            return;
        }
        ItemStack finalBook = new ItemStack((ItemLike)Items.f_42690_);
        Map<Enchantment, Integer> toRemove = AnvilModifier.getEnchantments(left);
        Map<Enchantment, Integer> toMerge = AnvilModifier.getEnchantments(right);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        HashSet<Enchantment> allEnchants = new HashSet<Enchantment>();
        allEnchants.addAll(toRemove.keySet());
        allEnchants.addAll(toMerge.keySet());
        for (Enchantment key : allEnchants) {
            Integer a = toRemove.getOrDefault(key, 0);
            Integer b = toMerge.getOrDefault(key, 0);
            int combinedLevel = Math.min(key.m_6586_(), a == b ? a + 1 : Math.max(a, b));
            enchantments.put(key, combinedLevel);
        }
        AnvilModifier.setEnchantments(enchantments, finalBook);
        event.setOutput(finalBook);
        event.setCost(AnvilModifier.getCost(left, right, enchantments));
    }

    private static int getCost(ItemStack left, ItemStack right, Map<Enchantment, Integer> enchantsToRemove) {
        int costFactor = 0;
        ItemStack rightCopy = right.m_41777_();
        AnvilModifier.setEnchantments(enchantsToRemove, rightCopy);
        for (Enchantment enchant : enchantsToRemove.keySet()) {
            if (enchant == null) continue;
            int enchantValue = Math.min(enchant.m_6586_(), enchantsToRemove.get(enchant));
            int rarity = switch (enchant.m_44699_()) {
                default -> throw new IncompatibleClassChangeError();
                case Enchantment.Rarity.COMMON -> 1;
                case Enchantment.Rarity.UNCOMMON -> 2;
                case Enchantment.Rarity.RARE -> 4;
                case Enchantment.Rarity.VERY_RARE -> 8;
            };
            rarity = Math.max(1, rarity / 2);
            costFactor += rarity * enchantValue;
        }
        Integer fixedValue = (Integer)AllConfigs.common().fixed_value.get();
        double factor_value = (Double)AllConfigs.common().factor_value.get();
        return fixedValue != 1000 ? Math.max(1, fixedValue) : (factor_value > 0.0 ? (int)Math.round((double)costFactor * factor_value) : 1);
    }

    private static Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack);
    }

    private static void setEnchantments(Map<Enchantment, Integer> enchantments, ItemStack stack) {
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)stack);
    }
}

