/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.level.block;

import fuzs.netherchested.NetherChested;
import fuzs.netherchested.config.ServerConfig;
import fuzs.netherchested.init.ModRegistry;
import fuzs.netherchested.world.level.block.entity.NetherChestBlockEntity;
import fuzs.puzzlesapi.api.limitlesscontainers.v1.LimitlessContainerSynchronizer;
import fuzs.puzzlesapi.api.limitlesscontainers.v1.LimitlessContainerUtils;
import fuzs.puzzlesapi.api.limitlesscontainers.v1.MultipliedContainer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NetherChestBlock
extends EnderChestBlock {
    public static final String NETHER_CHEST_DESCRIPTION_KEY = "block.netherchested.nether_chest.description";
    private static final Component DESCRIPTION_COMPONENT = Component.m_237115_((String)"block.netherchested.nether_chest.description").m_130940_(ChatFormatting.GOLD);

    public NetherChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            blockEntity2.setCustomName(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof NetherChestBlockEntity) {
                NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
                LimitlessContainerUtils.dropContents((Level)level, (BlockPos)pos, (Container)blockEntity2.container);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            MenuProvider menuProvider;
            BlockPos above = pos.m_7494_();
            if (level.m_46472_() == Level.f_46429_ && ((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).explodeInNether) {
                level.m_7471_(pos, false);
                Vec3 center = pos.m_252807_();
                level.m_254951_(null, level.m_269111_().m_269488_(center), null, center, (float)((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).netherExplosionStrength, true, Level.ExplosionInteraction.BLOCK);
            } else if (!(((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).noBlockAbove && level.m_8055_(above).m_60796_((BlockGetter)level, above) || (menuProvider = this.m_7246_(state, level, pos)) == null)) {
                player.m_5893_(menuProvider).ifPresent(containerId -> LimitlessContainerSynchronizer.setSynchronizerFor((ServerPlayer)((ServerPlayer)player), (int)containerId));
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModRegistry.NETHER_CHEST_BLOCK_ENTITY_TYPE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? NetherChestBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.NETHER_CHEST_BLOCK_ENTITY_TYPE.get()), NetherChestBlockEntity::lidAnimateTick) : null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            return LimitlessContainerUtils.getRedstoneSignalFromContainer((MultipliedContainer)blockEntity2.container);
        }
        return 0;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            blockEntity2.recheckOpen();
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(DESCRIPTION_COMPONENT);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(state.m_61138_((Property)f_53116_) && ((Boolean)state.m_61143_((Property)f_53116_)).booleanValue() || random.m_188503_(2) != 0)) {
            double posX = (double)pos.m_123341_() + 0.5 + 0.4375 * (double)(random.m_188503_(2) * 2 - 1);
            double posY = (float)pos.m_123342_() + random.m_188501_();
            double posZ = (double)pos.m_123343_() + 0.5 + 0.4375 * (double)(random.m_188503_(2) * 2 - 1);
            double ySpeed = (double)random.m_188501_() * 0.015625;
            if (random.m_188503_(7) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, posX, posY, posZ, 0.0, ySpeed * 4.0, 0.0);
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, posX, posY, posZ, 0.0, ySpeed, 0.0);
            }
        }
    }
}

