/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilInventory;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;

public class UtilRemote {
    public static void searchAndOpen(ServerPlayer player, ServerLevel serverWorld) {
        Triple<String, Integer, ItemStack> searchResult = UtilInventory.getCurioRemote((Player)player, (Item)SsnRegistry.Items.CRAFTING_REMOTE.get());
        ItemStack curioRemote = (ItemStack)searchResult.getRight();
        if (!curioRemote.m_41619_()) {
            UtilRemote.openRemote((Level)serverWorld, (Player)player, curioRemote, (MenuProvider)SsnRegistry.Items.CRAFTING_REMOTE.get());
        } else {
            searchResult = UtilInventory.getCurioRemote((Player)player, (Item)SsnRegistry.Items.INVENTORY_REMOTE.get());
            curioRemote = (ItemStack)searchResult.getRight();
            if (!curioRemote.m_41619_()) {
                UtilRemote.openRemote((Level)serverWorld, (Player)player, curioRemote, (MenuProvider)SsnRegistry.Items.INVENTORY_REMOTE.get());
            } else {
                searchResult = UtilInventory.getCurioRemote((Player)player, (Item)SsnRegistry.Items.EXPANDED_REMOTE.get());
                curioRemote = (ItemStack)searchResult.getRight();
                if (!curioRemote.m_41619_()) {
                    UtilRemote.openRemote((Level)serverWorld, (Player)player, curioRemote, (MenuProvider)SsnRegistry.Items.EXPANDED_REMOTE.get());
                }
            }
        }
    }

    public static boolean openRemote(Level world, Player player, ItemStack itemStackIn, MenuProvider theRemoteItem) {
        double distance;
        DimPos dp = DimPos.getPosStored(itemStackIn);
        if (dp == null) {
            UtilTileEntity.statusMessage(player, "item.remote.notconnected");
            return false;
        }
        BlockPos posTarget = dp.getBlockPos();
        if ((Integer)ConfigRegistry.ITEMRANGE.get() != -1 && (distance = player.m_20275_((double)posTarget.m_123341_() + 0.5, (double)posTarget.m_123342_() + 0.5, (double)posTarget.m_123343_() + 0.5)) >= (double)((Integer)ConfigRegistry.ITEMRANGE.get()).intValue()) {
            UtilTileEntity.statusMessage(player, "item.remote.outofrange");
            return false;
        }
        if (world.f_46443_) {
            return false;
        }
        ServerLevel serverTargetWorld = null;
        try {
            serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.m_7654_());
            if (serverTargetWorld == null) {
                StorageNetworkMod.LOGGER.error("Missing dimension key " + dp.getDimension());
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("unknown exception on dim " + dp.getDimension(), (Throwable)e);
            return false;
        }
        if (!serverTargetWorld.isAreaLoaded(posTarget, 1)) {
            UtilTileEntity.chatMessage(player, "item.remote.notloaded");
            StorageNetworkMod.LOGGER.info(UtilTileEntity.lang("item.remote.notloaded") + posTarget);
            return false;
        }
        BlockEntity tile = serverTargetWorld.m_7702_(posTarget);
        if (tile instanceof TileMain) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)theRemoteItem);
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"item.remote.notfound"), true);
        return false;
    }
}

