/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.api.IConnectableLink;
import com.lothrazar.storagenetwork.util.Batch;
import com.lothrazar.storagenetwork.util.Request;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RequestBatch
extends Batch<Request> {
    private static final long serialVersionUID = 9136459257621033386L;

    public void extractStacks(IConnectableLink providerStorage, Integer slot, Item item) {
        List requests = (List)this.get(item);
        ArrayList<Request> remainingRequests = new ArrayList<Request>();
        for (Request request : requests) {
            ItemStack stack;
            if (!request.insertStack(providerStorage, slot).booleanValue()) {
                remainingRequests.add(request);
            }
            if (!(stack = providerStorage.extractFromSlot(slot, 1, true)).m_41619_()) continue;
            return;
        }
        this.put(item, remainingRequests);
    }

    public void sort() {
        Collection requests = this.values();
        for (List requestList : requests) {
            this.quickSort(requestList, 0, requestList.size() - 1);
        }
    }

    private void quickSort(List<Request> requestList, int start, int end) {
        if (start < end) {
            int partitionInd = this.partition(requestList, start, end);
            this.quickSort(requestList, start, partitionInd - 1);
            this.quickSort(requestList, partitionInd + 1, end);
        }
    }

    private int partition(List<Request> requestList, int start, int end) {
        int pivot = requestList.get(end).getPriority();
        int i = start - 1;
        for (int j = start; j < end; ++j) {
            if (requestList.get(j).getPriority() > pivot) continue;
            Request highTemp = requestList.get(++i);
            Request lowTemp = requestList.get(j);
            requestList.set(i, lowTemp);
            requestList.set(j, highTemp);
        }
        Request swapTemp = requestList.get(i + 1);
        Request temp = requestList.get(end);
        requestList.set(i + 1, temp);
        requestList.set(end, swapTemp);
        return i + 1;
    }
}

