/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.gui.NetworkCraftingInventory;
import com.lothrazar.storagenetwork.network.ClearRecipeMessage;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RecipeMessage {
    private CompoundTag nbt;
    private int index = 0;

    private RecipeMessage() {
    }

    public RecipeMessage(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static RecipeMessage decode(FriendlyByteBuf buf) {
        RecipeMessage message = new RecipeMessage();
        message.index = buf.readInt();
        message.nbt = buf.m_130260_();
        return message;
    }

    public static void encode(RecipeMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.index);
        buf.m_130079_(msg.nbt);
    }

    public static void handle(RecipeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!(player.f_36096_ instanceof ContainerNetwork)) {
                return;
            }
            ContainerNetwork ctr = (ContainerNetwork)player.f_36096_;
            TileMain main = ctr.getTileMain();
            if (main == null) {
                StorageNetworkMod.log("Recipe message cancelled, null tile " + ctr);
                return;
            }
            ClearRecipeMessage.clearContainerRecipe(player, false);
            NetworkCraftingInventory craftMatrix = ctr.getCraftMatrix();
            for (int slot = 0; slot < 9; ++slot) {
                int i;
                HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
                boolean isOreDict = false;
                ListTag invList = message.nbt.m_128437_("s" + slot, 10);
                for (i = 0; i < invList.size(); ++i) {
                    CompoundTag stackTag = invList.m_128728_(i);
                    ItemStack s = ItemStack.m_41712_((CompoundTag)stackTag);
                    map.put(i, s);
                }
                for (i = 0; i < map.size(); ++i) {
                    ItemStack stackCurrent = (ItemStack)map.get(i);
                    if (stackCurrent == null || stackCurrent.m_41619_()) continue;
                    ItemStackMatcher itemStackMatcher = new ItemStackMatcher(stackCurrent);
                    itemStackMatcher.setNbt(true);
                    itemStackMatcher.setOre(isOreDict);
                    ItemStack ex = UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), itemStackMatcher, 1, true);
                    if (ex != null && !ex.m_41619_() && craftMatrix.m_8020_(slot).m_41619_()) {
                        UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), itemStackMatcher, 1, false);
                        craftMatrix.m_6836_(slot, ex);
                        break;
                    }
                    if ((stackCurrent = main.request(!stackCurrent.m_41619_() ? itemStackMatcher : null, 1, false)).m_41619_() || !craftMatrix.m_8020_(slot).m_41619_()) continue;
                    craftMatrix.m_6836_(slot, stackCurrent);
                    break;
                }
                ctr.slotChanged();
                List<ItemStack> list = main.getNetwork().getStacks();
                PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

