/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.jei;

import com.lothrazar.storagenetwork.block.expand.ContainerNetworkInventoryExpanded;
import com.lothrazar.storagenetwork.block.request.ContainerNetworkCraftingTable;
import com.lothrazar.storagenetwork.gui.ISearchHandler;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkExpandedRemote;
import com.lothrazar.storagenetwork.jei.RequestRecipeTransferHandler;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static IJeiRuntime runtime = null;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("storagenetwork", "jei");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new RequestRecipeTransferHandler<ContainerNetworkCraftingTable>(){

            public Class<? extends ContainerNetworkCraftingTable> getContainerClass() {
                return ContainerNetworkCraftingTable.class;
            }

            public Optional<MenuType<ContainerNetworkCraftingTable>> getMenuType() {
                return Optional.of((MenuType)SsnRegistry.Menus.REQUEST.get());
            }
        }, RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new RequestRecipeTransferHandler<ContainerNetworkInventoryExpanded>(){

            public Class<? extends ContainerNetworkInventoryExpanded> getContainerClass() {
                return ContainerNetworkInventoryExpanded.class;
            }

            public Optional<MenuType<ContainerNetworkInventoryExpanded>> getMenuType() {
                return Optional.of((MenuType)SsnRegistry.Menus.REQUEST_EXPANDED.get());
            }
        }, RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new RequestRecipeTransferHandler<ContainerNetworkExpandedRemote>(){

            public Class<? extends ContainerNetworkExpandedRemote> getContainerClass() {
                return ContainerNetworkExpandedRemote.class;
            }

            public Optional<MenuType<ContainerNetworkExpandedRemote>> getMenuType() {
                return Optional.of((MenuType)SsnRegistry.Menus.EXPANDED_REMOTE.get());
            }
        }, RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new RequestRecipeTransferHandler<ContainerNetworkCraftingRemote>(){

            public Class<? extends ContainerNetworkCraftingRemote> getContainerClass() {
                return ContainerNetworkCraftingRemote.class;
            }

            public Optional<MenuType<ContainerNetworkCraftingRemote>> getMenuType() {
                return Optional.of((MenuType)SsnRegistry.Menus.CRAFTING_REMOTE.get());
            }
        }, RecipeTypes.CRAFTING);
    }

    static {
        NetworkWidget.searchHandlers.add(new ISearchHandler(){

            @Override
            public void setSearch(String text) {
                if (runtime != null && runtime.getIngredientFilter() != null) {
                    runtime.getIngredientFilter().setFilterText(text);
                }
            }

            @Override
            public String getSearch() {
                if (runtime != null && runtime.getIngredientFilter() != null) {
                    return runtime.getIngredientFilter().getFilterText();
                }
                return "";
            }

            @Override
            public String getName() {
                return "JEI";
            }
        });
    }
}

