/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemProcessing;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.capability.handler.UpgradesItemStackHandler;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import java.util.concurrent.Callable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityConnectableProcessing
implements INBTSerializable<CompoundTag>,
IConnectableItemProcessing {
    private Direction inventoryFace;
    public final IConnectable connectable;
    public final UpgradesItemStackHandler upgrades = new UpgradesItemStackHandler();
    private final FilterItemStackHandler filters = new FilterItemStackHandler(9);
    private final FilterItemStackHandler filtersOut = new FilterItemStackHandler(1);
    private int priority;

    CapabilityConnectableProcessing() {
        this.connectable = new CapabilityConnectable();
    }

    public CapabilityConnectableProcessing(BlockEntity tile) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
    }

    public void setInventoryFace(Direction inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128405_("prio", this.priority);
        result.m_128365_("upgrades", (Tag)this.upgrades.serializeNBT());
        result.m_128365_("filtersIn", (Tag)this.filters.serializeNBT());
        result.m_128365_("filtersOut", (Tag)this.filtersOut.serializeNBT());
        if (this.inventoryFace != null) {
            result.m_128359_("inventoryFace", this.inventoryFace.toString());
        }
        return result;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag filtersOut;
        CompoundTag filters;
        this.priority = nbt.m_128451_("prio");
        CompoundTag upgrades = nbt.m_128469_("upgrades");
        if (upgrades != null) {
            this.upgrades.deserializeNBT(upgrades);
        }
        if ((filters = nbt.m_128469_("filters")) != null) {
            this.filters.deserializeNBT(filters);
        }
        if ((filtersOut = nbt.m_128469_("filtersOut")) != null) {
            this.filtersOut.deserializeNBT(filtersOut);
        }
        if (nbt.m_128441_("inventoryFace")) {
            this.inventoryFace = Direction.m_122402_((String)nbt.m_128461_("inventoryFace"));
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int value) {
        this.priority = value;
    }

    @Override
    public Direction facingInventory() {
        return this.inventoryFace;
    }

    @Override
    public void execute(TileMain main) {
        StorageNetworkMod.log("Run Now processing cable; " + main + "..." + this);
    }

    public static class Factory
    implements Callable<IConnectableItemProcessing> {
        @Override
        public IConnectableItemProcessing call() throws Exception {
            return new CapabilityConnectableProcessing();
        }
    }
}

