/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.main;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.IConnectableItemProcessing;
import com.lothrazar.storagenetwork.block.main.NetworkModule;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.RequestBatch;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileMain
extends BlockEntity {
    private NetworkModule nw = new NetworkModule();

    public TileMain(BlockPos pos, BlockState state) {
        super((BlockEntityType)SsnRegistry.Tiles.MASTER.get(), pos, state);
    }

    public NetworkModule getNetwork() {
        return this.nw;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        this.m_187480_();
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_() == null ? new CompoundTag() : pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    public int insertStack(ItemStack stack, boolean simulate) {
        int totalInserted = this.nw.insertStack(stack, simulate);
        return totalInserted;
    }

    public ItemStack request(ItemStackMatcher matcher, int size, boolean simulate) {
        ItemStack result = this.nw.request(matcher, size, simulate);
        return result;
    }

    public void executeRequestBatch(RequestBatch batch) {
        if (batch == null) {
            return;
        }
        batch.sort();
        this.nw.executeRequestBatch(batch);
    }

    private DimPos getDimPos() {
        return new DimPos(this.f_58857_, this.f_58858_);
    }

    public void clearCache() {
        this.nw.ch.clearCache();
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileMain tile) {
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileMain tile) {
        tile.tick();
    }

    private boolean isRunnable(IConnectable connectable) {
        boolean hasPower;
        return !connectable.needsRedstone() || (hasPower = this.f_58857_.m_276867_(connectable.getPos().getBlockPos()));
    }

    private void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.refresh();
        RequestBatch requestBatch = null;
        for (IConnectable connectable : this.nw.getConnectables()) {
            IConnectableItemAutoIO ioCap;
            if (connectable == null || connectable.getPos() == null) continue;
            IConnectableItemProcessing processingCap = connectable.getPos().getCapability(StorageNetworkCapabilities.PROCESSING_CAPABILITY, null);
            if (processingCap != null && this.isRunnable(connectable)) {
                processingCap.execute(this);
            }
            if ((ioCap = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null)) == null || !this.isRunnable(connectable) || !ioCap.canRunNow(connectable.getPos(), this)) continue;
            if (ioCap.ioDirection() == EnumStorageDirection.IN) {
                ioCap.runImport(this);
            }
            if (ioCap.ioDirection() != EnumStorageDirection.OUT) continue;
            requestBatch = ioCap.runExport(this);
        }
        this.executeRequestBatch(requestBatch);
    }

    private void refresh() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_46467_() % (long)StorageNetworkMod.CONFIG.refreshTicks() == 0L || this.nw.shouldRefresh()) {
            this.nw.doRefresh(this.getDimPos());
        }
    }
}

