/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.exchange;

import com.lothrazar.library.cap.ItemStackHandlerEx;
import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ExchangeItemStackHandler
extends ItemStackHandlerEx {
    TileMain tileMain;

    public ExchangeItemStackHandler() {
        super(Math.min(5000, (Integer)ConfigRegistry.EXCHANGEBUFFER.get()));
        this.update();
    }

    public void setMain(TileMain main) {
        this.tileMain = main;
        this.update();
    }

    public void update() {
        if (this.tileMain == null || this.tileMain.m_58904_() == null) {
            return;
        }
        try {
            this.stacks.clear();
            int i = 0;
            for (ItemStack stack : this.tileMain.getNetwork().getStacks()) {
                if (i < this.stacks.size()) {
                    this.stacks.set(i, (Object)stack);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("Exchange update error ", (Throwable)e);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || this.tileMain == null || !this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        try {
            int remaining = this.tileMain.insertStack(stack, simulate);
            if (remaining > 0) {
                this.update();
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining);
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("insertStack error ", (Throwable)e);
        }
        this.update();
        return ItemStack.f_41583_;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.tileMain == null) {
            return ItemStack.f_41583_;
        }
        ItemStackMatcher matcher = new ItemStackMatcher(this.getStackInSlot(slot));
        ItemStack stack = this.tileMain.request(matcher, amount, simulate);
        this.update();
        return stack;
    }

    protected void onLoad() {
        this.update();
    }
}

