/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.util;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class MiscUtils {
    public static Random random = new Random();
    public static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.m_6084_();

    public static <T extends Entity> List<T> getNearbyNonLivingEntities(Class<T> entityClass, Level level, Entity entityNear, AABB boundingBox) {
        List list = level.m_6443_(entityClass, boundingBox, p_186450_ -> true);
        return list;
    }

    public static void maybeDisableShield(Mob mob, Player p_21425_, ItemStack p_21426_, ItemStack p_21427_) {
        if (!p_21426_.m_41619_() && !p_21427_.m_41619_() && p_21426_.m_41720_() instanceof AxeItem && p_21427_.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)mob) * 0.05f;
            if (random.nextFloat() < f) {
                p_21425_.m_36335_().m_41524_(Items.f_42740_, 100);
                p_21425_.m_5810_();
                mob.m_9236_().m_7605_((Entity)p_21425_, (byte)30);
            }
        }
    }

    public static boolean isHolding(LivingEntity livingEntity, Item item) {
        return livingEntity.m_21205_().m_41720_() == item || livingEntity.m_21206_().m_41720_() == item;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof Player && livingEntity.m_21254_()) {
            ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21120_(livingEntity.m_7655_()).m_41720_(), ticks);
            livingEntity.m_5810_();
            livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
        }
    }

    public static boolean randomPercent(int chance) {
        int randomInt = random.nextInt(100);
        return randomInt < chance;
    }

    public static float distanceToBlockPos(Entity mob, BlockPos pos) {
        float f = (float)(mob.m_20185_() - ((double)pos.m_123341_() + 0.5));
        float f1 = (float)(mob.m_20186_() - (double)pos.m_123342_());
        float f2 = (float)(mob.m_20189_() - ((double)pos.m_123343_() + 0.5));
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceBetweenVecs(Vec3 pos1, Vec3 pos2) {
        float f = (float)(pos1.f_82479_ - pos2.f_82479_);
        float f1 = (float)(pos1.f_82480_ - pos2.f_82480_);
        float f2 = (float)(pos1.f_82481_ - pos2.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceBetweenVecAndBlockPos(Vec3 vec, BlockPos pos) {
        float f = (float)(vec.f_82479_ - ((double)pos.m_123341_() + 0.5));
        float f1 = (float)(vec.f_82480_ - (double)pos.m_123342_());
        float f2 = (float)(vec.f_82481_ - ((double)pos.m_123343_() + 0.5));
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float horizontalDistanceBetweenVecs(Vec3 pos1, Vec3 pos2) {
        float f = (float)(pos1.f_82479_ - pos2.f_82479_);
        float f2 = (float)(pos1.f_82481_ - pos2.f_82481_);
        return Mth.m_14116_((float)(f * f + f2 * f2));
    }

    public static float horizontalDistanceBetweenBlockPos(BlockPos pos1, BlockPos pos2) {
        float f = pos1.m_123341_() - pos2.m_123341_();
        float f2 = pos1.m_123343_() - pos2.m_123343_();
        return Mth.m_14116_((float)(f * f + f2 * f2));
    }

    public static float radToDeg(float rad) {
        return rad * 57.295776f;
    }

    public static float degToRad(float deg) {
        return deg * ((float)Math.PI / 180);
    }

    public static boolean canHarmBasedOnTeamAndTag(TagKey<EntityType<?>> tag, Entity entity, Entity target, Entity owner, Predicate<Entity> ownerPredicate) {
        Entity entityForTeam;
        Entity entity2 = entityForTeam = owner != null ? owner : entity;
        if (owner == null) {
            return true;
        }
        if (owner != null && owner instanceof Mob && ((Mob)owner).m_5448_() != null && ((Mob)owner).m_5448_() == target) {
            return true;
        }
        if (tag != null && target.m_6095_().m_204039_(tag) && entityForTeam.m_5647_() == null && target.m_5647_() == null) {
            return false;
        }
        if (entityForTeam.m_5647_() != null && target.m_5647_() != null && entityForTeam.m_5647_().m_83536_(target.m_5647_())) {
            return false;
        }
        return owner != null && (ownerPredicate != null && ownerPredicate.test(owner) || ownerPredicate == null);
    }

    public static float randomSoundPitch() {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    public static boolean isMovingOnLand(Entity entity) {
        return entity.m_20096_() && entity.m_20184_().m_165925_() > 1.0E-6 && !entity.m_20072_();
    }

    public static boolean isMovingOnGround(Entity entity) {
        return entity.m_20096_() && entity.m_20184_().m_165925_() > 1.0E-6;
    }

    public static boolean isMovingHorizontally(Entity entity) {
        return entity.m_20184_().m_165925_() > 1.0E-6;
    }

    public static boolean enchantmentIs(Enchantment enchantment, TagKey<Enchantment> tag) {
        for (Enchantment enchant : ForgeRegistries.ENCHANTMENTS.tags().getTag(tag).stream().collect(Collectors.toList())) {
            if (enchantment != enchant) continue;
            return true;
        }
        return false;
    }

    public static boolean enchantedWith(ItemStack stack, TagKey<Enchantment> tag) {
        for (Enchantment enchant : ForgeRegistries.ENCHANTMENTS.tags().getTag(tag).stream().collect(Collectors.toList())) {
            if (stack.getEnchantmentLevel(enchant) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void markBoundingBox(Level level, AABB boundingBox) {
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)boundingBox.f_82288_), (int)Mth.m_14107_((double)boundingBox.f_82289_), (int)Mth.m_14107_((double)boundingBox.f_82290_), (int)Mth.m_14107_((double)boundingBox.f_82291_), (int)Mth.m_14107_((double)boundingBox.f_82292_), (int)Mth.m_14107_((double)boundingBox.f_82293_))) {
            level.m_46597_(blockpos, Blocks.f_50504_.m_49966_());
        }
    }

    public static boolean isZero(BlockPos pos) {
        return pos.m_123341_() == 0 && pos.m_123342_() == 0 && pos.m_123343_() == 0;
    }
}

