/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.util;

import com.alexander.whatareyouvotingfor.init.EntityTypeInit;
import com.alexander.whatareyouvotingfor.init.ModelLayerInit;
import com.alexander.whatareyouvotingfor.models.entities.ArmadilloModel;
import com.alexander.whatareyouvotingfor.models.entities.CrabModel;
import com.alexander.whatareyouvotingfor.models.entities.PenguinModel;
import com.alexander.whatareyouvotingfor.renderers.entities.ArmadilloRenderer;
import com.alexander.whatareyouvotingfor.renderers.entities.CrabRenderer;
import com.alexander.whatareyouvotingfor.renderers.entities.PenguinRenderer;
import com.alexander.whatareyouvotingfor.renderers.layers.WolfArmourLayer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="whatareyouvotingfor", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusSubscriber {
    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelLayerInit.CRAB, CrabModel::createBodyLayer);
        event.registerLayerDefinition(ModelLayerInit.ARMADILLO, ArmadilloModel::createBodyLayer);
        event.registerLayerDefinition(ModelLayerInit.WOLF_ARMOUR, ClientEventBusSubscriber::createWolfArmourLayer);
        event.registerLayerDefinition(ModelLayerInit.PENGUIN, PenguinModel::createBodyLayer);
    }

    public static LayerDefinition createWolfArmourLayer() {
        return ClientEventBusSubscriber.createWolfArmourLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createWolfArmourLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        float f = 13.5f;
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        partdefinition1.m_171599_("real_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, deformation).m_171514_(16, 14).m_171488_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, deformation).m_171514_(16, 14).m_171488_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, deformation).m_171514_(0, 10).m_171488_(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, deformation), PartPose.f_171404_);
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, deformation), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upper_body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, deformation), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f);
        partdefinition.m_171599_("right_hind_leg", cubelistbuilder, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.m_171599_("left_hind_leg", cubelistbuilder, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.m_171599_("right_front_leg", cubelistbuilder, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.m_171599_("left_front_leg", cubelistbuilder, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition partdefinition2 = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("real_tail", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, deformation), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static LayerDefinition createInnerArmourLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171107_, (float)0.0f), (int)64, (int)32);
    }

    public static LayerDefinition createOuterArmourLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171106_, (float)0.0f), (int)64, (int)32);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityTypeInit.CRAB.get(), CrabRenderer::new);
        event.registerEntityRenderer((EntityType)EntityTypeInit.ARMADILLO.get(), ArmadilloRenderer::new);
        event.registerEntityRenderer((EntityType)EntityTypeInit.PENGUIN.get(), PenguinRenderer::new);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer = event.getRenderer(EntityType.f_20499_);
        if (renderer.m_7200_() instanceof WolfModel) {
            renderer.m_115326_((RenderLayer)new WolfArmourLayer((RenderLayerParent<Wolf, WolfModel<Wolf>>)renderer, event.getEntityModels()));
        }
    }
}

