/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.models.entities;

import com.alexander.whatareyouvotingfor.animation.keyframe_animations.definition.PenguinKeyframeAnimations;
import com.alexander.whatareyouvotingfor.animation.sine_wave_animations.SineWaveAnimationUtils;
import com.alexander.whatareyouvotingfor.animation.sine_wave_animations.definition.PenguinSineWaveAnimations;
import com.alexander.whatareyouvotingfor.entities.Penguin;
import com.alexander.whatareyouvotingfor.util.MiscUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class PenguinModel<T extends Penguin>
extends HierarchicalModel<T> {
    public final ModelPart root;
    public final ModelPart everything;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart beak;
    public final ModelPart beakUpper;
    public final ModelPart eyebrows;
    public final ModelPart eyes;
    public final ModelPart happyEyes;
    public final ModelPart scaredEyes;
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;

    public PenguinModel(ModelPart root) {
        this.root = root;
        this.everything = root.m_171324_("everything");
        this.body = this.everything.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.beak = this.head.m_171324_("beak");
        this.beakUpper = this.beak.m_171324_("beakUpper");
        this.eyebrows = this.head.m_171324_("eyebrows");
        this.eyes = this.head.m_171324_("eyes");
        this.happyEyes = this.head.m_171324_("happyEyes");
        this.scaredEyes = this.head.m_171324_("scaredEyes");
        this.leftWing = this.body.m_171324_("leftWing");
        this.rightWing = this.body.m_171324_("rightWing");
        this.leftLeg = this.everything.m_171324_("leftLeg");
        this.rightLeg = this.everything.m_171324_("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition everything = partdefinition.m_171599_("everything", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = everything.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-5.5f, -16.0f, -4.0f, 11.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-4.0f, -5.0f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition beakUpper = beak.m_171599_("beakUpper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -4.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition eyebrows = head.m_171599_("eyebrows", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-5.0f, -5.0f, -3.5f, 10.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(46, 28).m_171488_(-4.0f, -3.0f, -3.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition happyEyes = head.m_171599_("happyEyes", CubeListBuilder.m_171558_().m_171514_(46, 32).m_171488_(-4.0f, -4.0f, -3.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition scaredEyes = head.m_171599_("scaredEyes", CubeListBuilder.m_171558_().m_171514_(46, 36).m_171488_(-4.0f, -4.0f, -3.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(44, 7).m_171488_(-0.5f, -1.0f, -5.5f, 2.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)-14.0f, (float)2.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(44, 7).m_171480_().m_171488_(-1.5f, -1.0f, -5.5f, 2.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.5f, (float)-14.0f, (float)2.0f));
        PartDefinition leftLeg = everything.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(-2.0f, -0.1f, -5.0f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)-1.0f));
        PartDefinition rightLeg = everything.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171480_().m_171488_(-2.0f, -0.1f, -5.0f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_6162_()) {
            this.head.f_233553_ = 2.0f;
            this.head.f_233554_ = 2.0f;
            this.head.f_233555_ = 2.0f;
        }
        if (!((entity.m_20072_() || MiscUtils.isMovingHorizontally(entity)) && !((Penguin)((Object)entity)).isSlowSwimming() || ((Penguin)((Object)entity)).leaping || ((Penguin)((Object)entity)).falling || ((Penguin)((Object)entity)).tripAnimationTick > 0)) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        if (((Penguin)((Object)entity)).tripAnimationTick > 0) {
            this.m_233381_(((Penguin)((Object)entity)).tripAnimationState, PenguinKeyframeAnimations.PENGUIN_TRIP, ageInTicks);
        } else if (!((Penguin)((Object)entity)).falling) {
            if (MiscUtils.isMovingOnLand(entity)) {
                if (((Penguin)((Object)entity)).lookAnimationTick > 0) {
                    this.m_233381_(((Penguin)((Object)entity)).lookAnimationState, PenguinKeyframeAnimations.PENGUIN_LOOK, ageInTicks);
                }
                this.m_267799_(PenguinKeyframeAnimations.PENGUIN_WALK, limbSwing, limbSwingAmount, 1.5f, 2.5f);
            } else {
                if (((Penguin)((Object)entity)).lookAnimationTick > 0) {
                    this.m_233381_(((Penguin)((Object)entity)).lookAnimationState, PenguinKeyframeAnimations.PENGUIN_LOOK, ageInTicks);
                }
                if (entity.m_20072_() && !entity.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && (!MiscUtils.isMovingHorizontally(entity) || ((Penguin)((Object)entity)).isSlowSwimming())) {
                    PenguinSineWaveAnimations.penguinSwimIdleAnimation(this, SineWaveAnimationUtils.getTick(((Penguin)((Object)entity)).f_19797_, true), 1.0f, 1.0f);
                } else {
                    this.m_288214_(PenguinKeyframeAnimations.PENGUIN_IDLE);
                }
            }
        }
        ((Penguin)((Object)entity)).targetSwimAnimationAmount = entity.m_20072_() && MiscUtils.isMovingHorizontally(entity) && !((Penguin)((Object)entity)).isSlowSwimming() || ((Penguin)((Object)entity)).leaping || entity.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) ? 1.0f : 0.0f;
        ((Penguin)((Object)entity)).targetFallingAnimationAmount = ((Penguin)((Object)entity)).falling || ((Penguin)((Object)entity)).tripAnimationTick > 0 ? 1.0f : 0.0f;
        if (((Penguin)((Object)entity)).f_19797_ % 1 == 0) {
            ((Penguin)((Object)entity)).swimAnimationAmount = Mth.m_14179_((float)0.05f, (float)((Penguin)((Object)entity)).swimAnimationAmount, (float)((Penguin)((Object)entity)).targetSwimAnimationAmount);
            ((Penguin)((Object)entity)).fallingAnimationAmount = Mth.m_14179_((float)0.05f, (float)((Penguin)((Object)entity)).fallingAnimationAmount, (float)((Penguin)((Object)entity)).targetFallingAnimationAmount);
        }
        PenguinSineWaveAnimations.penguinSwimAnimation(this, SineWaveAnimationUtils.getTick(((Penguin)((Object)entity)).f_19797_, true), 1.0f, ((Penguin)((Object)entity)).swimAnimationAmount);
        if (((Penguin)((Object)entity)).tripAnimationTick <= 0) {
            PenguinSineWaveAnimations.penguinFallingAnimation(this, SineWaveAnimationUtils.getTick(((Penguin)((Object)entity)).f_19797_, true), 1.0f, ((Penguin)((Object)entity)).fallingAnimationAmount);
        }
        this.happyEyes.f_104207_ = ((Penguin)((Object)entity)).lookAnimationTick > 0;
        this.scaredEyes.f_104207_ = ((Penguin)((Object)entity)).tripAnimationTick > 0 || ((Penguin)((Object)entity)).falling;
    }

    private void animateHeadLookTarget(float yRot, float xRot) {
        this.head.f_104203_ = xRot * ((float)Math.PI / 180);
        this.head.f_104204_ = yRot * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

