/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.entities;

import com.alexander.whatareyouvotingfor.blocks.PenguinEggBlock;
import com.alexander.whatareyouvotingfor.init.BlockInit;
import com.alexander.whatareyouvotingfor.init.EntityTypeInit;
import com.alexander.whatareyouvotingfor.init.TagInit;
import com.alexander.whatareyouvotingfor.util.MiscUtils;
import com.alexander.whatareyouvotingfor.util.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class Penguin
extends Animal {
    private static final EntityDataAccessor<Float> SECONDARY_Y_ROT = SynchedEntityData.m_135353_(Penguin.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SLOW_SWIMMING = SynchedEntityData.m_135353_(Penguin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPT_INGREDIENTS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_});
    public AnimationState lookAnimationState = new AnimationState();
    public int lookAnimationTick;
    public final int lookAnimationLength = 80;
    public AnimationState tripAnimationState = new AnimationState();
    public int tripAnimationTick;
    public final int tripAnimationLength = 31;
    public final int tripAnimationActionPoint = 5;
    public boolean falling;
    public BlockPos homePos = null;
    public BlockPos eggPos = null;
    public float targetSwimAnimationAmount;
    public float swimAnimationAmount;
    public float targetFallingAnimationAmount;
    public float fallingAnimationAmount;
    public float swimmingXRot;
    public int followingBoatTick;
    public EntityDimensions swimmingDimensions = EntityDimensions.m_20395_((float)0.6f, (float)0.6f);
    public boolean leaping;
    public int goForASwimTime;
    public int goForASwimCooldown;
    public boolean wantsToGoForASwim;
    public boolean wasOnSolidBlock;
    public int fallLeapCooldown;
    public int fallingFor;
    public Vec3 trippingTowards;
    public boolean wantsToLayEgg;
    public boolean joiningHomePos;
    public int lookCooldown;
    public EntityDimensions lastDimensions = null;
    public boolean shouldTryToTurnIntoBaby = true;
    public boolean shouldUseSwimmingDimensions = false;

    public Penguin(EntityType<? extends Penguin> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new PenguinMoveControl(this);
        this.f_21365_ = new PenguinLookControl(this, 10);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ShareHomePosGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && Penguin.this.isSlowSwimming();
            }

            public void m_8037_() {
                if (Penguin.this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                    Penguin.this.m_20256_(new Vec3(Penguin.this.m_20184_().f_82479_, Mth.m_14008_((double)(Penguin.this.m_20184_().f_82480_ + 0.05), (double)-1.7976931348623157E308, (double)1.0), 0.0));
                } else {
                    Penguin.this.m_20256_(new Vec3(Penguin.this.m_20184_().f_82479_, Mth.m_14008_((double)(Penguin.this.m_20184_().f_82480_ + 0.01), (double)-1.7976931348623157E308, (double)1.0), 0.0));
                }
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new LeapFromWaterGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TripGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(4, (Goal)new SitOnEggGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal(this, 1.2){

            public void m_8056_() {
                super.m_8056_();
                Penguin.this.setSlowSwimming(true);
            }

            public void m_8041_() {
                super.m_8041_();
                Penguin.this.setSlowSwimming(false);
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new PenguinFollowBoatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPT_INGREDIENTS, false){

            public void m_8056_() {
                super.m_8056_();
                Penguin.this.setSlowSwimming(true);
            }

            public void m_8041_() {
                super.m_8041_();
                Penguin.this.setSlowSwimming(false);
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new FollowParentGoal((Animal)this, 1.4));
        this.f_21345_.m_25352_(9, (Goal)new GoBackHomeGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new SayHelloGoal(this, Player.class, 80, 200, 1.0, 8.0f, 4.0f, 12.0f, 40, 200));
        this.f_21345_.m_25352_(11, (Goal)new SayHelloGoal(this, Penguin.class, 140, 100, 1.0, 6.0f, 3.0f, 10.0f, 60, 120));
        this.f_21345_.m_25352_(12, (Goal)new PenguinRandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(13, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !Penguin.this.m_20072_();
            }
        });
        this.f_21345_.m_25352_(14, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(15, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public double m_20204_() {
        return this.m_20192_() - this.m_20206_() * 0.25f;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return this.leaping ? false : super.m_142535_(p_147187_, p_147188_, p_147189_);
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        return this.shouldUseSwimmingDimensions ? this.swimmingDimensions : super.m_6972_(p_21047_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public int m_5792_() {
        return 20;
    }

    public int m_8132_() {
        return this.m_20072_() && MiscUtils.isMovingHorizontally((Entity)this) ? 1 : super.m_8132_();
    }

    public int m_8085_() {
        return this.m_20072_() && MiscUtils.isMovingHorizontally((Entity)this) ? 1 : super.m_8085_();
    }

    public void m_7023_(Vec3 p_28383_) {
        if (this.m_21515_() && this.m_20069_()) {
            float speedMultiplier = this.isSlowSwimming() ? 0.25f : 1.0f;
            this.m_19920_(this.m_6113_() * speedMultiplier, p_28383_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_28383_);
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public static boolean canSpawn(EntityType<Penguin> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return !level.m_46801_(pos) && level.m_8055_(pos.m_7495_()).m_204336_(TagInit.Blocks.PENGUINS_SPAWNABLE_ON) && Penguin.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12188_;
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return SoundEvents.f_12192_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12189_;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.05f;
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12384_, 0.15f, 2.0f);
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12489_;
    }

    public boolean m_5957_() {
        return super.m_5957_() && this.eggPos == null;
    }

    protected PathNavigation m_6037_(Level p_30171_) {
        return new AmphibiousPathNavigation((Mob)this, p_30171_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.225f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SECONDARY_Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SLOW_SWIMMING, (Object)false);
    }

    public float getSecondaryYRot() {
        return ((Float)this.f_19804_.m_135370_(SECONDARY_Y_ROT)).floatValue();
    }

    public void setSecondaryYRot(float value) {
        this.f_19804_.m_135381_(SECONDARY_Y_ROT, (Object)Float.valueOf(value));
    }

    public boolean isSlowSwimming() {
        return (Boolean)this.f_19804_.m_135370_(SLOW_SWIMMING);
    }

    public void setSlowSwimming(boolean value) {
        this.f_19804_.m_135381_(SLOW_SWIMMING, (Object)value);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.eggPos != null) {
            tag.m_128405_("EggPosX", this.eggPos.m_123341_());
            tag.m_128405_("EggPosY", this.eggPos.m_123342_());
            tag.m_128405_("EggPosZ", this.eggPos.m_123343_());
        }
        if (this.homePos != null) {
            tag.m_128405_("HomePosX", this.homePos.m_123341_());
            tag.m_128405_("HomePosY", this.homePos.m_123342_());
            tag.m_128405_("HomePosZ", this.homePos.m_123343_());
        }
        tag.m_128405_("GoForASwimTime", this.goForASwimTime);
        tag.m_128405_("GoForASwimCooldown", this.goForASwimCooldown);
        tag.m_128379_("WantsToGoForASwim", this.wantsToGoForASwim);
        tag.m_128379_("WantsToLayEgg", this.wantsToLayEgg);
        tag.m_128379_("ShouldTryToTurnIntoBaby", this.shouldTryToTurnIntoBaby);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.eggPos = new BlockPos(tag.m_128451_("EggPosX"), tag.m_128451_("EggPosY"), tag.m_128451_("EggPosZ"));
        this.homePos = new BlockPos(tag.m_128451_("HomePosX"), tag.m_128451_("HomePosY"), tag.m_128451_("HomePosZ"));
        this.goForASwimTime = tag.m_128451_("GoForASwimTime");
        this.goForASwimCooldown = tag.m_128451_("GoForASwimCooldown");
        this.wantsToGoForASwim = tag.m_128471_("WantsToGoForASwim");
        this.wantsToLayEgg = tag.m_128471_("WantsToLayEgg");
        this.shouldTryToTurnIntoBaby = tag.m_128471_("ShouldTryToTurnIntoBaby");
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        boolean bl = this.shouldUseSwimmingDimensions = this.m_20072_() && MiscUtils.isMovingHorizontally((Entity)this) && !this.isSlowSwimming() || this.leaping || this.falling;
        if (this.lastDimensions != this.m_6972_(this.m_20089_())) {
            this.m_6210_();
        }
        this.lastDimensions = this.m_6972_(this.m_20089_());
        if (this.m_9236_() != null) {
            if (!this.m_9236_().f_46443_ && (this.homePos == null || MiscUtils.isZero(this.homePos))) {
                this.homePos = this.m_20183_();
            }
            if (!this.m_9236_().f_46443_ && this.homePos != null && !MiscUtils.isZero(this.homePos) && !this.isGoodHomePos(this.homePos) && this.isGoodHomePos(this.m_20183_())) {
                this.homePos = this.m_20183_();
            }
            if (!(this.m_9236_().f_46443_ || MiscUtils.isMovingHorizontally((Entity)this) || this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || this.lookCooldown > 0)) {
                this.lookCooldown = this.lookAnimationLength + 100 + this.f_19796_.m_188503_(300);
                this.lookAnimationTick = this.lookAnimationLength;
                this.m_9236_().m_7605_((Entity)this, (byte)4);
            }
            if (!this.m_9236_().f_46443_ && this.shouldTryToTurnIntoBaby && this.getSpawnType() != null && (this.getSpawnType() == MobSpawnType.NATURAL || this.getSpawnType() == MobSpawnType.CHUNK_GENERATION || this.getSpawnType() == MobSpawnType.STRUCTURE)) {
                if (this.f_19796_.m_188503_(6) == 0) {
                    this.m_146762_(-24000);
                }
                this.shouldTryToTurnIntoBaby = false;
            }
        }
        if (this.lookAnimationTick > 0 && MiscUtils.isMovingHorizontally((Entity)this)) {
            this.lookAnimationTick = 0;
        }
        if (this.lookCooldown > 0) {
            --this.lookCooldown;
        }
        if (this.followingBoatTick > 0) {
            --this.followingBoatTick;
        }
        if (this.leaping && (this.m_20096_() || !this.f_19800_ && this.m_20072_())) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.leaping = false;
        }
        if (this.falling) {
            ++this.fallingFor;
            if (this.fallingFor > 10 && (this.m_20096_() || this.m_20072_())) {
                this.fallLeapCooldown = 100;
                this.fallingFor = 0;
                this.falling = false;
            }
        }
        if (this.fallLeapCooldown > 0) {
            --this.fallLeapCooldown;
        }
        if (this.goForASwimCooldown > 0 && this.m_20072_()) {
            --this.goForASwimCooldown;
        }
        if (this.goForASwimTime > 0) {
            this.wantsToGoForASwim = false;
        }
        if (this.goForASwimCooldown > 0) {
            this.wantsToGoForASwim = true;
        }
        if (this.goForASwimTime > 0 && !this.m_20072_()) {
            --this.goForASwimTime;
        }
        if (this.goForASwimCooldown <= 0 && this.wantsToGoForASwim) {
            this.wantsToGoForASwim = false;
            this.goForASwimTime = 600 + this.f_19796_.m_188503_(3000);
        }
        if (this.goForASwimTime <= 0 && !this.wantsToGoForASwim) {
            this.wantsToGoForASwim = true;
            this.goForASwimCooldown = 600 + this.f_19796_.m_188503_(3000);
        }
        if (!this.m_9236_().f_46443_ && this.joiningHomePos && MiscUtils.distanceBetweenVecAndBlockPos(this.m_20182_(), this.homePos) <= 5.0f) {
            this.joiningHomePos = false;
        }
        Predicate<Entity> NOT_THIS = p_33346_ -> p_33346_.m_6084_() && p_33346_ != this;
        if (!this.m_9236_().f_46443_ && this.eggPos != null && !MiscUtils.isZero(this.eggPos) && MiscUtils.distanceBetweenVecAndBlockPos(this.m_20182_(), this.eggPos) <= 10.0f && this.m_9236_().m_6443_(Penguin.class, new AABB((double)((float)this.eggPos.m_123341_() - 0.3125f), (double)this.eggPos.m_123342_(), (double)((float)this.eggPos.m_123343_() - 0.3125f), (double)((float)this.eggPos.m_123341_() + 0.3125f), (double)(this.eggPos.m_123342_() + 2), (double)((float)this.eggPos.m_123343_() + 0.3125f)), NOT_THIS).size() > 0) {
            this.eggPos = null;
            this.f_21344_.m_26573_();
        }
        if (!(this.m_9236_().f_46443_ || this.m_6162_() || this.f_19797_ % 40 != 0 || this.eggPos != null && !MiscUtils.isZero(this.eggPos))) {
            AABB boundingBox = this.m_20191_().m_82377_(5.0, 1.0, 5.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)boundingBox.f_82288_), (int)Mth.m_14107_((double)boundingBox.f_82289_), (int)Mth.m_14107_((double)boundingBox.f_82290_), (int)Mth.m_14107_((double)boundingBox.f_82291_), (int)Mth.m_14107_((double)boundingBox.f_82292_), (int)Mth.m_14107_((double)boundingBox.f_82293_))) {
                if (!this.m_9236_().m_46749_(blockpos) || !(this.m_9236_().m_8055_(blockpos).m_60734_() instanceof PenguinEggBlock) || this.m_9236_().m_6443_(Penguin.class, new AABB((double)((float)blockpos.m_123341_() - 0.3125f), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() - 0.3125f), (double)((float)blockpos.m_123341_() + 0.3125f), (double)(blockpos.m_123342_() + 2), (double)((float)blockpos.m_123343_() + 0.3125f)), NOT_THIS).size() > 0) continue;
                this.eggPos = blockpos;
                break;
            }
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0 && this.wantsToLayEgg && MiscUtils.distanceBetweenVecAndBlockPos(this.m_20182_(), this.homePos) <= 5.0f && !this.m_20072_() && this.m_20096_() && this.m_9236_().m_8055_(this.m_20183_()).m_60795_()) {
            this.m_9236_().m_46597_(this.m_20183_(), ((Block)BlockInit.PENGUIN_EGG.get()).m_49966_());
            this.m_216990_(SoundEvents.f_12486_);
            this.m_21569_().m_24901_();
            this.eggPos = this.m_20183_();
            this.wantsToLayEgg = false;
        }
    }

    public boolean isGoodHomePos(BlockPos pos) {
        return !this.m_9236_().m_46801_(pos) && !this.m_9236_().m_8055_(pos.m_7495_()).m_60795_() && !this.m_9236_().m_8055_(pos.m_7495_()).m_60812_((BlockGetter)this.m_9236_(), pos.m_7495_()).m_83281_();
    }

    public boolean emptyBlockPos(BlockPos pos) {
        return this.m_9236_().m_8055_(pos).m_60795_() || this.m_9236_().m_8055_(pos).m_60812_((BlockGetter)this.m_9236_(), pos).m_83281_();
    }

    public void tickDownAnimTimers() {
        if (this.lookAnimationTick > 0) {
            --this.lookAnimationTick;
        }
        if (this.m_9236_().f_46443_ && this.lookAnimationTick <= 0) {
            this.lookAnimationState.m_216973_();
        }
        if (this.tripAnimationTick > 0) {
            --this.tripAnimationTick;
            if (this.tripAnimationTick == 0) {
                this.falling = true;
            }
        }
        if (this.m_9236_().f_46443_ && this.tripAnimationTick <= 0) {
            this.tripAnimationState.m_216973_();
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.lookAnimationTick = this.lookAnimationLength;
            this.lookAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.tripAnimationTick = this.tripAnimationLength;
            this.tripAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 6) {
            this.followingBoatTick = 10;
        } else if (p_21375_ == 7) {
            this.leaping = true;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public boolean m_6898_(ItemStack p_29446_) {
        return TEMPT_INGREDIENTS.test(p_29446_);
    }

    public void m_27563_(ServerLevel pLevel, Animal pMate) {
        this.wantsToLayEgg = true;
        this.m_146762_(6000);
        pMate.m_146762_(6000);
        this.m_27594_();
        pMate.m_27594_();
        pLevel.m_7605_((Entity)this, (byte)18);
        if (pLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            pLevel.m_7967_((Entity)new ExperienceOrb((Level)pLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
        }
    }

    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)EntityTypeInit.PENGUIN.get()).m_20615_((Level)pLevel);
    }

    static class PenguinMoveControl
    extends MoveControl {
        private final Penguin penguin;
        private final int maxTurnX = 85;
        private final int maxTurnY = 20;
        private final float inWaterSpeedModifier = 1.0f;
        private final boolean applyGravity = true;

        PenguinMoveControl(Penguin p_30286_) {
            super((Mob)p_30286_);
            this.penguin = p_30286_;
        }

        public void m_8126_() {
            if (this.penguin.m_20072_() && !this.penguin.isSlowSwimming()) {
                Objects.requireNonNull(this);
                if (this.f_24974_.m_20069_()) {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                    double d2;
                    double d1;
                    double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                    double d3 = d0 * d0 + (d1 = this.f_24976_ - this.f_24974_.m_20186_()) * d1 + (d2 = this.f_24977_ - this.f_24974_.m_20189_()) * d2;
                    if (d3 < 2.500000277905201E-7) {
                        this.f_24974_.m_21564_(0.0f);
                    } else {
                        float f;
                        float f2 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                        float f3 = this.f_24974_.m_146908_();
                        if (this.penguin.followingBoatTick > 0) {
                            f = 10.0f;
                        } else {
                            Objects.requireNonNull(this);
                            f = 20.0f;
                        }
                        this.f_24974_.m_146922_(this.m_24991_(f3, f2, f));
                        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                        this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                        float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                        this.f_24974_.m_7910_(f1 * this.inWaterSpeedModifier);
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                            float f32 = -((float)(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                            float f4 = Mth.m_14177_((float)f32);
                            float f5 = -this.maxTurnX;
                            Objects.requireNonNull(this);
                            f32 = Mth.m_14036_((float)f4, (float)f5, (float)85.0f);
                            this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f32, 5.0f));
                        }
                        float f6 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                        this.f_24974_.f_20902_ = f6 * f1;
                        this.f_24974_.f_20901_ = -f4 * f1;
                    }
                } else {
                    this.f_24974_.m_7910_(0.0f);
                    this.f_24974_.m_21570_(0.0f);
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                }
            } else {
                super.m_8126_();
            }
        }
    }

    public class PenguinLookControl
    extends SmoothSwimmingLookControl {
        public Penguin penguin;

        public PenguinLookControl(Penguin p_148061_, int p_148062_) {
            super((Mob)p_148061_, p_148062_);
            this.penguin = p_148061_;
        }

        public void m_8128_() {
            if (this.penguin.falling || this.penguin.tripAnimationTick > 0 || this.penguin.leaping) {
                this.f_24937_.m_146922_(this.penguin.getSecondaryYRot());
                this.f_24937_.m_5618_(this.penguin.getSecondaryYRot());
                this.f_24937_.m_5616_(this.penguin.getSecondaryYRot());
                this.f_24937_.f_19859_ = this.penguin.getSecondaryYRot();
                this.f_24937_.f_20884_ = this.penguin.getSecondaryYRot();
                this.f_24937_.f_20886_ = this.penguin.getSecondaryYRot();
            } else if (this.f_24937_.m_20072_() && MiscUtils.isMovingHorizontally((Entity)this.f_24937_) && !this.penguin.isSlowSwimming()) {
                super.m_8128_();
            } else {
                if (this.m_8106_()) {
                    this.f_24937_.m_146926_(0.0f);
                }
                if (this.f_186068_ > 0) {
                    --this.f_186068_;
                    this.m_180896_().ifPresent(p_287447_ -> {
                        this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, p_287447_.floatValue(), this.f_24938_);
                    });
                    this.m_180897_().ifPresent(p_289400_ -> this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), p_289400_.floatValue(), this.f_24939_)));
                } else {
                    this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, this.f_24937_.f_20883_, 10.0f);
                }
                this.m_142586_();
            }
        }
    }

    public class ShareHomePosGoal
    extends Goal {
        public static final Predicate<Penguin> BAD_HOME_POS = entity -> entity.m_6084_() && entity.f_19797_ > 40 && (entity.homePos == null || MiscUtils.isZero(entity.homePos) || entity.homePos != null && !MiscUtils.isZero(entity.homePos) && !entity.isGoodHomePos(entity.homePos));
        public Penguin mob;
        public List<Penguin> penguinsToAlert = Lists.newArrayList();
        public int nextUseTime;

        public ShareHomePosGoal(Penguin mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = mob;
        }

        public boolean m_8036_() {
            this.penguinsToAlert = this.mob.m_9236_().m_6443_(Penguin.class, this.mob.m_20191_().m_82400_(100.0), BAD_HOME_POS);
            if (this.penguinsToAlert.contains((Object)this.mob)) {
                this.penguinsToAlert.remove((Object)this.mob);
            }
            return this.mob.f_19797_ > 40 && this.mob.f_19797_ >= this.nextUseTime && this.mob.homePos != null && !MiscUtils.isZero(this.mob.homePos) && this.mob.isGoodHomePos(this.mob.homePos) && this.penguinsToAlert.size() > 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            for (Penguin penguin : this.penguinsToAlert) {
                penguin.homePos = this.mob.homePos;
                penguin.joiningHomePos = true;
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.nextUseTime = this.mob.f_19797_ + 100;
        }
    }

    public class LeapFromWaterGoal
    extends Goal {
        public Penguin mob;
        public BlockPos leapToPos = BlockPos.f_121853_;
        public boolean leapt = false;
        public int nextUseTime;
        public int usingFor;

        public LeapFromWaterGoal(Penguin mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (this.mob.f_19797_ < this.nextUseTime || this.mob.f_19797_ < 100 || this.mob.fallLeapCooldown > 0 || this.mob.m_20159_()) {
                return false;
            }
            if (this.mob.f_19797_ % 5 == 0) {
                this.findLeapToPos();
            }
            return this.leapToPos != null && !MiscUtils.isZero(this.leapToPos);
        }

        public boolean m_8045_() {
            return this.leapToPos != null && !MiscUtils.isZero(this.leapToPos) && (!this.leapt || this.mob.leaping) && this.usingFor < 100;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            double d0 = (double)this.leapToPos.m_123341_() - this.mob.m_20185_();
            double d1 = (double)this.leapToPos.m_123342_() - this.mob.m_20186_();
            double d2 = (double)this.leapToPos.m_123343_() - this.mob.m_20189_();
            if (MiscUtils.horizontalDistanceBetweenBlockPos(this.mob.m_20183_(), this.leapToPos) <= 15.0f) {
                double d9 = this.mob.m_146892_().f_82479_;
                double d3 = this.mob.m_146892_().f_82481_;
                double d4 = (double)this.leapToPos.m_123341_() - d9;
                double d6 = (double)this.leapToPos.m_123343_() - d3;
                float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                this.mob.setSecondaryYRot(f);
                if (this.mob.m_20072_()) {
                    this.mob.leaping = true;
                    this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)7);
                    this.mob.m_20334_(d0 * 0.1, 0.75 + Mth.m_14008_((double)(d1 * 0.1), (double)0.0, (double)10.0), d2 * 0.1);
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(d0 * 0.01, 0.0, d2 * 0.01));
                    this.mob.m_21573_().m_26573_();
                }
            }
            if (this.mob.leaping) {
                this.leapt = true;
            }
            ++this.usingFor;
        }

        public void m_8041_() {
            super.m_8041_();
            this.leapToPos = BlockPos.f_121853_;
            this.leapt = false;
            this.nextUseTime = this.mob.f_19797_ + 100;
            this.usingFor = 0;
        }

        public void findLeapToPos() {
            if (this.mob.m_20072_() && this.mob.m_21573_().m_26570_() != null && !this.mob.m_21573_().m_26571_() && this.mob.m_21573_().m_26567_() != null && this.mob.m_21573_().m_26567_() != BlockPos.f_121853_ && this.mob.m_9236_().m_6425_(this.mob.m_21573_().m_26567_()).m_76178_() && !this.mob.emptyBlockPos(this.mob.m_21573_().m_26567_().m_7495_())) {
                BlockPos targetPos = this.mob.m_21573_().m_26567_();
                ArrayList posList = Lists.newArrayList();
                BlockPos lastFluidPos = BlockPos.f_121853_;
                int i = 0;
                while ((float)i < MiscUtils.distanceBetweenVecAndBlockPos(this.mob.m_20182_(), targetPos)) {
                    double d9 = this.mob.m_146892_().f_82479_;
                    double d3 = this.mob.m_146892_().f_82481_;
                    double d4 = (double)targetPos.m_123341_() - d9;
                    double d6 = (double)targetPos.m_123343_() - d3;
                    float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                    BlockPos pos = PositionUtils.getOffsetBlockPos((Entity)this.mob, 0.0, 0.0, i, 0.0f, f).m_7494_();
                    if (this.mob.m_9236_().m_46749_(pos)) {
                        pos = PositionUtils.moveBlockPosToCorrectHeight(pos, this.mob.m_9236_());
                        posList.add(pos);
                        if (!this.mob.m_9236_().m_6425_(pos).m_76178_()) {
                            lastFluidPos = pos;
                        }
                    }
                    i += 2;
                }
                if (lastFluidPos != null && !MiscUtils.isZero(lastFluidPos) && posList.contains(lastFluidPos)) {
                    for (i = posList.indexOf(lastFluidPos); i < posList.size(); ++i) {
                        if (!(MiscUtils.horizontalDistanceBetweenBlockPos(lastFluidPos, (BlockPos)posList.get(i)) <= 10.0f)) continue;
                        this.leapToPos = (BlockPos)posList.get(i);
                    }
                }
            }
        }
    }

    public class TripGoal
    extends Goal {
        public Penguin mob;

        public TripGoal(Penguin mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = mob;
        }

        public boolean m_8036_() {
            boolean returnValue = !this.mob.m_20072_() && !this.mob.m_21523_() && !this.mob.m_20159_() && this.mob.fallLeapCooldown <= 0 && !this.mob.leaping && this.mob.m_20096_() && this.mob.wasOnSolidBlock && this.mob.tripAnimationTick <= 0 && (this.mob.emptyBlockPos(this.mob.m_20183_().m_7495_()) && this.mob.emptyBlockPos(this.mob.m_20183_().m_7495_().m_7495_()) || this.mob.emptyBlockPos(this.mob.m_20183_().m_7495_()) && this.mob.f_19796_.m_188503_(5) == 0);
            this.mob.wasOnSolidBlock = !this.mob.emptyBlockPos(this.mob.m_20183_().m_7495_());
            return returnValue;
        }

        public boolean m_8045_() {
            return this.mob.tripAnimationTick > 0 || this.mob.falling;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.tripAnimationTick = this.mob.tripAnimationLength;
            this.mob.fallingFor = 0;
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)5);
            this.mob.trippingTowards = this.mob.m_20182_().m_82549_(this.mob.m_20184_().m_82542_(5.0, 0.0, 5.0));
            double d9 = this.mob.m_146892_().f_82479_;
            double d3 = this.mob.m_146892_().f_82481_;
            double d4 = this.mob.trippingTowards.f_82479_ - d9;
            double d6 = this.mob.trippingTowards.f_82481_ - d3;
            float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
            this.mob.setSecondaryYRot(f);
        }

        public void m_8037_() {
            super.m_8037_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.trippingTowards != null && !this.mob.falling) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.trippingTowards);
            }
            if (this.mob.tripAnimationTick <= this.mob.tripAnimationActionPoint || this.mob.falling) {
                Vec3 motion = PositionUtils.getOffsetMotion((Entity)this.mob, 0.0, 0.0, 0.25, 0.0f, this.mob.getSecondaryYRot());
                this.mob.m_20334_(motion.f_82479_, this.mob.m_20184_().f_82480_, motion.f_82481_);
            } else {
                this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
            }
        }
    }

    public class SitOnEggGoal
    extends MoveToBlockGoal {
        public Penguin mob;

        public SitOnEggGoal(Penguin mob) {
            super((PathfinderMob)mob, 1.3, 1);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (this.mob.eggPos != null && this.mob.m_9236_().m_46749_(this.mob.eggPos) && this.mob.m_9236_().m_8055_(this.mob.eggPos).m_60734_() != BlockInit.PENGUIN_EGG.get()) {
                this.mob.eggPos = null;
            } else {
                this.f_25602_ = this.mob.eggPos;
            }
            return !this.mob.m_6162_() && this.f_25602_ != null;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.mob.m_9236_().f_46443_ && this.mob.eggPos != null && !MiscUtils.isZero(this.mob.eggPos) && MiscUtils.distanceBetweenVecAndBlockPos(this.mob.m_20182_(), this.mob.eggPos) <= 1.0f) {
                double d0 = (double)Penguin.this.eggPos.m_123341_() + 0.5 - this.mob.m_20185_();
                double d2 = (double)Penguin.this.eggPos.m_123343_() + 0.5 - this.mob.m_20189_();
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(d0 * 0.1, 0.0, d2 * 0.1));
            }
        }

        public double m_8052_() {
            return 0.0;
        }

        public boolean m_8064_() {
            return true;
        }

        protected boolean m_6465_(LevelReader p_25619_, BlockPos p_25620_) {
            return p_25620_ == this.mob.eggPos;
        }
    }

    public class PenguinFollowBoatGoal
    extends Goal {
        private int timeToRecalcPath;
        private final PathfinderMob mob;
        @Nullable
        private Player following;
        private BoatGoals currentGoal;

        public PenguinFollowBoatGoal(PathfinderMob p_25238_) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = p_25238_;
        }

        public boolean m_8036_() {
            List list = this.mob.m_9236_().m_45976_(Boat.class, this.mob.m_20191_().m_82400_(25.0));
            boolean flag = false;
            for (Boat boat : list) {
                LivingEntity entity = boat.m_6688_();
                if (!(entity instanceof Player) || !(Mth.m_14154_((float)((Player)entity).f_20900_) > 0.0f) && !(Mth.m_14154_((float)((Player)entity).f_20902_) > 0.0f)) continue;
                flag = true;
                break;
            }
            return this.following != null && (Mth.m_14154_((float)this.following.f_20900_) > 0.0f || Mth.m_14154_((float)this.following.f_20902_) > 0.0f) || flag;
        }

        public boolean m_6767_() {
            return true;
        }

        public boolean m_8045_() {
            return this.following != null && this.following.m_20159_() && (Mth.m_14154_((float)this.following.f_20900_) > 0.0f || Mth.m_14154_((float)this.following.f_20902_) > 0.0f);
        }

        public void m_8056_() {
            for (Boat boat : this.mob.m_9236_().m_45976_(Boat.class, this.mob.m_20191_().m_82400_(25.0))) {
                if (boat.m_6688_() == null || !(boat.m_6688_() instanceof Player)) continue;
                this.following = (Player)boat.m_6688_();
                break;
            }
            this.timeToRecalcPath = 0;
            this.currentGoal = BoatGoals.GO_TO_BOAT;
        }

        public void m_8041_() {
            this.following = null;
        }

        public void m_8037_() {
            boolean flag;
            boolean bl = flag = Mth.m_14154_((float)this.following.f_20900_) > 0.0f || Mth.m_14154_((float)this.following.f_20902_) > 0.0f;
            float f = this.currentGoal == BoatGoals.GO_IN_BOAT_DIRECTION ? (flag ? 0.01f : 0.0f) : 0.015f;
            this.mob.m_19920_(f, new Vec3((double)this.mob.f_20900_, (double)this.mob.f_20901_, (double)this.mob.f_20902_));
            this.mob.m_6478_(MoverType.SELF, this.mob.m_20184_());
            ((Penguin)this.mob).followingBoatTick = 10;
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)6);
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.currentGoal == BoatGoals.GO_TO_BOAT) {
                    BlockPos blockpos = this.following.m_20183_().m_121945_(this.following.m_6350_().m_122424_());
                    blockpos = blockpos.m_7918_(0, -1, 0);
                    this.mob.m_21573_().m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_() - 3.0, (double)blockpos.m_123343_(), 1.5);
                    if (this.mob.m_20270_((Entity)this.following) < 4.0f) {
                        this.timeToRecalcPath = 0;
                        this.currentGoal = BoatGoals.GO_IN_BOAT_DIRECTION;
                    }
                } else if (this.currentGoal == BoatGoals.GO_IN_BOAT_DIRECTION) {
                    Direction direction = this.following.m_6374_();
                    BlockPos blockpos1 = this.following.m_20183_().m_5484_(direction, 10);
                    this.mob.m_21573_().m_26519_((double)blockpos1.m_123341_(), (double)(blockpos1.m_123342_() - 4), (double)blockpos1.m_123343_(), 1.5);
                    if (this.mob.m_20270_((Entity)this.following) > 12.0f) {
                        this.timeToRecalcPath = 0;
                        this.currentGoal = BoatGoals.GO_TO_BOAT;
                    }
                }
            }
        }

        static enum BoatGoals {
            GO_TO_BOAT,
            GO_IN_BOAT_DIRECTION;

        }
    }

    public class GoBackHomeGoal
    extends Goal {
        public Penguin mob;

        public GoBackHomeGoal(Penguin mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean m_8036_() {
            int tooFarDistance = this.mob.m_20072_() || Penguin.this.wantsToGoForASwim ? 80 : 15;
            return this.mob.followingBoatTick <= 0 && this.mob.homePos != null && !MiscUtils.isZero(this.mob.homePos) && this.mob.isGoodHomePos(this.mob.homePos) && (MiscUtils.distanceToBlockPos((Entity)this.mob, this.mob.homePos) > (float)tooFarDistance || this.mob.m_20072_() && !this.mob.wantsToGoForASwim || this.mob.wantsToLayEgg || this.mob.joiningHomePos);
        }

        public boolean m_8045_() {
            return this.mob.followingBoatTick <= 0 && this.mob.homePos != null && !MiscUtils.isZero(this.mob.homePos) && this.mob.isGoodHomePos(this.mob.homePos) && MiscUtils.distanceToBlockPos((Entity)this.mob, this.mob.homePos) > 2.0f;
        }

        public void m_8037_() {
            super.m_8037_();
            this.mob.m_21573_().m_26519_((double)this.mob.homePos.m_123341_(), (double)this.mob.homePos.m_123342_(), (double)this.mob.homePos.m_123343_(), 1.0);
        }
    }

    public class SayHelloGoal
    extends Goal {
        public Penguin mob;
        public final Class<? extends LivingEntity> sayHelloToClass;
        public final int chance;
        public final int cooldown;
        public final double speed;
        public final float searchRange;
        public final float closeEnoughDistance;
        public final float tooFarDistance;
        public final int minStayDuration;
        public final int maxStayDuration;
        public int stayDuration;
        public int nextUseTime;
        public int stayingFor;
        public LivingEntity sayingHelloToEntity;

        public SayHelloGoal(Penguin mob, Class<? extends LivingEntity> sayHelloToClass, int chance, int cooldown, double speed, float searchRange, float closeEnoughDistance, float tooFarDistance, int minStayDuration, int maxStayDuration) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = mob;
            this.sayHelloToClass = sayHelloToClass;
            this.chance = chance;
            this.cooldown = cooldown;
            this.speed = speed;
            this.searchRange = searchRange;
            this.closeEnoughDistance = closeEnoughDistance;
            this.tooFarDistance = tooFarDistance;
            this.minStayDuration = minStayDuration;
            this.maxStayDuration = maxStayDuration;
        }

        public boolean m_8036_() {
            if (this.mob.f_19796_.m_188503_(this.chance) != 0) {
                return false;
            }
            Predicate<LivingEntity> CORRECT = entity -> entity.m_6084_() && entity != this.mob && this.mob.m_142582_((Entity)entity) && entity.m_6087_();
            List nearbyFollowableEntities = this.mob.m_9236_().m_6443_(this.sayHelloToClass, this.mob.m_20191_().m_82400_((double)this.searchRange), CORRECT);
            this.sayingHelloToEntity = null;
            if (nearbyFollowableEntities.size() > 0) {
                this.sayingHelloToEntity = (LivingEntity)nearbyFollowableEntities.get(this.mob.f_19796_.m_188503_(nearbyFollowableEntities.size()));
            }
            return this.mob.f_19797_ >= this.nextUseTime && this.sayingHelloToEntity != null;
        }

        public boolean m_8045_() {
            return this.sayingHelloToEntity != null && this.stayingFor < this.stayDuration && this.mob.m_20270_((Entity)this.sayingHelloToEntity) < this.tooFarDistance;
        }

        public void m_8056_() {
            super.m_8056_();
            this.stayDuration = this.minStayDuration + this.mob.f_19796_.m_188503_(this.maxStayDuration - this.minStayDuration);
            this.stayingFor = 0;
            this.mob.setSlowSwimming(true);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.stayingFor;
            if (this.sayingHelloToEntity != null) {
                this.mob.m_21563_().m_148051_((Entity)this.sayingHelloToEntity);
                if (this.sayingHelloToEntity instanceof Mob && !MiscUtils.isMovingHorizontally((Entity)this.sayingHelloToEntity)) {
                    ((Mob)this.sayingHelloToEntity).m_21563_().m_148051_((Entity)this.mob);
                }
                if (this.mob.m_20270_((Entity)this.sayingHelloToEntity) <= this.closeEnoughDistance) {
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.sayingHelloToEntity, this.speed);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.nextUseTime = this.mob.f_19797_ + this.cooldown;
            this.mob.setSlowSwimming(false);
        }
    }

    public class PenguinRandomSwimmingGoal
    extends RandomStrollGoal {
        public PenguinRandomSwimmingGoal(PathfinderMob p_25753_, double p_25754_, int p_25755_) {
            super(p_25753_, p_25754_, p_25755_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && (Penguin.this.m_20072_() || Penguin.this.wantsToGoForASwim);
        }

        @Nullable
        protected Vec3 m_7037_() {
            return BehaviorUtils.m_147444_((PathfinderMob)this.f_25725_, (int)50, (int)30);
        }
    }
}

