/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.blocks;

import com.alexander.whatareyouvotingfor.entities.Penguin;
import com.alexander.whatareyouvotingfor.init.EntityTypeInit;
import com.alexander.whatareyouvotingfor.util.PositionUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class PenguinEggBlock
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    private static final VoxelShape BOUNDING_BOX = Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;

    public PenguinEggBlock(BlockBehaviour.Properties p_57759_) {
        super(p_57759_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public void m_213898_(BlockState p_222644_, ServerLevel p_222645_, BlockPos p_222646_, RandomSource p_222647_) {
        if (this.shouldUpdateHatchLevel((Level)p_222645_, p_222646_)) {
            int i = (Integer)p_222644_.m_61143_((Property)HATCH);
            if (i < 2) {
                p_222645_.m_5594_((Player)null, p_222646_, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + p_222647_.m_188501_() * 0.2f);
                p_222645_.m_7731_(p_222646_, (BlockState)p_222644_.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                p_222645_.m_5594_((Player)null, p_222646_, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + p_222647_.m_188501_() * 0.2f);
                p_222645_.m_7471_(p_222646_, false);
                p_222645_.m_46796_(2001, p_222646_, Block.m_49956_((BlockState)p_222644_));
                Penguin penguin = (Penguin)((EntityType)EntityTypeInit.PENGUIN.get()).m_20615_((Level)p_222645_);
                penguin.m_146762_(-24000);
                penguin.m_20035_(p_222646_, 0.0f, 0.0f);
                p_222645_.m_7967_((Entity)penguin);
                penguin.m_20256_(PositionUtils.getOffsetMotion((Entity)penguin, 0.0, 0.0, 0.1, 0.0f, penguin.f_20883_));
                for (ServerPlayer serverplayerentity1 : p_222645_.m_45976_(ServerPlayer.class, penguin.m_20191_().m_82400_(10.0))) {
                    CriteriaTriggers.f_10580_.m_68256_(serverplayerentity1, (Entity)penguin);
                }
            }
        }
    }

    private boolean shouldUpdateHatchLevel(Level level, BlockPos pos) {
        return level.f_46441_.m_188503_(10) == 0 && level.m_45976_(Penguin.class, new AABB((double)((float)pos.m_123341_() - 0.3125f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() - 0.3125f), (double)((float)pos.m_123341_() + 0.3125f), (double)(pos.m_123342_() + 2), (double)((float)pos.m_123343_() + 0.3125f))).size() > 0;
    }

    public VoxelShape m_5940_(BlockState p_57809_, BlockGetter p_57810_, BlockPos p_57811_, CollisionContext p_57812_) {
        return BOUNDING_BOX;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57799_) {
        p_57799_.m_61104_(new Property[]{HATCH});
    }

    public void m_142072_(Level p_154845_, BlockState p_154846_, BlockPos p_154847_, Entity p_154848_, float p_154849_) {
        if (!p_154845_.f_46443_ && this.canDestroyEgg(p_154845_, p_154848_) && p_154845_.f_46441_.m_188503_(3) == 0) {
            p_154845_.m_5594_((Player)null, p_154847_, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + p_154845_.f_46441_.m_188501_() * 0.2f);
            p_154845_.m_46961_(p_154847_, false);
        }
        super.m_142072_(p_154845_, p_154846_, p_154847_, p_154848_, p_154849_);
    }

    private boolean canDestroyEgg(Level p_57768_, Entity p_57769_) {
        if (!(p_57769_ instanceof Penguin) && !(p_57769_ instanceof Bat)) {
            if (!(p_57769_ instanceof LivingEntity)) {
                return false;
            }
            return p_57769_ instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)p_57768_, (Entity)p_57769_);
        }
        return false;
    }
}

